/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.bucket;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.web.bucket.Bucket;
import com.ibm.es.nuvo.crawler.web.bucket.FederatedBucketManager;
import com.ibm.es.nuvo.crawler.web.db.tables.IPTable;
import com.ibm.es.nuvo.crawler.web.rule.WebSpace;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.es.nuvo.logging.Loggers;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

public class DNSResolver {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static ExtendedLogger logger = Loggers.logger;
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + DNSResolver.class.getName());
    private static DNSResolver instance = new DNSResolver();

    private DNSResolver() {
    }

    public static DNSResolver instance() {
        return instance;
    }

    public void resolve(Bucket bucket) {
        this.resolve(bucket, new ReentrantLock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolve(Bucket bucket, Lock lock) {
        boolean retrieved;
        block20: {
            boolean persistent = bucket.getManager().isPersistent();
            if (persistent && !FederatedBucketManager.instance().isActive(bucket.getConfig().getId())) {
                return;
            }
            retrieved = false;
            ArrayList<InetAddress> list = new ArrayList<InetAddress>();
            WebSpace m_localWS = bucket.getConfig().getWebSpace();
            if (m_localWS.isAllowed(bucket)) {
                try {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finer("Start lookup " + bucket.getHostname());
                    }
                    if (bucket.getProxyAddress() == null) {
                        InetAddress[] addresses = InetAddress.getAllByName(bucket.getHostname());
                        if (addresses != null) {
                            for (InetAddress address : addresses) {
                                if (m_localWS.isAllowed(address)) {
                                    bucket.addInetAddress(address);
                                    list.add(address);
                                    continue;
                                }
                                if (!logger.isLoggable(Level.INFO)) continue;
                                logger.log(Level.INFO, "C5003I.DNS_DISALLOW_IP", new Object[]{address.toString(), bucket.getHostname()});
                            }
                        }
                        if (persistent) {
                            lock.lock();
                            try {
                                IPTable.getInstance(bucket.getConfig().getId()).update(bucket.getHostHash().longValue(), list);
                            }
                            finally {
                                lock.unlock();
                            }
                        }
                        retrieved = true;
                        list.clear();
                        break block20;
                    }
                    retrieved = true;
                }
                catch (UnknownHostException uhe) {
                    if (tracer.isLoggable(Level.FINE)) {
                        tracer.log(Level.FINE, "Unknown host " + bucket.getHostname());
                    }
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.WARNING)) break block20;
                    Message message = new Message("C4910W.DNS_LOOKUP_FAIL", bucket.getHostname());
                    ExtendedException exception = new ExtendedException(message, (Throwable)e);
                    logger.log(Level.WARNING, exception);
                }
            }
        }
        if (retrieved) {
            bucket.zeroDNSFailCount();
            if (tracer.isLoggable(Level.FINER)) {
                tracer.finer("Lookup success: " + bucket.getHostname());
            }
        } else {
            bucket.incrDNSFailCount();
            if (tracer.isLoggable(Level.FINER)) {
                tracer.finer("Lookup failed : " + bucket.getHostname());
            }
        }
        bucket.updateDNSDate();
    }
}

