/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.bucket;

import com.ibm.es.nuvo.crawler.web.bucket.Bucket;
import com.ibm.es.nuvo.crawler.web.bucket.BucketManager;
import com.ibm.es.nuvo.crawler.web.configuration.CrawlerConfig;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BucketSelector {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + BucketSelector.class.getName());
    private Collection<BucketManager> managers = new HashSet<BucketManager>();
    private BucketComparator<Bucket> bucketComparator = new BucketComparator();
    private Map<BucketManager, Bucket> readyBuckets = new HashMap<BucketManager, Bucket>();

    public synchronized void setManagers(Collection<BucketManager> managers) {
        this.managers.clear();
        this.managers.addAll(managers);
        this.adjust();
        this.fillReadyBuckets();
    }

    public synchronized void adjust() {
        if (this.managers == null || this.managers.size() == 0) {
            return;
        }
        int totalRequested = 0;
        for (BucketManager manager : this.managers) {
            totalRequested += manager.getConfig().getMaxConnections();
        }
        if (totalRequested == 0) {
            return;
        }
        int maxConnections = CrawlerConfig.getInstance().getBucketConfig().getMaxActive();
        for (BucketManager manager : this.managers) {
            int max = manager.getConfig().getMaxConnections();
            int n = max * maxConnections / totalRequested + 1;
            n = Math.min(n, maxConnections);
            manager.setBucketLimit(n);
        }
        for (BucketManager manager : this.managers) {
            List<Bucket> buckets = manager.getActiveBuckets();
            int limit = manager.getBucketLimit();
            if (buckets.size() < limit) continue;
            Collections.sort(buckets, this.bucketComparator);
            if (tracer.isLoggable(Level.FINER)) {
                tracer.finer(buckets.toString());
            }
            for (Bucket bucket : buckets) {
                if (limit-- > 0) continue;
                if (tracer.isLoggable(Level.FINER)) {
                    tracer.finer("Terminated " + bucket + " " + bucket.getUncrawledCount());
                }
                bucket.terminate();
            }
        }
    }

    public synchronized Bucket getEmptyBucket() {
        if (this.fillReadyBuckets() == 0) {
            return null;
        }
        if (tracer.isLoggable(Level.FINEST)) {
            tracer.finest(this.readyBuckets.keySet().toString());
        }
        double min = 1.0;
        BucketManager target = null;
        for (BucketManager manager : this.managers) {
            double r = (double)manager.countBucketsInState(Bucket.State.CRAWLING) / (double)manager.getBucketLimit();
            if (!(r < min) || this.readyBuckets.get(manager) == null) continue;
            min = r;
            target = manager;
        }
        if (target != null) {
            return this.readyBuckets.remove(target);
        }
        return null;
    }

    private synchronized int fillReadyBuckets() {
        if (this.managers == null || this.managers.size() == 0) {
            this.readyBuckets.clear();
            return 0;
        }
        ArrayList<BucketManager> list = new ArrayList<BucketManager>();
        for (BucketManager manager : this.readyBuckets.keySet()) {
            if (this.managers.contains(manager)) continue;
            list.add(manager);
        }
        for (BucketManager manager : list) {
            this.readyBuckets.remove(manager);
        }
        int count = this.managers.size();
        for (BucketManager manager : this.managers) {
            if (this.readyBuckets.get(manager) != null) continue;
            Bucket emptyBucket = manager.getEmptyBucket();
            if (emptyBucket == null) {
                --count;
                continue;
            }
            this.readyBuckets.put(manager, emptyBucket);
        }
        if (tracer.isLoggable(Level.FINEST)) {
            tracer.finest("Ready " + count);
        }
        return count;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BucketComparator<T>
    implements Comparator<Object>,
    Serializable {
        private static final long serialVersionUID = -1823368584898287794L;

        private BucketComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 == o2 || o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null || o2 == null) {
                return -1;
            }
            Bucket src = (Bucket)o1;
            Bucket dst = (Bucket)o2;
            return dst.getUncrawledCount() - src.getUncrawledCount();
        }
    }
}

