/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.bucket;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.util.hash.Hash64;
import com.ibm.es.nuvo.crawler.web.WebCrawler;
import com.ibm.es.nuvo.crawler.web.admin.WCMonitor;
import com.ibm.es.nuvo.crawler.web.bucket.ActiveBucketInfo;
import com.ibm.es.nuvo.crawler.web.bucket.Bucket;
import com.ibm.es.nuvo.crawler.web.config.HTTPProxy;
import com.ibm.es.nuvo.crawler.web.configuration.PublishableConfig;
import com.ibm.es.nuvo.crawler.web.configuration.notify.ConfigChangeListener;
import com.ibm.es.nuvo.crawler.web.configuration.notify.ConfigEventBroaker;
import com.ibm.es.nuvo.crawler.web.configuration.space.AgentConfig;
import com.ibm.es.nuvo.crawler.web.configuration.space.CrawlSpaceConfig;
import com.ibm.es.nuvo.crawler.web.db.CrawlRec;
import com.ibm.es.nuvo.crawler.web.db.URLUpdater;
import com.ibm.es.nuvo.crawler.web.db.tables.BucketTable;
import com.ibm.es.nuvo.crawler.web.db.tables.IPTable;
import com.ibm.es.nuvo.crawler.web.db.tables.RobotsTable;
import com.ibm.es.nuvo.crawler.web.db.tables.SystemTable;
import com.ibm.es.nuvo.crawler.web.db.tables.URLTable;
import com.ibm.es.nuvo.crawler.web.error.OperationFailedException;
import com.ibm.es.nuvo.crawler.web.error.WCException;
import com.ibm.es.nuvo.crawler.web.http.HTTPCategory;
import com.ibm.es.nuvo.crawler.web.http.URLSorter;
import com.ibm.es.nuvo.crawler.web.net.CURL;
import com.ibm.es.nuvo.crawler.web.rule.WebSpace;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.es.nuvo.logging.Loggers;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BucketManager
implements ConfigChangeListener {
    private static final int HASH_SIZE = 72;
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static ExtendedLogger logger = Loggers.logger;
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + BucketManager.class.getName());
    private CrawlSpaceConfig config;
    private int bucketLimit;
    private int validURLcount;
    private int validURLlimit;
    private SyncTask syncTask;
    private boolean feedPending = true;
    private long nextURLScanAllowed;
    private HashMap<Hash64, Bucket> bucketMap = new HashMap();
    private List<Bucket> readyBuckets;
    private ArrayList<Bucket> emptyBuckets = new ArrayList();
    private long terminateTime;
    private ConfigChecker checker;
    private List<WeakReference<ConfigChecker>> checkers = new ArrayList<WeakReference<ConfigChecker>>();
    private Lock lock = new ReentrantLock(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bucket bucketForURL(CURL url) {
        if (tracer.isLoggable(Level.FINEST)) {
            tracer.finest("bucketForURL(CURL) " + url);
        }
        if (!url.isValid()) {
            return null;
        }
        WebSpace webSpace = this.config.getWebSpace();
        Hash64 hostHash = url.getHostHash();
        Bucket bucket = this.bucketMap.get(hostHash);
        if (bucket != null) {
            return bucket;
        }
        if (webSpace.isAlreadyDisallowedBucket(hostHash)) {
            return null;
        }
        bucket = this.createNewBucket(url);
        if (!webSpace.isAllowed(bucket)) {
            return null;
        }
        boolean save = false;
        HashMap<Hash64, Bucket> hashMap = this.bucketMap;
        synchronized (hashMap) {
            if (!this.bucketMap.containsKey(hostHash)) {
                this.bucketMap.put(hostHash, bucket);
                save = true;
            } else {
                bucket = this.bucketMap.get(hostHash);
            }
        }
        if (save) {
            try {
                bucket.saveAsNew();
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.WARNING)) {
                    Message message = new Message("C4917W.MANAGER_FAILED_TO_CREATE_BUCKET", url.getHostname());
                    logger.log(Level.WARNING, new ExtendedException(message, (Throwable)e));
                }
                return null;
            }
        }
        this.setProxy(bucket);
        return bucket;
    }

    protected Bucket createNewBucket(CURL url) {
        return new Bucket(url, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bucket bucketForHostHash(Hash64 hosthash) {
        HashMap<Hash64, Bucket> hashMap = this.bucketMap;
        synchronized (hashMap) {
            return this.bucketMap.get(hosthash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bucket tmpBucket(CURL url) {
        HashMap<Hash64, Bucket> hashMap = this.bucketMap;
        synchronized (hashMap) {
            Bucket bucket = this.bucketMap.get(url.getHostHash());
            if (bucket != null) {
                return bucket;
            }
            Bucket b = this.createNewBucket(url);
            b.setTemporary();
            return b;
        }
    }

    BucketManager(CrawlSpaceConfig config) throws WCException {
        BucketTable bucketTable;
        byte[] bs;
        this.config = config;
        if (!this.isPersistent()) {
            return;
        }
        String id = this.config.getId();
        SystemTable table = SystemTable.getInstance(id);
        if (table != null && ((bs = this.getConfigHash(table)) == null || bs.length < 72) && (bucketTable = BucketTable.getInstance(id)) != null) {
            bucketTable.cleanup();
        }
        this.startCheckConfigurationChange();
        this.readyBuckets = new ArrayList<Bucket>();
        String opName = "load buckets";
        try {
            bucketTable = BucketTable.getInstance(id);
            if (bucketTable != null) {
                Map<Hash64, Bucket> buckets = bucketTable.loadBuckets(id);
                for (Bucket bucket : buckets.values()) {
                    bucket.setManager(this);
                }
                this.bucketMap.putAll(buckets);
            }
        }
        catch (Exception e) {
            throw new OperationFailedException(opName, (Throwable)e);
        }
        try {
            IPTable ipTable = IPTable.getInstance(config.getId());
            if (ipTable != null) {
                ipTable.setIP(this.bucketMap);
            }
        }
        catch (SQLException e) {
            throw new OperationFailedException(opName, (Throwable)e);
        }
        if (tracer.isLoggable(Level.FINEST)) {
            tracer.finer(this.bucketMap.values().toString());
        }
        this.setProxy();
        this.validURLlimit = this.config.getMaxDocuments();
        URLTable urlTable = URLTable.getInstance(config.getId());
        if (urlTable != null && this.syncTask != null) {
            this.syncTask = new SyncTask();
            WebCrawler.schedule(this.syncTask, 10000L);
        }
        ConfigEventBroaker.register(config.getId(), this);
    }

    public void startInsertStartURLs() {
        new HandleSeedURLTask().start();
    }

    public boolean isPersistent() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setProxy() {
        HashMap<Hash64, Bucket> hashMap = this.bucketMap;
        synchronized (hashMap) {
            for (Bucket bucket : this.bucketMap.values()) {
                this.setProxy(bucket);
            }
        }
    }

    private void setProxy(Bucket bucket) {
        AgentConfig agent = this.config.getAgent();
        HTTPProxy proxy = agent.getProxy(bucket.getHostname());
        if (proxy != null) {
            bucket.setProxyAddress(proxy.getSocketAddress());
            bucket.setHTTPBasicProxyAuthorizationCredential(proxy.getHTTPBasicCredential());
        } else {
            bucket.setProxyAddress(null);
            bucket.setHTTPBasicProxyAuthorizationCredential(null);
        }
    }

    private void handleSeedURLs() {
        List<String> startURLs = this.config.getStartURLs();
        ArrayList<CURL> urls = new ArrayList<CURL>(startURLs.size());
        for (String url : startURLs) {
            CURL curl = new CURL(url);
            if (!curl.isValid()) continue;
            urls.add(curl);
        }
        URLSorter.instance().insert(urls, 0L, this, this.config.getMaxPathDepth(), this.config.getId(), 1);
    }

    public int count() {
        return this.bucketMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countBucketsInDNSState(boolean success) {
        int count = 0;
        HashMap<Hash64, Bucket> hashMap = this.bucketMap;
        synchronized (hashMap) {
            for (Bucket bucket : this.bucketMap.values()) {
                if (bucket.hasGoodDNS()) {
                    if (!success) continue;
                    ++count;
                    continue;
                }
                if (success) continue;
                ++count;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Bucket> getBucketsForDNSUpdate() {
        ArrayList<Bucket> list = new ArrayList<Bucket>();
        HashMap<Hash64, Bucket> hashMap = this.bucketMap;
        synchronized (hashMap) {
            for (Bucket bucket : this.bucketMap.values()) {
                if (!bucket.needsDNSUpdate()) continue;
                list.add(bucket);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countBucketsInState(Bucket.State state) {
        int count = 0;
        if (tracer.isLoggable(Level.FINER)) {
            tracer.finer("***");
        }
        HashMap<Hash64, Bucket> hashMap = this.bucketMap;
        synchronized (hashMap) {
            for (Bucket bucket : this.bucketMap.values()) {
                if (bucket.getBucketState() != state) continue;
                if (tracer.isLoggable(Level.FINER)) {
                    tracer.finer("State " + (Object)((Object)state) + " " + bucket);
                }
                ++count;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _activateBuckets() {
        long now = System.currentTimeMillis();
        if (now < this.nextURLScanAllowed) {
            return;
        }
        this.nextURLScanAllowed = now + 5000L;
        if (tracer.isLoggable(Level.FINER)) {
            tracer.finer("activating buckets");
        }
        ArrayList<Bucket> list = new ArrayList<Bucket>();
        HashMap<Hash64, Bucket> hashMap = this.bucketMap;
        synchronized (hashMap) {
            for (Bucket bucket : this.bucketMap.values()) {
                if (!bucket.isActivatable()) continue;
                bucket.startScanning();
                list.add(bucket);
            }
        }
        this.emptyBuckets.addAll(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Bucket> getBucketsForRobotsUpdate() {
        ArrayList<Bucket> ll = new ArrayList<Bucket>();
        HashMap<Hash64, Bucket> hashMap = this.bucketMap;
        synchronized (hashMap) {
            Collection<Bucket> buckets = this.bucketMap.values();
            for (Bucket bucket : buckets) {
                if (!bucket.needsRobotsUpdate() || !bucket.hasGoodDNS()) continue;
                ll.add(bucket);
            }
        }
        return ll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ActiveBucketInfo> getActiveBucketInfo() {
        ArrayList<ActiveBucketInfo> ll = new ArrayList<ActiveBucketInfo>();
        HashMap<Hash64, Bucket> hashMap = this.bucketMap;
        synchronized (hashMap) {
            Collection<Bucket> buckets = this.bucketMap.values();
            for (Bucket bucket : buckets) {
                Bucket.State bs = bucket.getBucketState();
                if (bs != Bucket.State.CRAWLING) continue;
                ll.add(new ActiveBucketInfo(bucket));
                bucket.dumpDetailStatus();
            }
        }
        return ll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bucket getEmptyBucket() {
        ArrayList<Bucket> arrayList = this.emptyBuckets;
        synchronized (arrayList) {
            int i;
            if (this.emptyBuckets.size() == 0) {
                this._activateBuckets();
            }
            if (this.emptyBuckets.size() == 0) {
                return null;
            }
            Bucket bucket = null;
            if (this._preferVolatileBuckets()) {
                Bucket b = null;
                ListIterator<Bucket> it = this.emptyBuckets.listIterator();
                if (it != null) {
                    while (it.hasNext()) {
                        b = it.next();
                        if (!b.isVolatile()) continue;
                        it.remove();
                        bucket = b;
                        break;
                    }
                }
            }
            if (bucket == null && (i = this.emptyBuckets.size() - 1) >= 0) {
                bucket = this.emptyBuckets.remove(i);
            }
            if (bucket != null && !bucket.needsRobotsUpdate()) {
                if (tracer.isLoggable(Level.FINER)) {
                    tracer.finer("Buckets left " + this.emptyBuckets.size());
                }
                this.setRobotsTxt(bucket);
            }
            return bucket;
        }
    }

    public void setRobotsTxt(Bucket bucket) {
        String robotsTxt = null;
        if (tracer.isLoggable(Level.FINE) && bucket.isLargeRobots()) {
            tracer.fine("Robots.txt is not refleshed " + bucket);
        }
        if (bucket.needsRobotsUpdate() || bucket.getRobotsFailCount() > 0 || bucket.isLargeRobots()) {
            return;
        }
        try {
            robotsTxt = RobotsTable.getInstance(this.config.getId()).getRobotsTxt(bucket.getHostHash().longValue());
            if (tracer.isLoggable(Level.FINER)) {
                tracer.finer("Set Robots " + bucket.getHostname() + " " + robotsTxt);
            }
        }
        catch (SQLException e) {
            Message message = new Message("C4918W.MANAGER_FAILED_TO_LOAD_ROBOTS", bucket.getHostname());
            ExtendedException exception = new ExtendedException(message, (Throwable)e);
            logger.log(Level.WARNING, exception);
            robotsTxt = "D/";
        }
        bucket.setRobotsTxt(robotsTxt);
    }

    public boolean needsMoreBucketsFilled() {
        int crawling = this.countBucketsInState(Bucket.State.CRAWLING);
        return crawling < this.bucketLimit;
    }

    private boolean _preferVolatileBuckets() {
        boolean preferVolatile = this.countBucketsInState(Bucket.State.CRAWLING) < this.bucketLimit / 2;
        return preferVolatile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToReadyPool(Bucket bucket) {
        List<Bucket> list = this.readyBuckets;
        synchronized (list) {
            this.readyBuckets.add(bucket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CrawlRec getCrawlRec() {
        Bucket bucket;
        if (this.feedPending) {
            return null;
        }
        List<Bucket> list = this.readyBuckets;
        synchronized (list) {
            if (this.readyBuckets.size() == 0) {
                return null;
            }
            bucket = this.readyBuckets.remove(0);
            if (bucket == null) {
                return null;
            }
        }
        return bucket.takeCrawlRec();
    }

    public int getBucketLimit() {
        return this.bucketLimit;
    }

    public void setBucketLimit(int newLimit) {
        this.bucketLimit = newLimit;
    }

    public CrawlSpaceConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminate() {
        this.terminateTime = System.currentTimeMillis();
        HashMap<Hash64, Bucket> hashMap = this.bucketMap;
        synchronized (hashMap) {
            for (Bucket bucket : this.bucketMap.values()) {
                try {
                    if (bucket.getBucketState() == Bucket.State.INACTIVE) continue;
                    bucket.terminate();
                }
                catch (RuntimeException e) {
                    if (!tracer.isLoggable(Level.FINE)) continue;
                    tracer.log(Level.FINE, "terminating", e);
                }
            }
        }
        ListIterator<WeakReference<ConfigChecker>> li = this.checkers.listIterator();
        while (li.hasNext()) {
            WeakReference<ConfigChecker> wr = li.next();
            ConfigChecker c = (ConfigChecker)wr.get();
            if (c == null) {
                li.remove();
                continue;
            }
            if (!c.isAborted()) {
                c.abort();
            }
            if (!c.isAlive()) continue;
            try {
                c.join(10000L);
                if (!tracer.isLoggable(Level.FINE) || !c.isAlive()) continue;
                tracer.log(Level.FINE, "checker isn't terminated");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.syncTask != null) {
            this.syncTask.cancel();
            this.syncTask = null;
        }
        this.config.setValid(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyChange() {
        this.feedPending = true;
        String id = this.config.getId();
        this.config = CrawlSpaceConfig.forName(id);
        this.validURLlimit = this.config.getMaxDocuments();
        this.setProxy();
        HashMap<Hash64, Bucket> hashMap = this.bucketMap;
        synchronized (hashMap) {
            for (Bucket bucket : this.bucketMap.values()) {
                bucket.configure();
            }
        }
        this.startCheckConfigurationChange();
        this.startInsertStartURLs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCheckConfigurationChange() {
        this.lock.lock();
        try {
            if (this.checker != null && this.checker.isAlive()) {
                this.checker.abort();
            }
            this.checker = new ConfigChecker();
            this.checker.start();
            List<WeakReference<ConfigChecker>> list = this.checkers;
            synchronized (list) {
                this.checkers.add(new WeakReference<ConfigChecker>(this.checker));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConfigurationChange(ConfigChecker configChecker) {
        int i;
        String id = this.config.getId();
        SystemTable table = SystemTable.getInstance(id);
        if (table == null) {
            return;
        }
        if (table.isFoeceUpdateScheduled() && (i = URLTable.getInstance(id).forceRefresh()) >= 0) {
            table.setFoeceUpdateScheduled(false);
        }
        this.feedPending = false;
        byte[] bs = this.getConfigHash(table);
        boolean initial = false;
        if (bs == null || bs.length < 72) {
            initial = true;
            byte[] tmpBs = new byte[72];
            if (bs != null) {
                System.arraycopy(bs, 0, tmpBs, 0, bs.length);
            }
            bs = tmpBs;
        }
        LongBuffer lb = ByteBuffer.wrap(bs).asLongBuffer();
        ByteBuffer buffer = ByteBuffer.allocate(72);
        LongBuffer newHash = buffer.asLongBuffer();
        boolean proxy = false;
        boolean basicAuthChanged = false;
        boolean https = false;
        boolean http = false;
        boolean robots = false;
        boolean dns = false;
        WebSpace space = null;
        long hash = this.config.getHash(PublishableConfig.HashType.ALL);
        if (hash != lb.get()) {
            https = true;
            http = true;
            robots = true;
            dns = true;
        }
        newHash.put(hash);
        hash = this.config.getHash(PublishableConfig.HashType.DNS);
        if (hash != lb.get()) {
            dns = true;
        }
        newHash.put(hash);
        hash = this.config.getHash(PublishableConfig.HashType.ROBOTS);
        if (hash != lb.get()) {
            robots = true;
        }
        newHash.put(hash);
        hash = this.config.getHash(PublishableConfig.HashType.HTTP);
        if (hash != lb.get()) {
            http = true;
        }
        newHash.put(hash);
        hash = this.config.getHash(PublishableConfig.HashType.HTTPS);
        if (hash != lb.get()) {
            https = true;
        }
        newHash.put(hash);
        hash = this.config.getRule().getHash(PublishableConfig.HashType.RULE);
        if (hash != lb.get()) {
            space = this.config.getWebSpace();
            http = true;
        }
        newHash.put(hash);
        hash = this.config.getHash(PublishableConfig.HashType.BASIC_AUTH);
        if (hash != lb.get()) {
            http = true;
            basicAuthChanged = true;
        }
        newHash.put(hash);
        hash = this.config.getHash(PublishableConfig.HashType.FORM_BASE_AUTH);
        boolean formAuthChanged = false;
        if (hash != lb.get()) {
            http = true;
            formAuthChanged = true;
        }
        newHash.put(hash);
        hash = this.config.getHash(PublishableConfig.HashType.PROXY);
        boolean failedRobots = false;
        if (hash != lb.get()) {
            proxy = true;
            failedRobots = true;
            http = true;
        }
        newHash.put(hash);
        if (!initial) {
            if (tracer.isLoggable(Level.INFO)) {
                tracer.info("Reset " + (dns ? "DNS " : " ") + (robots ? "Robots " : " ") + (http ? "HTTP " : (https ? "HTTPS " : "")));
            }
            HashMap<Hash64, Bucket> hashMap = this.bucketMap;
            synchronized (hashMap) {
                tracer.fine("update buckets");
                if (!robots && failedRobots) {
                    for (Bucket bucket : this.bucketMap.values()) {
                        if (bucket.getRobotsFailCount() <= 0) continue;
                        bucket.recrawl(false, true);
                    }
                }
                if (http || https || dns || robots) {
                    for (Bucket bucket : this.bucketMap.values()) {
                        if (dns || robots) {
                            bucket.recrawl(dns, robots);
                        }
                        if ((bucket.getProtocolNumber() == 0 && http || bucket.getProtocolNumber() == 1 && https) && bucket.getBucketState() != Bucket.State.INACTIVE || dns && bucket.getDNSDate() > 0 || robots && bucket.getRobotsDate() > 0) {
                            bucket.terminate();
                        }
                        bucket.activate();
                    }
                }
                tracer.fine("buckets set recrawl");
                try {
                    URLUpdater.instance().flush();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            int count = 0;
            if (http) {
                count = URLTable.getInstance(id).recrawl(null, false, space, this.config.getAgent(), proxy, basicAuthChanged, formAuthChanged, configChecker);
            } else if (https) {
                count = URLTable.getInstance(id).recrawl("https://%", false, space, this.config.getAgent(), proxy, basicAuthChanged, formAuthChanged, configChecker);
            }
            if (tracer.isLoggable(Level.FINE)) {
                tracer.fine("Updated " + count);
            }
        }
        if (configChecker != null && configChecker.isAborted()) {
            return;
        }
        table.update(0, buffer.array());
    }

    private byte[] getConfigHash(SystemTable table) {
        byte[] bs;
        block2: {
            bs = null;
            try {
                bs = table.get(0);
            }
            catch (SQLException e) {
                if (!tracer.isLoggable(Level.FINE)) break block2;
                tracer.log(Level.FINE, "The configuration changes for " + this.config.getId() + " is forced.");
            }
        }
        return bs;
    }

    public boolean canCrawlNewURL() {
        return this.validURLlimit < 0 || this.validURLcount < this.validURLlimit;
    }

    public void recordCrawled(CrawlRec rec) {
        if (rec.getURL().isRobots()) {
            return;
        }
        if (!HTTPCategory.successful(rec.getOldHTTPStatus()) && HTTPCategory.successful(rec.getNewHTTPStatus())) {
            ++this.validURLcount;
        }
        if (HTTPCategory.successful(rec.getOldHTTPStatus()) && !HTTPCategory.successful(rec.getNewHTTPStatus())) {
            --this.validURLcount;
        }
    }

    public int getValidURLcount() {
        return this.validURLcount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Bucket> getActiveBuckets() {
        ArrayList<Bucket> list = new ArrayList<Bucket>();
        HashMap<Hash64, Bucket> hashMap = this.bucketMap;
        synchronized (hashMap) {
            for (Bucket bucket : this.bucketMap.values()) {
                if (bucket.getBucketState() != Bucket.State.CRAWLING) continue;
                list.add(bucket);
            }
        }
        return list;
    }

    public String toString() {
        return this.getConfig().getId();
    }

    public void fullRecrawl() {
        URLTable.getInstance(this.config.getId()).recrawl(null, true, null, null, false, false, false, null);
    }

    long getTerminateTime() {
        return this.terminateTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceStop() {
        HashMap<Hash64, Bucket> hashMap = this.bucketMap;
        synchronized (hashMap) {
            for (Bucket bucket : this.bucketMap.values()) {
                bucket.forceTerminate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snap(StringBuilder builder) {
        builder.append("URLCount ");
        builder.append(this.validURLcount);
        builder.append("/");
        builder.append(this.validURLlimit);
        builder.append("/");
        WCMonitor monitor = WCMonitor.forName(this.config.getId());
        builder.append(monitor == null ? 0 : monitor.getNURLsReportedThisSession());
        builder.append("\nBuckets\n");
        HashMap<Hash64, Bucket> hashMap = this.bucketMap;
        synchronized (hashMap) {
            for (Bucket bucket : this.bucketMap.values()) {
                bucket.debugInfo(builder);
            }
        }
    }

    public class ConfigChecker
    extends Thread {
        private boolean aborted;

        public ConfigChecker() {
            this.setName("WebConfigUpdater_" + Integer.toHexString(this.hashCode()));
        }

        public void run() {
            try {
                BucketManager.this.checkConfigurationChange(this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void abort() {
            this.aborted = true;
        }

        public boolean isAborted() {
            return this.aborted;
        }
    }

    private class HandleSeedURLTask
    extends Thread {
        private HandleSeedURLTask() {
        }

        public void run() {
            try {
                BucketManager.this.handleSeedURLs();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "G0006E.CAUSED_BY", e);
            }
        }
    }

    private class SyncTask
    extends TimerTask {
        private SyncTask() {
        }

        public void run() {
            URLTable urlTable = URLTable.getInstance(BucketManager.this.config.getId());
            if (urlTable != null) {
                BucketManager.this.validURLcount = urlTable.getValidUrlCount();
            }
        }
    }
}

