/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.bucket;

import com.ibm.es.nuvo.crawler.util.hash.Hash64;
import com.ibm.es.nuvo.crawler.web.WebCrawler;
import com.ibm.es.nuvo.crawler.web.bucket.BucketManager;
import com.ibm.es.nuvo.crawler.web.configuration.CrawlerConfig;
import com.ibm.es.nuvo.crawler.web.configuration.IntervalConfig;
import com.ibm.es.nuvo.crawler.web.configuration.RobotConfig;
import com.ibm.es.nuvo.crawler.web.configuration.space.CrawlSpaceConfig;
import com.ibm.es.nuvo.crawler.web.db.CrawlRec;
import com.ibm.es.nuvo.crawler.web.db.tables.BucketTable;
import com.ibm.es.nuvo.crawler.web.error.WCException;
import com.ibm.es.nuvo.crawler.web.net.CURL;
import com.ibm.es.nuvo.crawler.web.net.IPProto;
import com.ibm.es.nuvo.crawler.web.net.InvalidIPAddressException;
import com.ibm.es.nuvo.crawler.web.net.InvalidURLException;
import com.ibm.es.nuvo.crawler.web.net.ReusableSocketManager;
import com.ibm.es.nuvo.crawler.web.rule.RobotsRule;
import com.ibm.es.nuvo.crawler.web.rule.RobotsTxtParser;
import com.ibm.es.nuvo.crawler.web.rule.WebSpace;
import com.ibm.es.nuvo.crawler.web.util.UnixTime;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bucket {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + Bucket.class.getName());
    static final int ACTIVATION_INTERVAL_MAX = 60;
    private static final int ACTIVATION_DELAY = 10;
    private int activationInterval;
    private CrawlSpaceConfig config;
    private int maxURL = 300;
    private BucketManager manager;
    private boolean forceDNSScan;
    private boolean forceRobotsScan;
    private boolean largeRobots;
    private Hash64 m_hosthash;
    private int m_protocolNumber;
    private String m_hostname;
    private int m_port;
    private int dnsDate;
    private int dnsFailCount;
    private int robotsDate;
    private int robotsFailCount;
    private String m_serverType;
    private boolean m_volatile;
    private int m_activateDate;
    private int m_scanDate;
    private int m_scanCount;
    private int m_crawlDate;
    private int m_uncrawledCount;
    private int m_deactivateDate;
    private RobotsRule[] robotsRules;
    private int m_politeness;
    private int m_timeoutSec;
    private State state = State.INACTIVE;
    private ArrayList<CrawlRec> crawlRecs = new ArrayList();
    private TimerTask m_postTask;
    private TimerTask m_timeoutTask;
    private Object m_startStopLock = new Object();
    private boolean m_bucketDataDirty;
    private int m_pending;
    private int m_fetching;
    private int m_finishing;
    private int m_maxActive;
    private int recInUse;
    private InetSocketAddress m_proxyAddress;
    private ArrayList<InetSocketAddress> addresses = new ArrayList();
    private int numCrawled;
    private int portCount;
    private HashSet<String> m_fbaDoneList = new HashSet();
    private String proxyCred;
    private WebSpace webspace;
    private boolean m_temporary;
    private Boolean allowed;
    private ReentrantLock fbaLock = new ReentrantLock();

    public Bucket(String spaceID, long hostHash, int protocolNumber, String hostName, int port, int dnsDate, int dnsFailCount, int robotsDate, int robotsFailCount, String serverType, boolean isVolatile, int activateDate, int scanDate, int scanCount, int crawlDate, int uncrawledCount, int deactivateDate) {
        this.config = CrawlSpaceConfig.forName(spaceID);
        this.m_hosthash = new Hash64(hostHash);
        this.m_protocolNumber = protocolNumber;
        this.m_hostname = hostName;
        this.m_port = port;
        this.dnsDate = dnsDate;
        this.dnsFailCount = 0;
        this.robotsDate = robotsDate;
        this.robotsFailCount = robotsFailCount;
        this.m_serverType = serverType;
        this.m_volatile = isVolatile;
        this.m_activateDate = activateDate;
        this.m_scanDate = scanDate;
        this.m_scanCount = scanCount;
        this.m_crawlDate = crawlDate;
        this.m_uncrawledCount = uncrawledCount;
        this.m_deactivateDate = deactivateDate;
        this.configure();
    }

    void configure() {
        if (this.manager != null) {
            this.config = this.manager.getConfig();
        }
        this.webspace = this.config.getWebSpace();
        this.allowed = null;
    }

    Bucket(CURL url, BucketManager manager) {
        this.m_hosthash = url.getHostHash();
        this.m_protocolNumber = url.getProtocolNumber();
        this.m_hostname = url.getHostname();
        this.m_port = url.getPort();
        this.manager = manager;
        if (manager != null) {
            this.config = this.manager.getConfig();
            this.configure();
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Bucket(").append(IPProto.getProtocolName(this.m_protocolNumber)).append("://").append(this.m_hostname).append(":").append(this.m_port).append(",").append(this.m_hosthash).append(")");
        return buffer.toString();
    }

    void dumpDetailStatus() {
        if (tracer.isLoggable(Level.FINER)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.m_hostname).append(" ").append(this.m_fetching).append(" ").append(this.m_finishing).append(" ").append(this.m_pending).append(" ").append(this.recInUse);
            buffer.append(" ").append(this.m_postTask).append(" ").append(this.crawlRecs.size());
            tracer.finer(buffer.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addCrawlRec(CrawlRec cr) {
        ArrayList<CrawlRec> arrayList = this.crawlRecs;
        synchronized (arrayList) {
            if (this.crawlRecs.size() >= this.maxURLsAllowed()) {
                return false;
            }
            cr.setBucket(this);
            this.crawlRecs.add(cr);
            return true;
        }
    }

    public boolean addInetAddress(InetAddress ia) {
        return this._addInetAddress(ia);
    }

    public void addIPAddress(byte[] ipAddr) {
        block2: {
            try {
                this._addInetAddress(InetAddress.getByAddress(ipAddr));
            }
            catch (UnknownHostException uhe) {
                if (!tracer.isLoggable(Level.FINER)) break block2;
                tracer.finer(new InvalidIPAddressException(ipAddr, this.m_hostname, uhe).toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _addInetAddress(InetAddress ia) {
        ArrayList<InetSocketAddress> arrayList = this.addresses;
        synchronized (arrayList) {
            for (InetSocketAddress address : this.addresses) {
                if (!address.getAddress().equals(ia)) continue;
                return false;
            }
            this.addresses.add(new InetSocketAddress(ia, this.m_port));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enforcePoliteness() {
        Object object = this.m_startStopLock;
        synchronized (object) {
            int delay;
            if (this.m_politeness > 0) {
                if (this.m_postTask != null) {
                    this.m_postTask.cancel();
                    this.m_postTask = null;
                }
                delay = this.m_politeness;
            } else if (this.m_postTask == null) {
                delay = 0;
            } else {
                return;
            }
            this.m_postTask = new ReactivateTask();
            WebCrawler.schedule(this.m_postTask, delay, 100L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterCrawlRec(CrawlRec cr) {
        if (cr == null) {
            return;
        }
        if (this.m_serverType == null && cr.getServerID() != null) {
            this.setServerType(cr.getServerID());
        }
        ArrayList<CrawlRec> arrayList = this.crawlRecs;
        synchronized (arrayList) {
            block10: {
                --this.m_finishing;
                if (this.m_finishing < 0) {
                    this.m_finishing = 0;
                }
                if (this.m_pending + this.m_fetching + this.m_finishing == 0) {
                    try {
                        this.recycle();
                    }
                    catch (RuntimeException e) {
                        if (!tracer.isLoggable(Level.FINE)) break block10;
                        tracer.log(Level.FINE, "recycling", e);
                    }
                }
            }
        }
        if (this.recInUse > 0) {
            --this.recInUse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchEnding() {
        ArrayList<CrawlRec> arrayList = this.crawlRecs;
        synchronized (arrayList) {
            --this.m_fetching;
            if (this.m_fetching < 0) {
                this.m_fetching = 0;
            }
            ++this.m_finishing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchStarting() {
        ArrayList<CrawlRec> arrayList = this.crawlRecs;
        synchronized (arrayList) {
            --this.m_pending;
            if (this.m_pending < 0) {
                this.m_pending = 0;
            }
            ++this.m_fetching;
        }
    }

    public int getActivateDate() {
        return this.m_activateDate;
    }

    public State getBucketState() {
        return this.state;
    }

    public int getCrawlDate() {
        return this.m_crawlDate;
    }

    public int getDeactivateDate() {
        return this.m_deactivateDate;
    }

    public int getDNSDate() {
        return this.dnsDate;
    }

    public int getDNSFailCount() {
        return this.dnsFailCount;
    }

    public Hash64 getHostHash() {
        return this.m_hosthash;
    }

    public String getHostname() {
        return this.m_hostname;
    }

    public String getProxyAuth() {
        return this.proxyCred;
    }

    public int getPort() {
        return this.m_port;
    }

    public int getProtocolNumber() {
        return this.m_protocolNumber;
    }

    public InetSocketAddress getProxyAddress() {
        return this.m_proxyAddress;
    }

    public int getRobotsDate() {
        return this.robotsDate;
    }

    public int getRobotsFailCount() {
        return this.robotsFailCount;
    }

    public CURL getRobotsTxtURL() {
        CURL robotsUrl = this.siteURL("/robots.txt");
        if (robotsUrl == null || !robotsUrl.isValid()) {
            this.state = State.ERROR;
            tracer.log(Level.FINE, new InvalidURLException("robots", robotsUrl, this.m_hostname).toString());
        }
        return robotsUrl;
    }

    public int getScanDate() {
        return this.m_scanDate;
    }

    public int getScanCount() {
        return this.m_scanCount;
    }

    public String getServerType() {
        return this.m_serverType;
    }

    public int getTimeoutSec() {
        return this.m_timeoutSec;
    }

    public int getUncrawledCount() {
        return this.m_uncrawledCount;
    }

    public boolean hasGoodDNS() {
        if (this.dnsFailCount > 0) {
            return false;
        }
        return !this.needsDNSUpdate();
    }

    public void incrDNSFailCount() {
        if (this.dnsFailCount < Integer.MAX_VALUE) {
            ++this.dnsFailCount;
            this.m_bucketDataDirty = true;
        }
    }

    public void incrRobotsFailCount() {
        if (this.robotsFailCount < Integer.MAX_VALUE) {
            ++this.robotsFailCount;
            this.m_bucketDataDirty = true;
        }
    }

    public boolean isActivatable() {
        if (this.state != State.INACTIVE || this.activationInterval > 0 && this.m_activateDate + this.activationInterval > UnixTime.now() || this.dnsFailCount > 0 && !this.needsDNSUpdate() && !this.forceDNSScan || this.robotsFailCount > 0 && !this.needsRobotsUpdate() && !this.forceRobotsScan) {
            if (tracer.isLoggable(Level.FINE)) {
                Level level;
                Level level2 = this.state != State.INACTIVE ? Level.FINEST : (level = this.dnsFailCount > 0 || this.robotsFailCount > 0 ? Level.FINER : Level.FINE);
                if (tracer.isLoggable(level)) {
                    tracer.log(level, "Not activatable " + this.m_hostname + ":" + this.m_port + " " + (this.state != State.INACTIVE ? "State " + (Object)((Object)this.state) : "") + " " + (this.dnsFailCount > 0 ? "DNS Fail" : (this.robotsFailCount > 0 ? "Robots Fail" : (this.needsDNSUpdate() ? "DNS update" : (this.needsRobotsUpdate() ? "Robots.txt update" : (this.activationInterval > 0 && this.m_activateDate + this.activationInterval > UnixTime.now() ? " Interval " + (this.m_activateDate + this.activationInterval - UnixTime.now()) + "/" + this.activationInterval : "Ready"))))) + " " + " " + this.m_pending + " " + this.m_fetching + " " + this.m_finishing);
                }
            }
            return false;
        }
        if (tracer.isLoggable(Level.FINEST)) {
            tracer.finest("Activate bucket for " + this.m_hostname);
        }
        return true;
    }

    public boolean isBucketDataDirty() {
        return this.m_bucketDataDirty;
    }

    public boolean isFBADone(String fbaDefId) {
        return this.m_fbaDoneList.contains(fbaDefId);
    }

    public boolean isVolatile() {
        return this.m_volatile;
    }

    public int maxURLsAllowed() {
        return this.m_volatile ? this.maxURL * 2 : this.maxURL;
    }

    public boolean needsDNSUpdate() {
        IntervalConfig dnsIntervalConfig = CrawlerConfig.getInstance().getDnsIntervalConfig();
        return this.needUpdate(dnsIntervalConfig, this.dnsDate, this.dnsFailCount);
    }

    private boolean needUpdate(IntervalConfig interval, int lastDate, int failCount) {
        boolean ret = false;
        if ((long)lastDate + interval.getCheck() < (long)UnixTime.now()) {
            ret = true;
        } else if (failCount > 0) {
            if ((long)failCount > interval.getMaxFail()) {
                ret = false;
            } else if ((long)lastDate + interval.getRetry() < (long)UnixTime.now()) {
                ret = true;
            }
        }
        return ret;
    }

    public boolean needsRobotsUpdate() {
        RobotConfig robotConfig = CrawlerConfig.getInstance().getRobotConfig();
        return this.needUpdate(robotConfig, this.robotsDate, this.robotsFailCount);
    }

    private void recycle() {
        if (this.state != State.RECYCLE) {
            return;
        }
        if (tracer.isLoggable(Level.FINE)) {
            tracer.fine("recycling " + this.m_hostname);
        }
        this.crawlRecs.clear();
        this.m_finishing = 0;
        this.m_fetching = 0;
        this.m_pending = 0;
        this.crawlRecs.clear();
        this.crawlRecs.trimToSize();
        this.release();
        this.state = State.INACTIVE;
        ReusableSocketManager.getInstance().close(this.m_hosthash);
        this.store();
        this.m_bucketDataDirty = true;
    }

    private void release() {
        this.clearFBARecords();
        if (!this.largeRobots) {
            this.robotsRules = null;
        } else if (tracer.isLoggable(Level.FINE)) {
            tracer.fine("Robots.txt is not cleaned-up " + this);
        }
    }

    public boolean robotsExcludes(CURL url) {
        return this.webspace.robotsExcludes(this.robotsRules, url);
    }

    protected void store() {
        block4: {
            boolean rescanRobots;
            if (!this.isBucketDataDirty()) {
                return;
            }
            BucketTable bucketTable = BucketTable.getInstance(this.config.getId());
            boolean bl = rescanRobots = this.forceRobotsScan || this.largeRobots;
            if (tracer.isLoggable(Level.FINE) && rescanRobots) {
                tracer.fine("Set rescan robots.txt " + this);
            }
            try {
                bucketTable.update(this, this.forceDNSScan, rescanRobots);
            }
            catch (Exception e) {
                if (!tracer.isLoggable(Level.FINE)) break block4;
                tracer.log(Level.FINE, "Failed to store bucket", e);
            }
        }
    }

    protected void saveAsNew() throws WCException, SQLException {
        block3: {
            try {
                BucketTable.getInstance(this.config.getId()).add(this);
            }
            catch (SQLException sqle) {
                if (tracer.isLoggable(Level.FINE)) {
                    tracer.log(Level.FINE, "", sqle);
                }
                if (30000 == sqle.getErrorCode()) break block3;
                throw sqle;
            }
        }
    }

    public void setFBARecord(String fbaDefId) {
        if (!this.m_fbaDoneList.contains(fbaDefId)) {
            this.m_fbaDoneList.add(fbaDefId);
        }
    }

    public void clearFBARecords() {
        if (this.m_fbaDoneList != null) {
            this.m_fbaDoneList.clear();
        }
    }

    public void setProxyAddress(InetSocketAddress isa) {
        if (isa != null && !isa.equals(this.m_proxyAddress)) {
            this.addresses.clear();
            this.addresses.add(isa);
            this.dnsFailCount = 0;
            this.dnsDate = 0;
        } else if (isa == null && this.m_proxyAddress != null) {
            this.addresses.clear();
            this.forceDNSScan = true;
        }
        this.m_proxyAddress = isa;
    }

    void setHTTPBasicProxyAuthorizationCredential(String credential) {
        this.proxyCred = credential;
    }

    public void setRobotsTxt(String robotsTxt) {
        this.robotsRules = RobotsTxtParser.createRules(robotsTxt);
    }

    public void setServerType(String serverType) {
        if (serverType != null) {
            try {
                byte[] ba = serverType.getBytes("UTF-8");
                if (ba != null && ba.length > 255) {
                    serverType = "unknown";
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (this.m_serverType == null || !this.m_serverType.equals(serverType)) {
            this.m_serverType = serverType;
            this.m_bucketDataDirty = true;
        }
    }

    public void setVolatile(boolean yesno) {
        if (yesno != this.m_volatile) {
            this.m_volatile = yesno;
            this.m_bucketDataDirty = true;
        }
    }

    public CURL siteURL(String absPath) {
        String proto = IPProto.getProtocolName(this.m_protocolNumber);
        if (proto == null) {
            return null;
        }
        if (this.m_hostname == null || this.m_hostname.length() == 0) {
            return null;
        }
        if (absPath == null || absPath.length() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(proto).append("://").append(this.m_hostname).append(":");
        sb.append(this.m_port).append(absPath);
        return new CURL(sb.toString());
    }

    public void skipCrawling(boolean delay) {
        if (this.state == State.INACTIVE) {
            return;
        }
        if (this.state != State.SCANNING && tracer.isLoggable(Level.FINE)) {
            tracer.log(Level.FINE, "Invalid state " + (Object)((Object)this.state) + " at " + this.m_hostname);
        }
        if (tracer.isLoggable(Level.FINER)) {
            tracer.finer("Skip crawling " + this.m_hostname);
        }
        this.state = State.INACTIVE;
        this.release();
        this.crawlRecs.clear();
        this.m_deactivateDate = UnixTime.now();
        if (delay && this.activationInterval < 60) {
            this.activationInterval += 10;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCrawling(int bucketTimeoutSec) {
        Object object = this.m_startStopLock;
        synchronized (object) {
            this.state = State.CRAWLING;
            this.m_scanCount = this.crawlRecs.size();
            this.m_crawlDate = UnixTime.now();
            this.m_bucketDataDirty = true;
            this.m_timeoutSec = bucketTimeoutSec;
            this.m_politeness = this.config.getPoliteness().forHost(this.m_hosthash);
            this.m_maxActive = this.m_politeness < 0 ? -this.m_politeness : 1;
            this.clearFBARecords();
            this.numCrawled = 0;
            this.manager.addToReadyPool(this);
            if (this.m_timeoutTask != null) {
                this.m_timeoutTask.cancel();
                this.m_timeoutTask = null;
            }
            this.m_timeoutTask = new StopTask();
            WebCrawler.schedule(this.m_timeoutTask, (long)this.m_timeoutSec * 1000L);
            this.activationInterval = 0;
            if (tracer.isLoggable(Level.FINE)) {
                tracer.fine("Start crawling: " + this + " with " + this.m_scanCount + " URLs");
            }
        }
    }

    public void startRobotsDownload(int bucketTimeoutSec) {
        this.m_scanCount = 0;
        this.m_crawlDate = UnixTime.now();
        this.m_bucketDataDirty = true;
        this.m_timeoutSec = bucketTimeoutSec;
        ++this.recInUse;
    }

    public void startScanning() {
        this.state = State.SCANNING;
        this.m_activateDate = UnixTime.now();
        this.m_scanDate = UnixTime.now();
        if (this.forceDNSScan) {
            this.dnsDate = 0;
            this.dnsFailCount = 0;
            this.forceDNSScan = false;
        }
        if (this.forceRobotsScan) {
            this.robotsDate = 0;
            this.robotsFailCount = 0;
            this.forceRobotsScan = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _stopCrawling() {
        if (State.SCANNING == this.state) {
            this.skipCrawling(true);
        }
        if (State.INACTIVE == this.state || State.RECYCLE == this.state) {
            return;
        }
        Object object = this.m_startStopLock;
        synchronized (object) {
            if (tracer.isLoggable(Level.FINER)) {
                tracer.finer("stop requested " + this.m_hostname);
            }
            this.m_deactivateDate = UnixTime.now();
            this.m_uncrawledCount = this.crawlRecs.size();
            this.m_bucketDataDirty = true;
            if (this.m_timeoutTask != null) {
                this.m_timeoutTask.cancel();
                this.m_timeoutTask = null;
            }
            if (this.m_postTask != null) {
                this.m_postTask.cancel();
                this.m_postTask = null;
            }
            if (State.CRAWLING != this.state) {
                System.out.println((Object)this.state);
            }
            this.state = State.RECYCLE;
            ArrayList<CrawlRec> arrayList = this.crawlRecs;
            synchronized (arrayList) {
                if (this.m_pending + this.m_fetching + this.m_finishing == 0) {
                    this.recycle();
                } else if (tracer.isLoggable(Level.FINEST)) {
                    tracer.finest(MessageFormat.format("{0} pages were left. {1}", "" + (this.m_pending + this.m_fetching + this.m_finishing), this.m_hostname));
                }
            }
        }
    }

    public void stopRobotsDownload() {
        this.m_deactivateDate = UnixTime.now();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CrawlRec takeCrawlRec() {
        boolean pending;
        if (this.state != State.CRAWLING) {
            return null;
        }
        CrawlRec cr = null;
        ArrayList<CrawlRec> arrayList = this.crawlRecs;
        synchronized (arrayList) {
            cr = this.crawlRecs.get(this.numCrawled);
            this.crawlRecs.set(this.numCrawled, null);
            ++this.m_pending;
            if (this.needsDNSUpdate() || this.needsRobotsUpdate() || !cr.getConfig().isValid()) {
                if (tracer.isLoggable(Level.FINEST)) {
                    tracer.finest("pending " + this.m_hostname + " " + this.needsDNSUpdate() + " " + this.needsRobotsUpdate() + " " + cr.getConfig().isValid());
                }
                pending = true;
            } else {
                pending = false;
            }
            ++this.numCrawled;
            ++this.recInUse;
        }
        if (this.numCrawled == this.crawlRecs.size() || pending) {
            if (tracer.isLoggable(Level.FINEST)) {
                tracer.finest("All recs are taken " + this.m_hostname);
            }
            this._stopCrawling();
        } else {
            this.enforcePoliteness();
        }
        return cr;
    }

    public InetSocketAddress nextInetSocketAddress() {
        return this.addresses.get(this.portCount++ % this.addresses.size());
    }

    public int countIP() {
        return this.addresses == null ? 0 : this.addresses.size();
    }

    public void updateDNSDate() {
        this.dnsDate = UnixTime.now();
        this.m_bucketDataDirty = true;
    }

    public void updateRobotsDate() {
        this.robotsDate = UnixTime.now();
        this.m_bucketDataDirty = true;
    }

    public void zeroDNSFailCount() {
        if (this.dnsFailCount != 0) {
            this.dnsFailCount = 0;
            this.m_bucketDataDirty = true;
        }
    }

    public void zeroRobotsFailCount() {
        if (this.robotsFailCount != 0) {
            this.robotsFailCount = 0;
            this.m_bucketDataDirty = true;
        }
    }

    public boolean isTemporary() {
        return this.m_temporary;
    }

    void setTemporary() {
        this.m_temporary = true;
    }

    public Iterator<InetSocketAddress> getIP() {
        return this.addresses.iterator();
    }

    public boolean hasIP() {
        return this.addresses.size() > 0;
    }

    public int getNumCrawled() {
        return this.numCrawled;
    }

    public int size() {
        return this.crawlRecs.size();
    }

    public CrawlSpaceConfig getConfig() {
        return this.config;
    }

    public int getMaxURL() {
        int timeout = CrawlerConfig.getInstance().getBucketConfig().getTimeout();
        this.m_politeness = this.config.getPoliteness().forHost(this.m_hosthash);
        if (this.m_politeness > 0) {
            this.maxURL = timeout * 800 / this.m_politeness;
        } else {
            int i = this.m_politeness == 0 ? 1 : -this.m_politeness;
            this.maxURL = Math.min(600, timeout * i * 4);
        }
        this.maxURL = Math.min(300, this.maxURL);
        return this.maxURL;
    }

    public int getTimeout() {
        return CrawlerConfig.getInstance().getBucketConfig().getTimeout();
    }

    public BucketManager getManager() {
        return this.manager;
    }

    void setManager(BucketManager manager) {
        this.manager = manager;
    }

    void terminate() {
        this._stopCrawling();
        this.store();
    }

    public short verifyURL(CURL url) {
        int s = 0;
        if (this.allowed == null) {
            this.allowed = this.webspace.isAllowed(this);
        }
        if (!(s != 0 || this.allowed != null && this.allowed.booleanValue())) {
            s = 760;
        }
        if (s == 0) {
            int proto = url.getProtocolNumber();
            s = proto != 0 && proto != 1 ? 770 : (this.robotsExcludes(url) ? 740 : (this.webspace.isExcluded(url) ? 780 : (!this.webspace.isAllowed(url) ? 760 : 0)));
        }
        if (s == 0) {
            if (this.needsDNSUpdate() || this.hasIP() && this.needsRobotsUpdate()) {
                s = 0;
            } else if (!this.needsDNSUpdate() && !this.hasIP() || this.getRobotsFailCount() > 0) {
                s = 760;
            }
        }
        return (short)s;
    }

    public ReentrantLock getFbaLock() {
        return this.fbaLock;
    }

    void recrawl(boolean dns, boolean robots) {
        this.forceDNSScan = dns;
        this.forceRobotsScan = robots;
    }

    void activate() {
        this.activationInterval = 0;
    }

    void forceTerminate() {
        this._stopCrawling();
        if (State.INACTIVE != this.state) {
            if (tracer.isLoggable(Level.FINE)) {
                tracer.fine("force terminate " + this.m_hostname + ":" + this.m_pending + ":" + this.m_fetching + ":" + this.m_finishing);
            }
            this.m_finishing = 0;
            this.m_fetching = 0;
            this.m_pending = 0;
            this.recycle();
        }
    }

    public void debugInfo(StringBuilder builder) {
        if (this.m_crawlDate == 0) {
            return;
        }
        builder.append(IPProto.getProtocolName(this.m_protocolNumber));
        builder.append("://");
        builder.append(this.m_hostname);
        builder.append(":");
        builder.append(this.m_port);
        builder.append(" ");
        builder.append((Object)this.state);
        builder.append(" ");
        builder.append("S ");
        builder.append(this.m_pending);
        builder.append("/");
        builder.append(this.m_fetching);
        builder.append("/");
        builder.append(this.m_finishing);
        DateFormat fmt = SimpleDateFormat.getDateTimeInstance();
        builder.append(" D ");
        if (this.dnsDate == 0) {
            builder.append("(not yet)");
        } else {
            builder.append(fmt.format(new Date((long)this.dnsDate * 1000L)));
            if (this.needsRobotsUpdate()) {
                builder.append(" UP ");
            }
        }
        builder.append("/");
        builder.append(this.dnsFailCount);
        builder.append(" R ");
        if (this.robotsDate == 0) {
            builder.append("(not yet)");
        } else {
            builder.append(fmt.format(new Date((long)this.robotsDate * 1000L)));
            if (this.needsDNSUpdate()) {
                builder.append(" UP ");
            }
        }
        builder.append("/");
        builder.append(this.robotsFailCount);
        builder.append(" S ");
        if (this.m_scanDate > 0) {
            builder.append(fmt.format(new Date((long)this.m_scanDate * 1000L)));
        } else {
            builder.append("(not yet)");
        }
        builder.append(" C ");
        if (this.m_crawlDate > 0) {
            builder.append(fmt.format(new Date((long)this.m_crawlDate * 1000L)));
        } else {
            builder.append("(not yet)");
        }
        builder.append("\n");
    }

    public void setLargeRobots(boolean largeRobots) {
        this.largeRobots = largeRobots;
    }

    public boolean isLargeRobots() {
        return this.largeRobots;
    }

    private class StopTask
    extends TimerTask {
        private StopTask() {
        }

        public void run() {
            Bucket.this._stopCrawling();
        }
    }

    private class ReactivateTask
    extends TimerTask {
        private ReactivateTask() {
        }

        public void run() {
            if (Bucket.this.m_pending + Bucket.this.m_fetching >= Bucket.this.m_maxActive) {
                return;
            }
            Bucket.this.manager.addToReadyPool(Bucket.this);
            if (Bucket.this.m_politeness > 0) {
                this.cancel();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        INACTIVE,
        SCANNING,
        CRAWLING,
        RECYCLE,
        ERROR;

    }
}

