/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.bucket;

import com.ibm.es.nuvo.crawler.web.bucket.Bucket;
import com.ibm.es.nuvo.crawler.web.net.CURL;
import com.ibm.es.nuvo.crawler.web.util.UnixTime;
import java.text.MessageFormat;

public class ActiveBucketInfo {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static boolean DEBUG = false;
    private String debugMsg;
    private String id;
    private CURL url;
    private int activatedURLs;
    private int crawledURLs;
    private int elapsedTime;
    private int remainingTime;
    private static MessageFormat format = new MessageFormat("    <ActiveBucket CrawlSpace=\"{6}\" URL=\"{0}\" Total=\"{1}\" Crawled=\"{2}\" TimeRem=\"{3,number,####}\" Duration=\"{4,number,####}\" Interval=\"{5,number,#.#}\"/>\n");

    public ActiveBucketInfo(Bucket bucket) {
        this.url = bucket.siteURL("/");
        this.id = bucket.getConfig().getId();
        this.activatedURLs = bucket.size();
        this.crawledURLs = bucket.getNumCrawled();
        this.elapsedTime = UnixTime.now() - bucket.getCrawlDate();
        this.remainingTime = bucket.getTimeoutSec() - this.elapsedTime;
        this.debugMsg = DEBUG ? (bucket.getBucketState() == Bucket.State.CRAWLING ? "Crawling" : "Recycle") : "";
    }

    public String toXML() {
        return format.format(new Object[]{this.url.toString(), this.activatedURLs, this.crawledURLs, this.remainingTime, this.elapsedTime, (double)this.elapsedTime / (double)(this.crawledURLs <= 1 ? 1 : this.crawledURLs - 1), this.id}) + this.debugMsg;
    }

    public int countActivatedURLs() {
        return this.activatedURLs;
    }

    public int coutnCrawledURLs() {
        return this.crawledURLs;
    }

    public int getActivatedURLs() {
        return this.activatedURLs;
    }

    public String getId() {
        return this.id;
    }

    public int getElapsedTime() {
        return this.elapsedTime;
    }

    public int getCrawledURLs() {
        return this.crawledURLs;
    }

    public int getRemainingTime() {
        return this.remainingTime;
    }

    public CURL getUrl() {
        return this.url;
    }

    public double getInterval() {
        return (double)this.elapsedTime / (double)(this.crawledURLs <= 1 ? 1 : this.crawledURLs - 1);
    }
}

