/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.admin;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.CrawlerMonitor;
import com.ibm.es.nuvo.crawler.URIStatus;
import com.ibm.es.nuvo.crawler.web.Ant;
import com.ibm.es.nuvo.crawler.web.WebCrawler;
import com.ibm.es.nuvo.crawler.web.bucket.ActiveBucketInfo;
import com.ibm.es.nuvo.crawler.web.bucket.Bucket;
import com.ibm.es.nuvo.crawler.web.bucket.BucketManager;
import com.ibm.es.nuvo.crawler.web.bucket.FederatedBucketManager;
import com.ibm.es.nuvo.crawler.web.configuration.notify.ConfigChangeListener;
import com.ibm.es.nuvo.crawler.web.configuration.notify.ConfigEventBroaker;
import com.ibm.es.nuvo.crawler.web.configuration.space.CrawlSpaceConfig;
import com.ibm.es.nuvo.crawler.web.db.URLInserter;
import com.ibm.es.nuvo.crawler.web.db.tables.URLTable;
import com.ibm.es.nuvo.crawler.web.error.GenericException;
import com.ibm.es.nuvo.crawler.web.error.WCException;
import com.ibm.es.nuvo.crawler.web.net.CURL;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.util.XMLTagger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WCMonitor
implements ConfigChangeListener {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final int ENABLE_SITE_WITH_DNS = 1;
    public static final int ENABLE_SITE_DISCOVERED = 2;
    public static final int ENABLE_URL_DISCOVERED = 4;
    public static final int ENABLE_PAGE_SAVED = 8;
    public static final int ENABLE_URLS_CRAWLED = 16;
    public static final int ENABLE_OVERDUE_URLS = 32;
    public static final int ENABLE_HTTP_CODE_DISTRIBUTION = 64;
    public static final int ENABLE_CRAWL_RATE = 128;
    public static final int ENABLE_RECENT_URL = 256;
    public static final int ENABLE_URLS_THIS_SESSION = 512;
    private static ExtendedLogger logger = Loggers.logger;
    private static Map<String, WCMonitor> instances = new HashMap<String, WCMonitor>();
    private String id;
    private BucketManager manager;
    private CrawlerMonitor.CrawlerState state = CrawlerMonitor.CrawlerState.INACTIVE;
    private static final String[] INFO_COLUMNS = new String[]{"crawldate", "recrawldate", "httpcode", "discoverer", "flags1", "modifieddate", "urlstr"};
    private boolean m_atValidURLLimit;
    private String[] m_recentlyCrawledURLs;
    private int m_nURLsReportedThisSession;
    private Lock lock = new ReentrantLock();
    private ThoughputMonitor throughputMonitor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized WCMonitor forName(String id) {
        WCMonitor monitor;
        if (id == null) {
            id = ConfigEventBroaker.GLOBAL;
        }
        if ((monitor = instances.get(id)) == null) {
            Map<String, WCMonitor> map = instances;
            synchronized (map) {
                monitor = instances.get(id);
                if (monitor == null) {
                    monitor = new WCMonitor(id);
                    instances.put(id, monitor);
                }
            }
        }
        if (monitor != null) {
            monitor.setManager();
        }
        return monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drop(String id) {
        Map<String, WCMonitor> map = instances;
        synchronized (map) {
            instances.remove(id);
        }
    }

    private boolean isActiveSpace() {
        return WCMonitor.isActiveSpace(this.id);
    }

    public static boolean isActiveSpace(String id) {
        return FederatedBucketManager.instance().isActive(id) || ConfigEventBroaker.GLOBAL.equals(id);
    }

    private WCMonitor(String id) {
        this.id = id;
        this.applyChange();
        ConfigEventBroaker.register(id, this);
        this.setManager();
    }

    private void setManager() {
        if (this.manager == null && !ConfigEventBroaker.GLOBAL.equals(this.id)) {
            this.manager = FederatedBucketManager.instance().getManager(this.id);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getCrawlerStatus() {
        void var5_9;
        this.setManager();
        Map<String, Integer> userAgentStates = Ant.instance().getUserAgentStates();
        XMLTagger tagger = new XMLTagger();
        this.addHeader(tagger);
        tagger.openStartElement("CrawlerStatus");
        tagger.closeTag();
        int total = 0;
        for (Integer n : userAgentStates.values()) {
            total += n.intValue();
        }
        tagger.openStartElement("CrawlerThreadStateDist");
        tagger.writeAttr("Count", userAgentStates.size());
        tagger.writeAttr("Total", total);
        tagger.closeTag();
        for (Map.Entry entry : userAgentStates.entrySet()) {
            tagger.openStartElement("CrawlerThreadState");
            tagger.writeAttr("State", (String)entry.getKey());
            tagger.writeAttr("Count", ((Integer)entry.getValue()).intValue());
            tagger.closeEndElementTag();
        }
        tagger.endElement("CrawlerThreadStateDist");
        double[] load = Ant.instance().getLoad();
        tagger.openStartElement("CrawlerThreadStatistics");
        tagger.closeTag();
        boolean bl = false;
        while (var5_9 < load.length) {
            tagger.openStartElement("CrawlerThread");
            tagger.writeAttr("ID", (long)var5_9);
            tagger.writeAttr("LoadAverage", load[var5_9]);
            tagger.closeEndElementTag();
            ++var5_9;
        }
        tagger.endElement("CrawlerThreadStatistics");
        List<ActiveBucketInfo> list = FederatedBucketManager.instance().getActiveBucketInfo();
        tagger.openStartElement("ActiveBucketList");
        tagger.writeAttr("Count", list.size());
        tagger.closeTag();
        int numActivatedUrl = 0;
        int numCrawledUrl = 0;
        if (list.size() > 0) {
            for (ActiveBucketInfo activeBucketInfo : list) {
                tagger.openStartElement("ActiveBucket");
                tagger.writeAttr("CrawlerID", activeBucketInfo.getId());
                tagger.writeAttr("URL", activeBucketInfo.getUrl().toString());
                tagger.writeAttr("Total", activeBucketInfo.getActivatedURLs());
                tagger.writeAttr("Crawled", activeBucketInfo.getCrawledURLs());
                tagger.writeAttr("TimeRem", activeBucketInfo.getRemainingTime());
                tagger.writeAttr("Duration", activeBucketInfo.getElapsedTime());
                tagger.writeAttr("Interval", activeBucketInfo.getInterval());
                tagger.closeEndElementTag();
                numActivatedUrl += activeBucketInfo.countActivatedURLs();
                numCrawledUrl += activeBucketInfo.coutnCrawledURLs();
            }
        }
        tagger.endElement("ActiveBucketList");
        list.clear();
        tagger.endElement("CrawlerStatus");
        return tagger.getXML();
    }

    public String getCrawlSpaceStatus(int selection) {
        this.setManager();
        XMLTagger tagger = new XMLTagger();
        this.addHeader(tagger);
        tagger.openStartElement("CrawlSpaceStatus");
        tagger.closeTag();
        tagger.openStartElement("State");
        tagger.closeTag();
        tagger.writeText(this.state.toString());
        tagger.endElement("State");
        if ((selection & 0x80) > 0) {
            double tp = this.getThroughput();
            tagger.openStartElement("CrawlRate");
            tagger.writeAttr("Value", tp);
            tagger.closeEndElementTag();
        }
        if ((selection & 0x200) > 0) {
            tagger.openStartElement("NumURLsThisSession");
            tagger.writeAttr("Value", this.getNURLsReportedThisSession());
            tagger.closeEndElementTag();
        }
        if ((selection & 0x100) > 0) {
            List<String> list = this.getRecentlyCrawledURLs();
            tagger.openStartElement("RecentlyCrawledURLList");
            tagger.writeAttr("Count", list == null ? 0L : (long)list.size());
            tagger.closeTag();
            if (list != null && list.size() > 0) {
                for (String url : list) {
                    tagger.openStartElement("RecentlyCrawledURL");
                    tagger.writeAttr("URL", url);
                    tagger.closeEndElementTag();
                }
            }
            tagger.endElement("RecentlyCrawledURLList");
        }
        this.getCrawlStatus(tagger, selection);
        tagger.endElement("CrawlSpaceStatus");
        return tagger.getXML();
    }

    private void getCrawlStatus(XMLTagger tagger, int selections) {
        if (selections < 0) {
            selections = 65535;
        }
        try {
            if ((selections & 2) != 0) {
                this.getSitesDiscovered(tagger);
            }
            if ((selections & 1) != 0) {
                this.getSitesWDNS(tagger);
            }
            if ((selections & 4) != 0) {
                this.getURLsDiscovered(tagger);
            }
            if ((selections & 8) != 0) {
                this.getPagesSaved(tagger);
            }
            if ((selections & 0x10) != 0) {
                this.getURLsCrawled(tagger);
            }
            if ((selections & 0x20) != 0) {
                this.getURLsOverdue(tagger);
            }
            if ((selections & 0x40) != 0) {
                this.getHttpCodeDistribution(tagger);
            }
        }
        catch (Throwable t) {
            ExtendedException exception = new ExtendedException("C4919W.MONITOR_FAIL", t);
            logger.log(Level.WARNING, exception);
        }
    }

    private void getSitesDiscovered(XMLTagger tagger) throws Exception {
        tagger.openStartElement("NumSitesDiscovered");
        BucketManager m = FederatedBucketManager.instance().getManager(this.id);
        tagger.writeAttr("Value", m == null ? 0L : (long)m.count());
        tagger.closeEndElementTag();
    }

    private void getSitesWDNS(XMLTagger tagger) throws Exception {
        tagger.openStartElement("NumSitesWithDNS");
        BucketManager m = FederatedBucketManager.instance().getManager(this.id);
        tagger.writeAttr("Value", m == null ? 0L : (long)m.countBucketsInDNSState(true));
        tagger.closeEndElementTag();
    }

    private void getURLsDiscovered(XMLTagger tagger) throws Exception {
        tagger.openStartElement("NumURLsDiscovered");
        tagger.writeAttr("Value", URLInserter.instance().getNumInserted(this.id));
        tagger.closeEndElementTag();
    }

    private void getPagesSaved(XMLTagger tagger) throws Exception {
        tagger.openStartElement("NumUniquePagesSaved");
        tagger.writeAttr("Value", this.manager == null ? 0L : (long)this.manager.getValidURLcount());
        tagger.closeEndElementTag();
    }

    private void getURLsCrawled(XMLTagger tagger) throws SQLException, WCException {
        tagger.openStartElement("NumURLsCrawled");
        URLTable instance = URLTable.getInstance(this.id);
        tagger.writeAttr("Value", instance == null ? 0L : (long)instance.countCrawledURL());
        tagger.closeEndElementTag();
    }

    private void getURLsOverdue(XMLTagger tagger) throws Exception {
        tagger.openStartElement("NumURLsOverdue");
        URLTable table = URLTable.getInstance(this.id);
        tagger.writeAttr("Value", table == null ? 0L : (long)table.countOverDueUrl());
        tagger.closeEndElementTag();
    }

    private void getHttpCodeDistribution(XMLTagger tagger) throws Exception {
        URLTable table = URLTable.getInstance(this.id);
        Map<Object, Object> map = table == null ? new HashMap() : table.getCodeDistribution(null);
        int total = 0;
        Iterator<Object> i$ = map.values().iterator();
        while (i$.hasNext()) {
            int n = (Integer)i$.next();
            total += n;
        }
        tagger.openStartElement("HTTPCodeDist");
        tagger.writeAttr("Count", map.size());
        tagger.writeAttr("Total", total);
        tagger.closeTag();
        for (Map.Entry entry : map.entrySet()) {
            tagger.openStartElement("HTTPCode");
            tagger.writeAttr("Code", ((Integer)entry.getKey()).intValue());
            tagger.writeAttr("Count", ((Integer)entry.getValue()).intValue());
            tagger.closeEndElementTag();
        }
        tagger.endElement("HTTPCodeDist");
    }

    private void addHeader(XMLTagger tagger) {
        tagger.startPI("xml");
        tagger.writeAttr("version", "1.0");
        tagger.writeAttr("encoding", "UTF-8");
        tagger.endPI();
    }

    public String getSitesWithoutDNS(int maxResults) {
        StringBuilder sb = new StringBuilder();
        List<Bucket> list = FederatedBucketManager.instance().getBucketsForDNSUpdate();
        int count = list.size();
        if (maxResults > 0 && count > maxResults) {
            count = maxResults;
        }
        sb.append("<SitesWithoutDNSList Count=\"").append(count).append("\">\n");
        Iterator<Bucket> iterator = list.iterator();
        while (count-- > 0) {
            Bucket bucket = iterator.next();
            String s = XMLTagger.escapeXMLValue(bucket.siteURL("/").toString());
            sb.append(" <SiteWithoutDNS URL=\"").append(s).append("\"/>\n");
        }
        list.clear();
        sb.append("</SitesWithoutDNSList>\n");
        return sb.toString();
    }

    public String getURLStatus(String urlString) throws GenericException {
        String opName = "getURLStatus";
        if (urlString == null || urlString.length() == 0) {
            GenericException ge = new GenericException("G0002I.TRACE_MESSAGE", new Object[]{urlString + " " + opName});
            Loggers.tracer.log(Level.WARNING, "G0002I.TRACE_MESSAGE", urlString + " " + opName);
            throw ge;
        }
        CURL url = new CURL(urlString);
        String urlStatus = "Not found";
        int crawldate = 0;
        int recrawldate = 0;
        int httpcode = 0;
        int flags = 0;
        int modifieddate = 0;
        String discovererURLString = "(unknown)";
        if (!url.isValid()) {
            urlStatus = "Invalid";
        } else {
            try {
                Properties prop = URLTable.getInstance(this.id).getUrlInfo(url.getURLHash().longValue());
                crawldate = Integer.parseInt(prop.getProperty(INFO_COLUMNS[0], "0"));
                recrawldate = Integer.parseInt(prop.getProperty(INFO_COLUMNS[1], "0"));
                httpcode = Integer.parseInt(prop.getProperty(INFO_COLUMNS[2], "0"));
                flags = Integer.parseInt(prop.getProperty(INFO_COLUMNS[4], "0"));
                modifieddate = Integer.parseInt(prop.getProperty(INFO_COLUMNS[5], "0"));
                discovererURLString = prop.getProperty(INFO_COLUMNS[6], "(unknown)");
            }
            catch (Exception e) {
                Message message = new Message("C4920W.MONITOR_URL_STAT", urlString);
                ExtendedException exception = new ExtendedException(message, (Throwable)e);
                logger.log(Level.WARNING, exception);
            }
        }
        XMLTagger tagger = new XMLTagger();
        this.addHeader(tagger);
        tagger.openStartElement("URLStatus");
        tagger.closeTag();
        tagger.openStartElement("URL");
        tagger.writeAttr("Value", urlString);
        tagger.writeAttr("Status", urlStatus);
        tagger.closeEndElementTag();
        this.writeNamedValue(tagger, "LastCrawlDate", crawldate);
        this.writeNamedValue(tagger, "NextCrawlDate", recrawldate);
        this.writeNamedValue(tagger, "LastHTTPCode", httpcode);
        this.writeNamedValue(tagger, "ReferringURL", discovererURLString);
        this.writeNamedValue(tagger, "IndexFlag", (flags & 1) == 0 ? "Yes" : "No");
        this.writeNamedValue(tagger, "LastModifiedTime", modifieddate);
        tagger.endElement("URLStatus");
        return tagger.getXML();
    }

    private void writeNamedValue(XMLTagger tagger, String name, String value) {
        tagger.openStartElement(name);
        tagger.writeAttr("Value", value);
        tagger.closeEndElementTag();
    }

    private void writeNamedValue(XMLTagger tagger, String name, int value) {
        tagger.openStartElement(name);
        tagger.writeAttr("Value", value);
        tagger.closeEndElementTag();
    }

    public int getNURLsReportedThisSession() {
        return this.m_nURLsReportedThisSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getRecentlyCrawledURLs() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.m_nURLsReportedThisSession < 1) {
            return list;
        }
        String[] stringArray = this.m_recentlyCrawledURLs;
        synchronized (this.m_recentlyCrawledURLs) {
            int length = this.m_recentlyCrawledURLs.length;
            for (int i = 0; i < length; ++i) {
                int idx = (i + this.m_nURLsReportedThisSession) % length;
                String url = this.m_recentlyCrawledURLs[idx];
                if (url == null) continue;
                list.add(url);
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getThroughput() {
        if (this.throughputMonitor != null) {
            ThoughputMonitor thoughputMonitor = this.throughputMonitor;
            synchronized (thoughputMonitor) {
                return this.throughputMonitor.getThroughput();
            }
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getDocumentCount() {
        if (this.throughputMonitor != null) {
            ThoughputMonitor thoughputMonitor = this.throughputMonitor;
            synchronized (thoughputMonitor) {
                return this.throughputMonitor.getDocumentCount();
            }
        }
        return new ArrayList<Integer>(0);
    }

    public boolean isAtValidURLLimit() {
        return this.m_atValidURLLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordRecentlyCrawledURL(CURL url) {
        if (url == null || this.m_recentlyCrawledURLs == null) {
            return;
        }
        this.lock.lock();
        try {
            this.m_recentlyCrawledURLs[this.m_nURLsReportedThisSession % this.m_recentlyCrawledURLs.length] = url.downstreamString();
            ++this.m_nURLsReportedThisSession;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setAtValidURLLimit(boolean yesno) {
        this.m_atValidURLLimit = yesno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecordURLLimit(int limit) {
        this.lock.lock();
        try {
            if (this.m_recentlyCrawledURLs == null || this.m_recentlyCrawledURLs.length != limit) {
                String[] strings = new String[limit];
                if (this.m_recentlyCrawledURLs != null) {
                    System.arraycopy(this.m_recentlyCrawledURLs, 0, strings, 0, this.m_recentlyCrawledURLs.length);
                }
                this.m_recentlyCrawledURLs = strings;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void applyChange() {
        if (!ConfigEventBroaker.GLOBAL.equals(this.id) && this.isActiveSpace()) {
            int logURL = CrawlSpaceConfig.forName(this.id).getLogURL();
            this.setRecordURLLimit(logURL);
        }
    }

    public void setState(CrawlerMonitor.CrawlerState state) {
        if (this.state == CrawlerMonitor.CrawlerState.INACTIVE && state != CrawlerMonitor.CrawlerState.INACTIVE) {
            this.applyChange();
        }
        this.state = state;
    }

    public CrawlerMonitor.CrawlerState getState() {
        CrawlerMonitor.CrawlerState crawlerState = this.state;
        if (crawlerState == CrawlerMonitor.CrawlerState.CRAWLING && this.throughputMonitor != null && this.getThroughput() == 0.0 && this.throughputMonitor.getIdleCount() > 30) {
            crawlerState = CrawlerMonitor.CrawlerState.IDLE;
        }
        return crawlerState;
    }

    public List<URIStatus> getURLStatusReport(String urlString, int maxReturned) throws GenericException {
        String opName = "getURLStatus";
        if (urlString == null || urlString.length() == 0) {
            GenericException ge = new GenericException("G0002I.TRACE_MESSAGE", new Object[]{urlString + " " + opName});
            Loggers.tracer.log(Level.WARNING, "G0002I.TRACE_MESSAGE", urlString + " " + opName);
            throw ge;
        }
        URLTable table = URLTable.getInstance(this.id);
        if (table == null) {
            return new ArrayList<URIStatus>();
        }
        List<URIStatus> list = table.reportURLStatus(urlString, maxReturned);
        return list;
    }

    public void startMonitor() {
        if (this.throughputMonitor != null) {
            this.stopMonitor();
        }
        this.throughputMonitor = new ThoughputMonitor(60);
        WebCrawler.scheduleAtFixedRate(this.throughputMonitor, 1000, 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMonitor() {
        if (this.throughputMonitor != null) {
            ThoughputMonitor thoughputMonitor = this.throughputMonitor;
            synchronized (thoughputMonitor) {
                this.throughputMonitor.cancel();
                this.throughputMonitor = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ThoughputMonitor
    extends TimerTask {
        private int[] records;
        private long[] times;
        private int count;
        private int idleCount;
        private Lock updateLock = new ReentrantLock();

        public ThoughputMonitor(int range) {
            if (range < 0) {
                range = 1;
            }
            this.records = new int[range + 1];
            this.times = new long[range + 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double getThroughput() {
            if (this.count < 2) {
                return 0.0;
            }
            this.updateLock.lock();
            try {
                int last = (this.count - 1) % this.records.length;
                int first = this.count < this.records.length ? 0 : this.count % this.records.length;
                int cd = this.records[last] - this.records[first];
                double d = cd;
                return d;
            }
            finally {
                this.updateLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.updateLock.lock();
            try {
                int num;
                int offset = this.count % this.records.length;
                this.records[offset] = num = WCMonitor.this.m_nURLsReportedThisSession;
                this.times[offset] = System.currentTimeMillis();
                ++this.count;
            }
            finally {
                this.updateLock.unlock();
            }
            this.idleCount = this.getThroughput() == 0.0 ? ++this.idleCount : 0;
        }

        public int getIdleCount() {
            return this.idleCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<Integer> getDocumentCount() {
            ArrayList<Integer> list = new ArrayList<Integer>();
            this.updateLock.lock();
            try {
                if (this.count < this.records.length) {
                    for (int i = 0; i < this.count; ++i) {
                        list.add(this.records[i]);
                    }
                } else {
                    for (int i = 0; i < this.records.length; ++i) {
                        list.add(this.records[(i + this.count) % this.records.length]);
                    }
                }
            }
            finally {
                this.updateLock.unlock();
            }
            return list;
        }
    }
}

