/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.crawler.CrawlerControl;
import com.ibm.es.nuvo.crawler.CrawlerMonitor;
import com.ibm.es.nuvo.crawler.URIStatus;
import com.ibm.es.nuvo.crawler.web.Ant;
import com.ibm.es.nuvo.crawler.web.admin.WCMonitor;
import com.ibm.es.nuvo.crawler.web.bucket.ActiveBucketInfo;
import com.ibm.es.nuvo.crawler.web.bucket.FederatedBucketManager;
import com.ibm.es.nuvo.crawler.web.bucket.HostInfo;
import com.ibm.es.nuvo.crawler.web.configuration.CrawlerConfig;
import com.ibm.es.nuvo.crawler.web.configuration.notify.ConfigEventBroaker;
import com.ibm.es.nuvo.crawler.web.configuration.space.CrawlSpaceConfig;
import com.ibm.es.nuvo.crawler.web.db.AsyncDBOperator;
import com.ibm.es.nuvo.crawler.web.db.DBConnectionManager;
import com.ibm.es.nuvo.crawler.web.db.DBTableOperator;
import com.ibm.es.nuvo.crawler.web.db.URLInserter;
import com.ibm.es.nuvo.crawler.web.db.URLUpdater;
import com.ibm.es.nuvo.crawler.web.db.tables.AbstractTable;
import com.ibm.es.nuvo.crawler.web.error.GenericException;
import com.ibm.es.nuvo.crawler.web.error.WCException;
import com.ibm.es.nuvo.crawler.web.http.HTTPTrace;
import com.ibm.es.nuvo.crawler.web.http.URLSorter;
import com.ibm.es.nuvo.crawler.web.http.fetcher.FetcherMonitor;
import com.ibm.es.nuvo.crawler.web.thread.WCThread;
import com.ibm.es.nuvo.crawler.web.thread.WCThreadManager;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.es.nuvo.logging.Loggers;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebCrawler
implements Runnable,
CrawlerControl,
CrawlerMonitor {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + WebCrawler.class.getName());
    public static final String URL_STATUS = "/URIStatusReport";
    private static Lock timerLock = new ReentrantLock();
    private HashMap<String, ReentrantLock> locks = new HashMap();
    private static Timer timer;
    private static boolean shutdowned;

    public WebCrawler() {
        WebCrawler.setShutdownFlag(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Ant ant = Ant.instance();
            ant.configure();
            ant.init();
            ant.start();
            if (ant.stopPending()) {
                Loggers.auditLogger.log(Level.INFO, "C5001I.CRAWLER_STOPPING");
            } else {
                Loggers.auditLogger.log(Level.INFO, "C5000I.CRAWLER_RUNNING");
                ant._waitForState(6);
                if (tracer.isLoggable(Level.FINEST)) {
                    tracer.log(Level.FINEST, "Thread status at exit:\n" + WCThreadManager.instance().getStatus1());
                }
            }
        }
        catch (InterruptedException ignored) {
        }
        catch (Throwable e) {
            if (tracer.isLoggable(Level.FINE)) {
                tracer.log(Level.FINE, "", e);
            }
        }
        finally {
            try {
                this.shutdown();
            }
            catch (Exception ignored) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopCrawl(String crawlSpace) {
        this.lock(crawlSpace);
        try {
            if (Loggers.auditLogger.isLoggable(Level.INFO)) {
                Loggers.auditLogger.log(Level.INFO, "C5020I.STOP_CRAWL_SPACE", new Object[]{crawlSpace});
            }
            try {
                URLUpdater.instance().flush();
            }
            catch (Exception e) {
                tracer.log(Level.FINE, "", e);
            }
            try {
                URLInserter.instance().flush();
            }
            catch (Exception e) {
                tracer.log(Level.FINE, "", e);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            FederatedBucketManager.instance().stopCrawl(crawlSpace);
        }
        finally {
            this.unlock(crawlSpace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause(String collectionId, String crawlerId) {
        this.lock(crawlerId);
        try {
            this.stopCrawl(crawlerId);
        }
        finally {
            this.unlock(crawlerId);
        }
    }

    @Override
    public void resume(String collectionId, String crawlerId) throws ExtendedException {
        this.lock(crawlerId);
        try {
            this.startCrawl(collectionId, crawlerId, null);
        }
        catch (WCException e) {
            throw new ExtendedException(e);
        }
        finally {
            this.unlock(crawlerId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyConfig(String crawlSpace, Properties config) {
        if (crawlSpace == null) {
            Object object = config.get("crawler.global.configured.object");
            if (object == null) {
                return;
            }
            CrawlerConfig.setInstance((CrawlerConfig)object);
            ConfigEventBroaker.notify(ConfigEventBroaker.GLOBAL);
            if (Loggers.auditLogger.isLoggable(Level.INFO)) {
                Loggers.auditLogger.log(Level.INFO, "C5023I.CONFIGURATION_CHANGED", new Object[]{"GLOBAL"});
            }
        } else {
            this.lock(crawlSpace);
            try {
                if (Loggers.auditLogger.isLoggable(Level.INFO)) {
                    Loggers.auditLogger.log(Level.INFO, "C5023I.CONFIGURATION_CHANGED", new Object[]{crawlSpace});
                }
                CrawlSpaceConfig.updateConfig(crawlSpace, (CrawlSpaceConfig)config.get("crawler.configured.object"));
                ConfigEventBroaker.notify(crawlSpace);
            }
            finally {
                this.unlock(crawlSpace);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop(String crawlSpaceId, Properties config) throws ExtendedException {
        this.lock(crawlSpaceId);
        try {
            String path = config.getProperty("crawler.metadata.db.path");
            DBConnectionManager dbManager = DBConnectionManager.instance();
            if (path != null) {
                dbManager.putDBPath(crawlSpaceId, path);
            }
            if (!dbManager.available(crawlSpaceId)) {
                tracer.fine("No db path");
                return;
            }
            try {
                FederatedBucketManager.instance().drop(crawlSpaceId, config);
            }
            catch (Exception e) {
                throw new ExtendedException(e);
            }
            if (Loggers.auditLogger.isLoggable(Level.INFO)) {
                Loggers.auditLogger.log(Level.INFO, "C5006I.DROP_CRAWL_SPACE", new Object[]{crawlSpaceId});
            }
            this.clearSessionHistory(crawlSpaceId);
        }
        finally {
            this.unlock(crawlSpaceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Timer getTimer() {
        timerLock.lock();
        try {
            if (timer == null) {
                timer = new Timer("WebCrawlerTimer", true);
            }
        }
        finally {
            timerLock.unlock();
        }
        return timer;
    }

    private static void setShutdownFlag(boolean flag) {
        shutdowned = flag;
    }

    public static void scheduleAtFixedRate(TimerTask task, int delay, int repeat) {
        WebCrawler.schedule(task, delay, repeat, true);
    }

    public static void schedule(TimerTask task, long delay, long repeat) {
        WebCrawler.schedule(task, delay, repeat, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void schedule(TimerTask task, long delay, long repeat, boolean fixed) {
        timerLock.lock();
        boolean renewed = false;
        try {
            while (true) {
                WebCrawler.getTimer();
                try {
                    if (fixed) {
                        timer.scheduleAtFixedRate(task, delay, repeat);
                    } else if (repeat > 0L) {
                        timer.schedule(task, delay, repeat);
                    } else {
                        timer.schedule(task, delay);
                    }
                    tracer.log(Level.FINE, "Scheduled " + task);
                }
                catch (IllegalStateException e) {
                    tracer.log(Level.FINE, "", e);
                    if (renewed || shutdowned) {
                        throw e;
                    }
                    renewed = true;
                    timer = null;
                    continue;
                }
                break;
            }
        }
        finally {
            timerLock.unlock();
        }
    }

    public static void schedule(TimerTask task, long deley) {
        WebCrawler.schedule(task, deley, 0L);
    }

    @Override
    public String getCrawlerStatus(String element, Object ... option) {
        if ("/CrawlerStatus".equals(element)) {
            return WCMonitor.forName(ConfigEventBroaker.GLOBAL).getCrawlerStatus();
        }
        return "";
    }

    @Override
    public String getCrawlSpaceStatus(String id, String element, Object ... options) throws GenericException {
        this.lock(id);
        try {
            WCMonitor monitor = WCMonitor.forName(id);
            if (monitor == null) {
                String string = null;
                return string;
            }
            if ("/CrawlSpaceStatus/State".equals(element)) {
                String string = monitor.getCrawlSpaceStatus(0);
                return string;
            }
            if ("/CrawlSpaceStatus".equals(element)) {
                int selection = -1;
                if (options.length > 0) {
                    selection = (Integer)options[0];
                }
                String string = monitor.getCrawlSpaceStatus(selection);
                return string;
            }
            if (options == null || options.length < 1) {
                String string = null;
                return string;
            }
            if (URL_STATUS.equals(element)) {
                String string = monitor.getURLStatus((String)options[0]);
                return string;
            }
            throw new UnsupportedOperationException("Not implemented.");
        }
        finally {
            this.unlock(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<URIStatus> getURLStatusReport(String crawlSpaceId, String urlPattern, String dbPath, int maxReturned) {
        this.lock(crawlSpaceId);
        try {
            WCMonitor monitor = WCMonitor.forName(crawlSpaceId);
            if (dbPath != null && crawlSpaceId != null) {
                DBConnectionManager.instance().putDBPath(crawlSpaceId, dbPath);
            }
            if (monitor == null) {
                List<URIStatus> list = null;
                return list;
            }
            List<URIStatus> list = monitor.getURLStatusReport(urlPattern, maxReturned);
            return list;
        }
        finally {
            this.unlock(crawlSpaceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startCrawl(String collectionId, String crawlerId, Properties config) throws WCException {
        this.lock(crawlerId);
        try {
            if (Loggers.auditLogger.isLoggable(Level.INFO)) {
                Loggers.auditLogger.log(Level.INFO, "C5019I.START_CRAWL_SPACE", new Object[]{crawlerId});
            }
            if (config != null) {
                String dbpath = config.getProperty("crawler.metadata.db.path");
                if (dbpath != null) {
                    DBConnectionManager.instance().putDBPath(crawlerId, dbpath);
                }
                DBConnectionManager.instance().setCollectionID(collectionId, crawlerId);
                CrawlerConfig cc = (CrawlerConfig)config.get("crawler.global.configured.object");
                if (cc != null) {
                    CrawlerConfig.setInstance(cc);
                }
                CrawlSpaceConfig crawlSpaceConfig = (CrawlSpaceConfig)config.get("crawler.configured.object");
                crawlSpaceConfig.setId(crawlerId);
                crawlSpaceConfig.setCollectionId(collectionId);
                CrawlSpaceConfig.updateConfig(crawlerId, crawlSpaceConfig);
                String recrawl = config.getProperty("crawler.force.full.recrawl", "false");
                crawlSpaceConfig.setForceRecrawl(Boolean.valueOf(recrawl));
            }
            DBTableOperator.instance().checkTables(crawlerId);
            FederatedBucketManager.instance().startCrawl(crawlerId, null);
            FetcherMonitor.instance().activate(crawlerId);
        }
        finally {
            this.unlock(crawlerId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        block30: {
            block29: {
                block28: {
                    if (shutdowned) {
                        return;
                    }
                    WebCrawler.setShutdownFlag(true);
                    CrawlSpaceConfig.invalidateAll();
                    if (tracer.isLoggable(Level.FINE)) {
                        tracer.fine("Stopping agents");
                    }
                    try {
                        Ant.instance().stopAgents();
                    }
                    catch (WCException ignored) {
                        // empty catch block
                    }
                    if (tracer.isLoggable(Level.FINE)) {
                        tracer.fine("Flushing metadata");
                    }
                    try {
                        URLUpdater.instance().flush();
                    }
                    catch (Exception ignored) {
                        if (!tracer.isLoggable(Level.FINE)) break block28;
                        tracer.log(Level.FINE, "Flushing URLUpdater", ignored);
                    }
                }
                try {
                    URLInserter.instance().flush();
                }
                catch (Exception ignored) {
                    if (!tracer.isLoggable(Level.FINE)) break block29;
                    tracer.log(Level.FINE, "Flushing URLInserter", ignored);
                }
            }
            if (tracer.isLoggable(Level.FINE)) {
                tracer.fine("Stopping bucket manager");
            }
            FederatedBucketManager.instance().shutdown();
            if (tracer.isLoggable(Level.FINE)) {
                tracer.fine("Stopping metadata db");
            }
            AbstractTable.shutdown();
            timerLock.lock();
            try {
                if (timer == null) break block30;
                Timer ignored = timer;
                synchronized (ignored) {
                    timer.cancel();
                }
                timer = null;
            }
            finally {
                timerLock.unlock();
            }
        }
        if (tracer.isLoggable(Level.FINE)) {
            tracer.fine("Stopping other threads");
        }
        try {
            Ant.instance().stop();
        }
        catch (WCException ignored) {
            // empty catch block
        }
        if (tracer.isLoggable(Level.FINE)) {
            tracer.fine("Releasing resources");
        }
        try {
            Ant.instance().release();
        }
        catch (WCException ignored) {
            // empty catch block
        }
        long wait = System.currentTimeMillis() + 60000L;
        try {
            for (WCThread thread : WCThreadManager.instance().getThreads()) {
                while (wait < System.currentTimeMillis()) {
                    thread.join(1000L);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (tracer.isLoggable(Level.FINE)) {
            tracer.fine("shutdown completed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CrawlerMonitor.CrawlerState getCrawlSpaceState(String id) throws ExtendedException {
        this.lock(id);
        try {
            WCMonitor monitor = WCMonitor.forName(id);
            if (monitor == null) {
                CrawlerMonitor.CrawlerState crawlerState = CrawlerMonitor.CrawlerState.INACTIVE;
                return crawlerState;
            }
            CrawlerMonitor.CrawlerState crawlerState = monitor.getState();
            return crawlerState;
        }
        finally {
            this.unlock(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeDB(String crawlSpaceID, String dbPath) throws ExtendedException {
        this.lock(crawlSpaceID);
        try {
            if (crawlSpaceID == null || dbPath == null) {
                return;
            }
            DBConnectionManager.instance().putDBPath(crawlSpaceID, dbPath);
            DBTableOperator.instance().checkTables(crawlSpaceID);
        }
        finally {
            this.unlock(crawlSpaceID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HTTPTrace> getHTTPTrace(String id) {
        this.lock(id);
        try {
            FetcherMonitor monitor = FetcherMonitor.instance();
            if (!monitor.isActive(id)) {
                ArrayList<HTTPTrace> arrayList = new ArrayList<HTTPTrace>();
                return arrayList;
            }
            List<HTTPTrace> list = monitor.list(id);
            return list;
        }
        finally {
            this.unlock(id);
        }
    }

    @Deprecated
    public List<HostInfo> getHostInfo(String id, String dbPath) {
        return null;
    }

    private void lock(String id) {
        block5: {
            try {
                ReentrantLock lock = this.getLock(id);
                if (lock.isLocked() && tracer.isLoggable(Level.FINER)) {
                    tracer.finer("Already Locked " + id);
                }
                lock.lockInterruptibly();
                if (tracer.isLoggable(Level.FINER)) {
                    Exception e;
                    StackTraceElement[] stackTrace;
                    String stack = " ";
                    if (tracer.isLoggable(Level.FINEST) && (stackTrace = (e = new Exception()).getStackTrace()).length > 1) {
                        stack = " " + stackTrace[1].getMethodName();
                    }
                    tracer.finer("Locked " + id + stack);
                }
            }
            catch (InterruptedException ignored) {
                if (!tracer.isLoggable(Level.FINER)) break block5;
                tracer.finer("Lock interrupted " + id);
            }
        }
    }

    private void unlock(String id) {
        this.getLock(id).unlock();
        if (tracer.isLoggable(Level.FINER)) {
            tracer.finer("Unlocked " + id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReentrantLock getLock(String id) {
        ReentrantLock lock = this.locks.get(id);
        if (lock == null) {
            HashMap<String, ReentrantLock> hashMap = this.locks;
            synchronized (hashMap) {
                lock = this.locks.get(id);
                if (lock == null) {
                    lock = new ReentrantLock(true);
                    this.locks.put(id, lock);
                }
            }
        }
        assert (lock != null);
        return lock;
    }

    @Override
    public String takeSnapshot() {
        StringBuilder builder = new StringBuilder();
        builder.append("Thread status\n");
        builder.append(WCThreadManager.instance().getStatus1());
        URLSorter.instance().takeSnapshot(builder);
        builder.append("DB queues \n");
        AsyncDBOperator[] ops = new AsyncDBOperator[]{URLInserter.instance(), URLUpdater.instance()};
        DateFormat format = SimpleDateFormat.getDateTimeInstance();
        for (AsyncDBOperator inserter : ops) {
            builder.append("Class: ");
            builder.append(inserter.getClass());
            builder.append("\nLast flush ");
            builder.append(format.format(new Date(inserter.getLastFlush())));
            builder.append("\nNumber of waiting/ready requests ");
            builder.append(inserter.countQueue(true));
            builder.append("/");
            builder.append(inserter.countQueue(false));
            builder.append("\n");
        }
        builder.append("Active hosts\n");
        List<ActiveBucketInfo> list = FederatedBucketManager.instance().getActiveBucketInfo();
        for (ActiveBucketInfo info : list) {
            builder.append(info.toXML());
        }
        FederatedBucketManager.instance().takeSnapshot(builder);
        return builder.toString();
    }

    public boolean waitForShutdownDB(String spaceId, long timeout) {
        block5: {
            if (FederatedBucketManager.instance().isActive(spaceId)) {
                return false;
            }
            long end = System.currentTimeMillis() + timeout * 1000L;
            DBConnectionManager manager = DBConnectionManager.instance();
            try {
                while (manager.isActiveDB(spaceId)) {
                    if (timeout != 0L && (timeout <= 0L || System.currentTimeMillis() <= end)) {
                        Thread.sleep(100L);
                        continue;
                    }
                    break block5;
                }
                return true;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePublishedDocuments(String collecitonId, String spaceId) {
        this.lock(spaceId);
        try {
            if (tracer.isLoggable(Level.FINER)) {
                tracer.finer("start updatePublishedDocuments for " + collecitonId + " " + spaceId);
            }
            FederatedBucketManager.instance().updatePublishedDocuments(collecitonId);
            if (FederatedBucketManager.instance().isActive(spaceId)) {
                CrawlSpaceConfig conf = CrawlSpaceConfig.forName(spaceId).alterSpace();
                Properties properties = new Properties();
                properties.put("crawler.configured.object", conf);
                this.applyConfig(spaceId, properties);
                if (tracer.isLoggable(Level.FINER)) {
                    tracer.finer("applied new configuration for " + spaceId);
                }
            }
        }
        catch (Exception e) {
            if (tracer.isLoggable(Level.FINE)) {
                tracer.log(Level.FINE, "updatePublishedDocuments " + collecitonId + " " + spaceId, e);
            }
        }
        finally {
            this.unlock(spaceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPublishedDocumentUpdated(String collectionId, String spaceId) {
        this.lock(spaceId);
        try {
            boolean bl = FederatedBucketManager.instance().isPublishedDocumentUpdated(collectionId);
            return bl;
        }
        finally {
            this.unlock(spaceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSessionHistory(String crawlSpaceId) {
        this.lock(crawlSpaceId);
        try {
            FetcherMonitor monitor = FetcherMonitor.instance();
            monitor.clear(crawlSpaceId);
            WCMonitor.drop(crawlSpaceId);
        }
        finally {
            this.unlock(crawlSpaceId);
        }
    }
}

