/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.crawler.web.WebCrawler;
import com.ibm.es.nuvo.crawler.web.admin.WCMonitor;
import com.ibm.es.nuvo.crawler.web.configuration.PublishableConfig;
import com.ibm.es.nuvo.crawler.web.configuration.loader.WebCrawlSpaceConfigLoader;
import com.ibm.es.nuvo.crawler.web.configuration.loader.WebCrawlerConfigLoader;
import com.ibm.es.nuvo.crawler.web.configuration.space.CrawlSpaceConfig;
import com.ibm.es.nuvo.crawler.web.error.MissingArgumentException;
import com.ibm.es.nuvo.crawler.web.error.NotANumberException;
import com.ibm.es.nuvo.crawler.web.error.WCException;
import com.ibm.es.nuvo.crawler.web.http.HTTPTrace;
import com.ibm.es.nuvo.crawler.web.util.XMLFormatHandler;
import com.ibm.es.nuvo.logging.Loggers;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.List;
import java.util.Properties;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.LogManager;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class StandAloneWebCrawler {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final String s_agentName = "Standalone";
    private static final boolean START_COL1 = true;
    private static final boolean AUTO_STOP_START = false;
    private Properties config = new Properties();
    static String s_configdir;
    static String s_datadir;
    private WebCrawler crawler;
    private Thread crawlerThread;
    private PublishableConfig col1;
    private PublishableConfig col2;
    private PublishableConfig global;
    private static final String s_optLetters = "cdL";
    private static final boolean[] s_numeric;
    private static Object[] s_rv;

    public static void displayHelp() {
        StringBuilder buf = new StringBuilder("\n Usage:\n");
        buf.append("\tjava com.ibm.wc.adm.WCStandalone -c <config_dir> -d <data_dir>\n");
        buf.append("\n");
        System.out.println(buf.toString());
    }

    public static void commandHelp() {
        System.out.println("--------------------");
        System.out.println("startCrawl              : s  col [force]");
        System.out.println("stopCrawl               : t  col");
        System.out.println("configure               : i  col");
        System.out.println("stop                    : q");
        System.out.println("drop                    : d col");
        System.out.println("getCrawlerStatus        : r0");
        System.out.println("getCrawlSpaceStatus     : r1 col mask");
        System.out.println("getURIStatus            : r2 col URI");
        System.out.println("getHTTPTrace            : r3 col");
        System.out.println("getRefreshStatus        : r4 col");
        System.out.println("refreshCollection       : refresh col");
        System.out.println("takeSnapshot            : r5");
        System.out.println("clearHistory            : c col");
        System.out.println("help/menu               : h");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commandLineOperation() {
        StandAloneWebCrawler.commandHelp();
        BufferedReader fin = null;
        try {
            String inputLine;
            String dbPath = s_datadir + "/col1";
            this.config.put("crawler.configured.object", this.col1);
            this.config.setProperty("crawler.metadata.db.path", dbPath);
            this.crawler.initializeDB("col1", dbPath);
            this.crawler.startCrawl("col1", "col1", this.config);
            System.out.println("Started");
            fin = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("> ");
            while (!Thread.interrupted() && (inputLine = fin.readLine()) != null) {
                String[] args = inputLine.trim().split("[ \t]+");
                try {
                    WCMonitor monitor;
                    CrawlSpaceConfig c;
                    if (args.length == 0) continue;
                    if (args[0].equalsIgnoreCase("q")) {
                        this.crawler.shutdown();
                        this.crawlerThread.interrupt();
                        break;
                    }
                    if (args[0].equalsIgnoreCase("h")) {
                        StandAloneWebCrawler.commandHelp();
                    } else if (args[0].equalsIgnoreCase("r0")) {
                        StandAloneWebCrawler.dumpXML(this.crawler.getCrawlerStatus("/CrawlerStatus", new Object[0]));
                    } else if (args[0].equalsIgnoreCase("r5")) {
                        System.out.println(this.crawler.takeSnapshot());
                    }
                    if (args.length < 2) continue;
                    String uri = args[1];
                    if (args[0].equalsIgnoreCase("s")) {
                        if ("col2".equals(args[1])) {
                            this.config.put("crawler.configured.object", this.col2);
                            this.config.setProperty("crawler.metadata.db.path", s_datadir + "/col2");
                        } else {
                            this.config.put("crawler.configured.object", this.col1);
                            this.config.setProperty("crawler.metadata.db.path", dbPath);
                        }
                        if (args.length > 2 && uri.equals("force")) {
                            this.config.setProperty("crawler.force.full.recrawl", "true");
                        } else {
                            this.config.setProperty("crawler.force.full.recrawl", "false");
                        }
                        this.crawler.startCrawl(args[1], args[1], this.config);
                    } else if (args[0].equalsIgnoreCase("t")) {
                        this.crawler.stopCrawl(args[1]);
                    } else if (args[0].equalsIgnoreCase("d")) {
                        if ("col2".equals(args[1])) {
                            this.config.setProperty("crawler.metadata.db.path", s_datadir + "/col2");
                        } else {
                            this.config.setProperty("crawler.metadata.db.path", dbPath);
                        }
                        this.crawler.drop(args[1], this.config);
                    } else if (args[0].equalsIgnoreCase("i")) {
                        this.configure();
                        if ("col2".equals(args[1])) {
                            this.config.put("crawler.configured.object", this.col2);
                            this.config.setProperty("crawler.metadata.db.path", s_datadir + "/col2");
                        } else if ("col1".equals(args[1])) {
                            this.config.put("crawler.configured.object", this.col1);
                            this.config.setProperty("crawler.metadata.db.path", dbPath);
                        } else {
                            args[1] = null;
                        }
                        this.crawler.applyConfig(args[1], this.config);
                    } else if (args[0].equalsIgnoreCase("r3")) {
                        List<HTTPTrace> traces = this.crawler.getHTTPTrace(args[1]);
                        for (HTTPTrace trace : traces) {
                            System.out.println(trace);
                        }
                    } else if (args[0].equalsIgnoreCase("refresh")) {
                        c = (CrawlSpaceConfig)("col2".equals(args[1]) ? this.col2 : this.col1);
                        this.crawler.updatePublishedDocuments(c.getCollectionId(), c.getId());
                    } else if (args[0].equalsIgnoreCase("r4")) {
                        c = (CrawlSpaceConfig)("col2".equals(args[1]) ? this.col2 : this.col1);
                        boolean b = this.crawler.isPublishedDocumentUpdated(c.getCollectionId(), c.getId());
                        System.out.println(b ? "refreshed" : "Not yet refreshed");
                    } else if (args[0].equalsIgnoreCase("c")) {
                        this.crawler.clearSessionHistory(args[1]);
                    }
                    if ((monitor = WCMonitor.forName(args[1])) == null) continue;
                    if (args[0].equalsIgnoreCase("r1")) {
                        StandAloneWebCrawler.dumpXML(this.crawler.getCrawlSpaceStatus(args[1], "/CrawlSpaceStatus", -1));
                    }
                    if (!args[0].equalsIgnoreCase("r2")) continue;
                    uri = args.length < 3 ? "%" : args[2];
                    int maxRetuened = 0;
                    if (args.length > 3) {
                        maxRetuened = Integer.parseInt(args[3]);
                    }
                    System.out.println(this.crawler.getURLStatusReport(args[1], uri, null, maxRetuened));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                finally {
                    System.out.print("> ");
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void reinit() throws Exception {
    }

    public static void main(String[] args) {
        new StandAloneWebCrawler().exec(args);
    }

    private void exec(String[] args) {
        try {
            Object[] opts = StandAloneWebCrawler._processArgs(args);
            s_configdir = (String)opts[s_optLetters.indexOf(99)];
            s_datadir = (String)opts[s_optLetters.indexOf(100)];
            System.out.println("config dir: " + s_configdir);
            System.out.println("data dir: " + s_datadir);
            this.configure();
            this.crawler = new WebCrawler();
            this.crawlerThread = new Thread(this.crawler);
            this.crawlerThread.start();
            this.crawler.applyConfig(null, this.config);
            WebCrawler.schedule(new LoggerConfigUpdater(), 1000L, 1000L);
            this.commandLineOperation();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (OutOfMemoryError oome) {
            throw oome;
        }
        finally {
            System.out.println("The Standalone process terminated.");
        }
    }

    private void configure() throws ExtendedException, FileNotFoundException {
        this.global = (PublishableConfig)WebCrawlerConfigLoader.instance().load(null, new FileInputStream(s_configdir + "/webcrawler.xml"));
        this.col1 = (PublishableConfig)WebCrawlSpaceConfigLoader.instance().load("col1", new FileInputStream(s_configdir + "/col1.xml"));
        this.col2 = (PublishableConfig)WebCrawlSpaceConfigLoader.instance().load("col2", new FileInputStream(s_configdir + "/col2.xml"));
        this.config.put("crawler.global.configured.object", this.global);
    }

    private static Object[] _processArgs(String[] args) throws WCException {
        int argIx = 0;
        while (argIx < args.length) {
            char opt;
            int optIx;
            String arg;
            if ((arg = args[argIx++]).charAt(0) != '-') {
                System.out.println("Invalid arg " + arg);
            }
            if ((optIx = s_optLetters.indexOf(opt = arg.charAt(1))) < 0) {
                System.out.println("Invalid arg " + arg);
            }
            if (argIx >= args.length) {
                System.out.println("Invalid arg " + arg);
            }
            try {
                if (s_numeric[optIx]) {
                    StandAloneWebCrawler.s_rv[optIx] = new Integer(args[argIx++]);
                    continue;
                }
                StandAloneWebCrawler.s_rv[optIx] = args[argIx++];
            }
            catch (NumberFormatException nfe) {
                throw new NotANumberException(s_agentName, arg);
            }
        }
        if (s_rv[s_optLetters.indexOf(99)] == null) {
            throw new MissingArgumentException(s_agentName, "-c");
        }
        if (s_rv[s_optLetters.indexOf(100)] == null) {
            throw new MissingArgumentException(s_agentName, "-d");
        }
        return s_rv;
    }

    public static void dumpXML(String xml) {
        XMLFormatHandler handler = new XMLFormatHandler();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            parser.parse(new InputSource(new StringReader(xml)), (DefaultHandler)handler);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        s_numeric = new boolean[]{false, false, false};
        s_rv = new Object[]{null, null, null};
    }

    private static class LoggerConfigUpdater
    extends TimerTask {
        private File logConfig;
        private long lastUpdate;

        public LoggerConfigUpdater() {
            String property = System.getProperty("java.util.logging.config.file");
            if (property != null) {
                this.logConfig = new File(property);
                if (!this.logConfig.exists() || !this.logConfig.canRead()) {
                    this.logConfig = null;
                    return;
                }
                this.lastUpdate = this.logConfig.lastModified();
            }
        }

        public void run() {
            long lastModified;
            if (this.logConfig == null) {
                this.cancel();
                return;
            }
            if (Loggers.tracer.isLoggable(Level.FINEST) || Loggers.tracer.getHandlers() != null && Loggers.tracer.getHandlers().length > 0) {
                this.lastUpdate = 0L;
            }
            if ((lastModified = this.logConfig.lastModified()) != this.lastUpdate) {
                LogManager manager = LogManager.getLogManager();
                try {
                    manager.readConfiguration(new FileInputStream(this.logConfig));
                    System.out.println("Loger was updated");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.cancel();
                }
                this.lastUpdate = lastModified;
            }
        }
    }
}

