/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.web.configuration.CrawlerConfig;
import com.ibm.es.nuvo.crawler.web.configuration.notify.ConfigChangeListener;
import com.ibm.es.nuvo.crawler.web.configuration.notify.ConfigEventBroaker;
import com.ibm.es.nuvo.crawler.web.db.DBConnectionManager;
import com.ibm.es.nuvo.crawler.web.db.URLInserter;
import com.ibm.es.nuvo.crawler.web.db.URLUpdater;
import com.ibm.es.nuvo.crawler.web.error.WCException;
import com.ibm.es.nuvo.crawler.web.http.URLScanner;
import com.ibm.es.nuvo.crawler.web.http.UserAgent;
import com.ibm.es.nuvo.crawler.web.thread.WCQRunnableImpl;
import com.ibm.es.nuvo.crawler.web.thread.WCRunnableImpl;
import com.ibm.es.nuvo.crawler.web.thread.WCThreadManager;
import com.ibm.es.nuvo.crawler.web.util.WCRequest;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.es.nuvo.logging.Loggers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ant
extends WCQRunnableImpl
implements ConfigChangeListener {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static ExtendedLogger logger = Loggers.logger;
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + Ant.class.getName());
    private static Ant instance = new Ant();
    private int nextAgentId = 0;
    private URLScanner urlScanner;
    private List<UserAgent> userAgents = new ArrayList<UserAgent>();
    private List<WCRunnableImpl> startList = new ArrayList<WCRunnableImpl>();
    private List<WCRunnableImpl> stopList = new ArrayList<WCRunnableImpl>();
    private List<WCRunnableImpl> pauseResumeList = new ArrayList<WCRunnableImpl>();
    private List<WCRunnableImpl> releaseList = new ArrayList<WCRunnableImpl>();

    private Ant() {
        super("Ant");
        this.setQueueSizes(5);
        this.setQueueTimeoutSec(5);
        ConfigEventBroaker.register(ConfigEventBroaker.GLOBAL, this);
    }

    public static Ant instance() {
        return instance;
    }

    public void requestStop() {
        block2: {
            try {
                this.stop();
            }
            catch (WCException e) {
                if (!tracer.isLoggable(Level.FINE)) break block2;
                tracer.log(Level.FINE, "stop", e);
            }
        }
    }

    public void configure() throws Exception {
        this.setConfigured(true);
    }

    @Override
    public void _clientInit() throws Exception {
        if (this._stopRequested()) {
            return;
        }
        DBConnectionManager.instance().init();
        if (this._stopRequested()) {
            return;
        }
        URLUpdater.instance().init();
        URLInserter.instance().init();
        if (this._stopRequested()) {
            return;
        }
        this.urlScanner = new URLScanner();
        this.urlScanner.init();
        if (this._stopRequested()) {
            return;
        }
        this.prepareAgents();
        this._assignThread("Ant", "Ant");
        this.startList.clear();
        this.startList.add(URLUpdater.instance());
        this.startList.add(URLInserter.instance());
        this.startList.add(this.urlScanner);
        this.pauseResumeList.clear();
        this.pauseResumeList.add(this.urlScanner);
        this.pauseResumeList.add(URLUpdater.instance());
        this.pauseResumeList.add(URLInserter.instance());
        this.stopList.clear();
        this.stopList.add(this.urlScanner);
        this.stopList.add(URLUpdater.instance());
        this.stopList.add(URLInserter.instance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareAgents() throws WCException {
        int maxConnections = CrawlerConfig.getInstance().getMaxConnections();
        List<UserAgent> list = this.userAgents;
        synchronized (list) {
            int size;
            if (size < maxConnections) {
                for (size = this.userAgents.size(); size < maxConnections; ++size) {
                    UserAgent agent = new UserAgent(this.nextAgentId++);
                    agent.init();
                    agent.start();
                    this.userAgents.add(agent);
                    this.pauseResumeList.add(agent);
                }
            } else if (size > maxConnections) {
                while (size > maxConnections) {
                    UserAgent agent = this.userAgents.remove(size - 1);
                    agent.stop();
                    --size;
                }
            }
        }
    }

    @Override
    public void _clientStart() throws Exception {
        if (this._stopRequested()) {
            return;
        }
        this.setSubRunLevel("Starting ");
        for (int j = 0; j < this.startList.size(); ++j) {
            WCRunnableImpl r = this.startList.get(j);
            if (r == null) continue;
            if (this._stopRequested()) {
                return;
            }
            r.start();
        }
        super._clientStart();
        this.setSubRunLevel("Started");
    }

    @Override
    public void _processRequest(WCRequest request) throws Exception {
        if (request instanceof AntRequest) {
            this.setSubRunLevel("Processing request");
            this.stop();
        } else if (tracer.isLoggable(Level.FINE)) {
            tracer.log(Level.FINE, "Unsupported Request" + request.toString());
        }
    }

    @Override
    public void _processTimeout() throws Exception {
        this._logThreadStatus();
    }

    @Override
    public void _clientStop() throws Exception {
        this.stopAgents();
        this.setSubRunLevel("Stopping");
        for (WCRunnableImpl r : this.stopList) {
            if (r == null) continue;
            try {
                r.stop();
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                Message message = new Message("C4901W.ANT_EXCEPTION", "STOP");
                ExtendedException exception = new ExtendedException(message, (Throwable)e);
                logger.log(Level.WARNING, exception);
            }
        }
        super._clientStop();
        long timeout = System.currentTimeMillis() + 60000L;
        for (WCRunnableImpl r : this.releaseList) {
            if (r == null) continue;
            while (!r.wasRunExited() && timeout < System.currentTimeMillis()) {
                Thread.sleep(1000L);
            }
        }
        this.setSubRunLevel("Stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAgents() throws WCException {
        List<UserAgent> list = this.userAgents;
        synchronized (list) {
            for (UserAgent agent : this.userAgents) {
                agent.stop();
            }
            try {
                boolean wait = true;
                int sleep = 1000;
                int maxWait = CrawlerConfig.getInstance().getSoTimeout() * 1000 / sleep;
                while (true) {
                    wait = false;
                    for (UserAgent agent : this.userAgents) {
                        if (agent.wasRunExited()) continue;
                        wait = true;
                        Lock lock = agent.getInterruptionLock();
                        if (!lock.tryLock()) continue;
                        try {
                            agent.interrupt();
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                    if (wait) {
                        --maxWait;
                        this.userAgents.wait(sleep);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.userAgents.clear();
        }
    }

    @Override
    public void _clientPause() throws Exception {
        this.setSubRunLevel("Pausing ");
        for (WCRunnableImpl r : this.pauseResumeList) {
            if (r == null) continue;
            try {
                r.pause();
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                Message message = new Message("C4901W.ANT_EXCEPTION", "PAUSE");
                ExtendedException exception = new ExtendedException(message, (Throwable)e);
                logger.log(Level.WARNING, exception);
            }
        }
        this.setSubRunLevel("Paused");
    }

    @Override
    public void _clientResume() throws Exception {
        this.setSubRunLevel("Resuming ");
        for (int j = this.pauseResumeList.size() - 1; j >= 0; --j) {
            WCRunnableImpl r = this.pauseResumeList.get(j);
            if (r == null) continue;
            try {
                r.resume();
                continue;
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                Message message = new Message("C4901W.ANT_EXCEPTION", "RESUME");
                ExtendedException exception = new ExtendedException(message, (Throwable)e);
                logger.log(Level.WARNING, exception);
            }
        }
        this.setSubRunLevel("Resumed");
    }

    @Override
    public void _clientRelease() throws Exception {
        this.setSubRunLevel("Releasing");
        for (WCRunnableImpl r : this.releaseList) {
            if (r == null) continue;
            try {
                r.release();
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, "C4901W.ANT_EXCEPTION", new Object[]{"RELEASE", e});
            }
        }
        super._clientStop();
        this.setSubRunLevel("Released");
    }

    private void _logThreadStatus() {
        if (tracer.isLoggable(Level.FINE)) {
            tracer.log(Level.FINE, "Thread Status:\n" + WCThreadManager.instance().getStatus1());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Integer> getUserAgentStates() {
        HashMap<String, Integer> hm = new HashMap<String, Integer>();
        List<UserAgent> list = this.userAgents;
        synchronized (list) {
            if (this.userAgents != null) {
                for (UserAgent agent : this.userAgents) {
                    String key = agent.getSubRunLevel();
                    Integer count = (Integer)hm.get(key);
                    if (count == null) {
                        count = 0;
                    }
                    hm.put(key, count + 1);
                }
            }
        }
        return hm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getLoad() {
        double[] ret = new double[this.userAgents.size()];
        List<UserAgent> list = this.userAgents;
        synchronized (list) {
            int i = 0;
            for (UserAgent agent : this.userAgents) {
                ret[i++] = agent.getLoad();
            }
        }
        return ret;
    }

    @Override
    public void applyChange() throws WCException {
        this.prepareAgents();
    }

    private static class AntRequest
    extends WCRequest {
        private int operation;

        public AntRequest(int operation) {
            super(null);
            this.operation = operation;
        }

        public int getOperation() {
            return this.operation;
        }
    }
}

