/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.view.internal;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.GlobalCrawlerManager;
import com.ibm.es.nuvo.crawler.adapter.Adapter;
import com.ibm.es.nuvo.crawler.adapter.AdapterException;
import com.ibm.es.nuvo.crawler.adapter.Content;
import com.ibm.es.nuvo.crawler.adapter.ContentBody;
import com.ibm.es.nuvo.crawler.adapter.Field;
import com.ibm.es.nuvo.crawler.adapter.FieldIterator;
import com.ibm.es.nuvo.crawler.adapter.FieldType;
import com.ibm.es.nuvo.crawler.admin.CrawlerConfigurationException;
import com.ibm.es.nuvo.crawler.admin.SpaceConfiguration;
import com.ibm.es.nuvo.crawler.config.listener.CollectionCrawlerConfigCache;
import com.ibm.es.nuvo.crawler.config.listener.CollectionCrawlerConfigCacheListener;
import com.ibm.es.nuvo.crawler.runtime.FieldMap;
import com.ibm.es.nuvo.crawler.view.DSViewFetchDocument;
import com.ibm.es.nuvo.crawler.view.DSViewFetchManager;
import com.ibm.es.nuvo.crawler.view.DSViewFetchMetadata;
import com.ibm.es.nuvo.crawler.view.ViewFetchException;
import com.ibm.es.nuvo.crawler.view.internal.ContentsReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DSViewFetchManagerImpl
implements DSViewFetchManager {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private Map<String, FieldMap> FieldMapRepository = new HashMap<String, FieldMap>();

    public InputStream getContentStream(String collectionId, String spaceId, String uri) throws ViewFetchException {
        DSViewFetchDocument content = this.getDocument(collectionId, spaceId, uri);
        if (content != null) {
            return content.getContentStream();
        }
        return null;
    }

    public DSViewFetchDocument getDocument(String collectionId, String spaceId, String uri) throws ViewFetchException {
        ContentsReader reader;
        Content content;
        CollectionCrawlerConfigCacheListener colCache;
        GlobalCrawlerManager gcm = GlobalSystem.getSingleInstance().getGlobalCrawlerManager();
        CollectionCrawlerConfigCache cache = gcm.getCrawlerConfigCache();
        try {
            colCache = cache.getCacheFor(collectionId);
        }
        catch (AdapterException ae) {
            throw new ViewFetchException(ae);
        }
        catch (CrawlerConfigurationException cce) {
            throw new ViewFetchException(cce);
        }
        if (colCache == null) {
            Message msg = new Message("C3902E.CRWL_VIEW_NOT_FOUND_COLLECTION_ID");
            msg.addArgument(collectionId);
            throw new ViewFetchException(msg);
        }
        Adapter adapter = colCache.getAdapter(spaceId);
        if (adapter == null) {
            Message msg = new Message("C3902E.CRWL_VIEW_NOT_FOUND_COLLECTION_ID");
            msg.addArgument(collectionId);
            throw new ViewFetchException(msg);
        }
        SpaceConfiguration space = colCache.getSpaceConfiguration(spaceId);
        if (space == null) {
            Message msg = new Message("C3900E.CRWL_VIEW_NOT_FOUND_SPACE_ID");
            msg.addArgument(spaceId);
            throw new ViewFetchException(msg);
        }
        if (!this.FieldMapRepository.containsKey(spaceId)) {
            try {
                this.FieldMapRepository.put(spaceId, new FieldMap(space));
            }
            catch (CrawlerConfigurationException e) {
                throw new ViewFetchException(e);
            }
        }
        if ((content = (reader = new ContentsReader(adapter, space)).getContent(uri.trim())) != null) {
            return new ViewFetchContentImpl(content, spaceId);
        }
        return null;
    }

    private static class ViewFetchMetadataImpl
    extends DSViewFetchMetadata {
        Field field;
        String externalName;

        public ViewFetchMetadataImpl(Field field, String externalName) {
            this.field = field;
            this.externalName = externalName;
        }

        public String getName() {
            return this.field.getName();
        }

        public String getExternalName() {
            return this.externalName;
        }

        public DSViewFetchMetadata.Type getType() {
            FieldType fType = this.field.getType();
            switch (fType) {
                case STRING: {
                    return DSViewFetchMetadata.Type.STRING;
                }
                case BOOLEAN: {
                    return DSViewFetchMetadata.Type.BOOLEAN;
                }
                case LONG: {
                    return DSViewFetchMetadata.Type.LONG;
                }
                case DOUBLE: {
                    return DSViewFetchMetadata.Type.DOUBLE;
                }
                case DATE: {
                    return DSViewFetchMetadata.Type.DATE;
                }
                case READER: {
                    return DSViewFetchMetadata.Type.READER;
                }
            }
            return DSViewFetchMetadata.Type.UNKNOWN;
        }

        public String getString() throws ViewFetchException {
            try {
                return this.field.getString();
            }
            catch (AdapterException e) {
                throw new ViewFetchException(e);
            }
        }

        public boolean getBoolean() throws ViewFetchException {
            try {
                return this.field.getBoolean();
            }
            catch (AdapterException e) {
                throw new ViewFetchException(e);
            }
        }

        public Date getDate() throws ViewFetchException {
            try {
                return this.field.getDate();
            }
            catch (AdapterException e) {
                throw new ViewFetchException(e);
            }
        }

        public double getDouble() throws ViewFetchException {
            try {
                return this.field.getDouble();
            }
            catch (AdapterException e) {
                throw new ViewFetchException(e);
            }
        }

        public long getLong() throws ViewFetchException {
            try {
                return this.field.getLong();
            }
            catch (AdapterException e) {
                throw new ViewFetchException(e);
            }
        }

        public Reader getReader() throws ViewFetchException {
            try {
                return this.field.getReader();
            }
            catch (AdapterException e) {
                throw new ViewFetchException(e);
            }
            catch (IOException e) {
                throw new ViewFetchException(e);
            }
        }
    }

    private class ViewFetchContentImpl
    extends DSViewFetchDocument {
        Content content;
        String spaceId;

        public ViewFetchContentImpl(Content content, String spaceId) {
            this.content = content;
            this.spaceId = spaceId;
        }

        public InputStream getContentStream() throws ViewFetchException {
            InputStream inputStream = null;
            try {
                ContentBody body = this.content.getBody();
                if (body != null) {
                    inputStream = body.getStream();
                }
            }
            catch (AdapterException e) {
                throw new ViewFetchException(e);
            }
            catch (IOException e) {
                throw new ViewFetchException(e);
            }
            return inputStream;
        }

        public DSViewFetchMetadata[] getMetadata(boolean allFields) throws ViewFetchException {
            ArrayList<ViewFetchMetadataImpl> fields = new ArrayList<ViewFetchMetadataImpl>();
            try {
                FieldIterator fieldItr = this.content.getFields();
                while (fieldItr.hasNext()) {
                    Field field = fieldItr.next();
                    String externalName = ((FieldMap)DSViewFetchManagerImpl.this.FieldMapRepository.get(this.spaceId)).map(field.getName());
                    if (allFields) {
                        externalName = externalName != null ? externalName : field.getName();
                        fields.add(new ViewFetchMetadataImpl(field, externalName));
                        continue;
                    }
                    if (externalName == null) continue;
                    fields.add(new ViewFetchMetadataImpl(field, externalName));
                }
            }
            catch (AdapterException e) {
                throw new ViewFetchException(e);
            }
            return fields.toArray(new DSViewFetchMetadata[0]);
        }

        public String getContentFilename() throws ViewFetchException {
            String retVal = null;
            try {
                String orgFilename;
                ContentBody body;
                if (this.content != null && (body = this.content.getBody()) != null && (orgFilename = body.getFilename()) != null) {
                    try {
                        retVal = URLEncoder.encode(orgFilename, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        retVal = orgFilename;
                    }
                }
            }
            catch (AdapterException e) {
                throw new ViewFetchException(e);
            }
            return retVal;
        }
    }
}

