/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.view.internal;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.adapter.Adapter;
import com.ibm.es.nuvo.crawler.adapter.AdapterException;
import com.ibm.es.nuvo.crawler.adapter.ConfigurationElement;
import com.ibm.es.nuvo.crawler.adapter.ConfigurationMap;
import com.ibm.es.nuvo.crawler.adapter.Content;
import com.ibm.es.nuvo.crawler.adapter.ListConfiguration;
import com.ibm.es.nuvo.crawler.adapter.SimpleContent;
import com.ibm.es.nuvo.crawler.adapter.Space;
import com.ibm.es.nuvo.crawler.admin.Configuration;
import com.ibm.es.nuvo.crawler.admin.ConfigurationItem;
import com.ibm.es.nuvo.crawler.admin.CrawlerConfigurationException;
import com.ibm.es.nuvo.crawler.admin.SpaceConfiguration;
import com.ibm.es.nuvo.crawler.view.ViewFetchException;
import java.util.Collection;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentsReader {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private SpaceConfiguration crawledSpace;
    private Adapter adapter;

    @Deprecated
    public ContentsReader() {
    }

    public ContentsReader(Adapter adapter, SpaceConfiguration space) {
        this.adapter = adapter;
        this.crawledSpace = space;
    }

    public Content getContent(String uri) throws ViewFetchException {
        try {
            Space space = this.openResource(this.crawledSpace, this.adapter.getRootSpace());
            SimpleContent content = (SimpleContent)space.getContent(uri);
            return content;
        }
        catch (AdapterException e) {
            Message msg = new Message("C3901E.CRWL_VIEW_NOT_FOUND_URI");
            msg.addArgument(uri);
            msg.addArgument(this.crawledSpace.getID());
            throw new ViewFetchException(msg, (Throwable)e);
        }
        catch (IllegalAccessError e) {
            e.printStackTrace();
            throw new ViewFetchException(e);
        }
        catch (CrawlerConfigurationException e) {
            e.printStackTrace();
            throw new ViewFetchException(e);
        }
    }

    public Space openResource(SpaceConfiguration spaceConfig, Space sp) throws AdapterException, CrawlerConfigurationException, IllegalAccessError {
        ConfigurationItem current;
        Space space = sp;
        Stack<SpaceConfiguration> stack = new Stack<SpaceConfiguration>();
        for (current = spaceConfig; current != null; current = current.getParent()) {
            stack.push((SpaceConfiguration)current);
        }
        current = (ConfigurationItem)stack.pop();
        while (!stack.isEmpty()) {
            this.applyConfig(current.getConfigurations().values(), space.getConfigurations());
            space.open();
            current = (ConfigurationItem)stack.pop();
            space = space.getSubSpace(current.getName());
        }
        this.applyConfig(current.getConfigurations().values(), space.getConfigurations());
        space.open();
        this.applyConfig(spaceConfig.getCrawlSpaceConfigurations().values(), space.getCrawlSpaceConfigurations());
        return space;
    }

    private void applyConfig(Collection<Configuration> source, ConfigurationMap target) throws AdapterException {
        block6: for (Configuration sourceElt : source) {
            ConfigurationElement targetElt = target.get(sourceElt.getName());
            if (targetElt == null) continue;
            switch (targetElt.getType()) {
                case STRING: {
                    targetElt.setString(sourceElt.getString());
                    break;
                }
                case BOOLEAN: {
                    targetElt.setBoolean(sourceElt.getBoolean());
                    break;
                }
                case LONG: {
                    targetElt.setLong(sourceElt.getLong());
                    break;
                }
                case LIST: {
                    ListConfiguration targetList = targetElt.getList();
                    for (Configuration.ListItem sourceItem : sourceElt.getItems()) {
                        ListConfiguration.Item targetItem = targetList.get(sourceItem.getValue());
                        if (targetItem != null) {
                            targetItem.setSelected(sourceItem.isSelected());
                            continue;
                        }
                        targetList.add(sourceItem.getValue()).setSelected(sourceItem.isSelected());
                    }
                    continue block6;
                }
            }
        }
    }
}

