/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.util.text;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DateFormatFactory {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final String ISO8601 = "ISO8601";
    public static final String ISO8601RELAXED = "ISO8601Relaxed";
    public static final String RFC1123 = "RFC1123";
    public static final String RFC850 = "RFC850";
    public static final String ANSI_C_ASCTIME = "ANSIC";
    public static final String HTTP_HEADER = "HttpHeader";
    private static final Pattern ISO8601TZ = Pattern.compile("([\\+-])([012]*[0-9]):([0-5]*[0-9])");

    public static DateFormat getInstance(String name) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String className = DateFormatFactory.class.getName() + "$" + name + "DateFormat";
        Class<?> cls = Class.forName(className);
        return (DateFormat)cls.newInstance();
    }

    protected static class HttpHeaderDateFormat
    extends DateFormat {
        private static final long serialVersionUID = 1L;
        private final DateFormat rfc1123 = new RFC1123DateFormat();
        private final DateFormat rfc850 = new RFC850DateFormat();
        private final DateFormat ansiC = new ANSICDateFormat();

        protected HttpHeaderDateFormat() {
        }

        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
            return this.rfc1123.format(date, toAppendTo, fieldPosition);
        }

        public Date parse(String source, ParsePosition pos) {
            Date ret = this.rfc1123.parse(source, pos);
            if (ret == null) {
                ret = this.rfc850.parse(source, pos);
            }
            if (ret == null) {
                ret = this.ansiC.parse(source, pos);
            }
            return ret;
        }
    }

    protected static class ANSICDateFormat
    extends SimpleDateFormat {
        private static final long serialVersionUID = 1L;

        public ANSICDateFormat() {
            super("EEE MMM d HH:mm:ss yyyy", Locale.US);
            this.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
    }

    protected static class RFC850DateFormat
    extends SimpleDateFormat {
        private static final long serialVersionUID = 1L;

        public RFC850DateFormat() {
            super("EEEEEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US);
            this.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
    }

    protected static class RFC1123DateFormat
    extends SimpleDateFormat {
        private static final long serialVersionUID = 1L;

        public RFC1123DateFormat() {
            super("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            this.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
    }

    protected static class ISO8601DateFormatBase
    extends SimpleDateFormat {
        private static final long serialVersionUID = 1L;

        public ISO8601DateFormatBase(String initialFormat) {
            super(initialFormat);
            this.setTimeZone(TimeZone.getTimeZone("GMT"));
        }

        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition pos) {
            return super.format(date, toAppendTo, pos).append("Z");
        }

        public Date parse(String text, ParsePosition pos) {
            Date ret = super.parse(text, pos);
            if (ret != null) {
                String tz;
                int index = pos.getIndex();
                if ((tz = text.substring(index++)).equals("Z")) {
                    pos.setIndex(index++);
                } else if (tz.startsWith("+") || tz.startsWith("-")) {
                    Matcher m = ISO8601TZ.matcher(tz);
                    if (m.find()) {
                        int diff = ("-".equals(m.group(1)) ? -1 : 1) * Integer.parseInt(m.group(2)) * 60 + Integer.parseInt(m.group(3));
                        ret = new Date(ret.getTime() - (long)diff * 60000L);
                    } else {
                        ret = null;
                    }
                } else {
                    ret = null;
                }
            }
            return ret;
        }
    }

    protected static class ISO8601RelaxedDateFormat
    extends ISO8601DateFormatBase {
        private static final long serialVersionUID = 1L;

        public ISO8601RelaxedDateFormat() {
            super("yyyy-MM-dd'T'HH:mm:ss");
        }
    }

    protected static class ISO8601DateFormat
    extends ISO8601DateFormatBase {
        private static final long serialVersionUID = 1L;

        public ISO8601DateFormat() {
            super("yyyy-MM-dd'T'HH:mm:ss.SSS");
        }
    }
}

