/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.util.migration;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.util.XMLTagger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FSCrawlerConfigMigration {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final boolean DEBUG = false;
    private static final String SEPARATOR = File.separator;
    private static final String WHITNEY_ELEM_TARGET = "Target";
    private static final String WHITNEY_ELEM_EXCLUDED_DIRECTORIES = "ExcludedDirectories";
    private static final String WHITNEY_ELEM_DIRECTORY = "Directory";
    private static final String WHITNEY_ATT_NAME = "Name";
    private static final String ELBRUS_ELEM_CRAWLER_RUNTIME = "crawler-runtime";
    private static final String ELBRUS_ELEM_SCHEDULE = "schedule";
    private static final String ELBRUS_ELEM_CRAWLER = "crawler";
    private static final String ELBRUS_ELEM_SPACE = "space";
    private static final String ELBRUS_ELEM_CRAWLER_SPACE = "crawlspace";
    private static final String ELBRUS_ELEM_PROPERTY = "property";
    private static final String ELBRUS_ELEM_ITEM = "item";
    private static final String ELBRUS_ELEM_FIELD = "field";
    private static final String ELBRUS_ATT_NAME = "name";
    private static final String ELBRUS_ATT_ID = "id";
    private static final String ELBRUS_ATT_TYPE = "type";
    private static final String ELBRUS_ATT_ENABLE = "enabled";
    private static final String ELBRUS_ATT_ATTRIBUTES = "attributes";
    private static final String ELBRUS_ATT_CRAWLSPACE_PARAM = "crawlspace-param";
    private static final String ELBRUS_ATT_OPTIONS = "options";
    private static final String ELBRUS_ATT_OPTIONS_MANDATORY = "mandatory";
    private static final String ELBRUS_ATT_OPTIONS_NO_FORCE = "no_force";
    private static final String VALUE_BOOLEAN = "boolean";
    private static final String VALUE_TRUE = "true";
    private static final String VALUE_STRING = "string";
    private static final String VALUE_LONG = "long";
    private static final String VALUE_DATE = "date";
    private static final String VALUE_LIST_MULTI = "list_multi";
    private static final String VALUE_SYSTEM = "system";
    private static final String ELBRUS_ADAPTER_TYPE = "com.ibm.es.nuvo.crawler.adapter.file";
    private static final String ELBRUS_CRAWLER_NAME = "_fscrawler";
    private static final String ELBRUS_MAX_PAGE_LENGTH = "es:max_page_length";
    private static final String ELBRUS_MAX_PAGE_LENGTH_VARUE = "52428800";
    private static final String ELBRUS_MAX_CONNECTION = "es:max_connections";
    private static final String ELBRUS_MAX_CONNECTION_VARUE = "10";
    private static final String ELBRUS_CRAWLER_PLUGIN = "es:crawler_plugin";
    private static final String ELBRUS_CRAWLER_PLUGIN_CLASSPATH = "es:crawler_plugin_classpath";
    private static final String ELBRUS_CRAWLER_PLUGIN_EXCLUDE = "es:crawler_plugin_exclude";
    private static final String ELBRUS_FETCH_INTERVAL = "es:fetch_interval";
    private static final String ELBRUS_FETCH_INTERVAL_VARUE = "0";
    private static final String ELBRUS_MIMETYPE = "es:mimetype";
    private static final String ELBRUS_KNOWN_MIMETYPE = "es:known_mimetype";
    private static final String ELBRUS_LANGUAGE = "es:language";
    private static final String ELBRUS_KNOWN_LANGUAGE = "es:known_language";
    private static final String ELBRUS_CHARSET = "es:charset";
    private static final String ELBRUS_KNOWN_CHARSET = "es:known_charset";
    private static final String ELBRUS_EXCLUDE_EXTENSIONS = "es:exclude_extensions";
    private static final String ELBRUS_LASTMODIFIED_DATE = "lastmodified_date";
    private static final String ELBRUS_DIRNAME = "dirname";
    private static final String ELBRUS_FILENAME = "filename";
    private static final String ELBRUS_CRAWLED_DATE = "crawled_date";
    private static final String ELBRUS_CONTENT_SIZE = "content_size";
    private static final String ELBRUS_SUBDIR_LEVEL = "subdirectory_level";
    private static final String ELBRUS_SUBDIR_LEVEL_VARUE = "-1";
    private static final String ELBRUS_NETWORK_FOLDER = "network_folder";
    private static final String ELBRUS_NETWORK_USER = "network_user";
    private static final String ELBRUS_NETWORK_PASSWORD = "network_password";
    private static final String ELBRUS_EXCLUDED_PATTERNS = "exclude_patterns";
    private static final String[] EXTENSTIONS = new String[]{".", ".Z", ".a", ".aif", ".au", ".avi", ".bmp", ".cab", ".class", ".com", ".dib", ".dll", ".exe", ".gif", ".ico", ".jar", ".jfif", ".jpe", ".jpeg", ".jpg", ".lib", ".lnk", ".lzh", ".mid", ".midi", ".mov", ".mp3", ".mpeg", ".mpg", ".o", ".obj", ".ocx", ".pif", ".png", ".qt", ".ra", ".ram", ".reg", ".res", ".rm", ".snd", ".so", ".tif", ".tiff", ".wav", ".wm", ".wma", ".wmv", ".xpm"};

    public void migrateFileCrawlerData(InputStream originalCrawlspace, String outputDirectory) throws ExtendedException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        Reader in = null;
        Writer out = null;
        String migratedFileName = null;
        migratedFileName = "crawler_config.xml";
        try {
            SAXParser parser = factory.newSAXParser();
            FSConfigHandler handler = new FSConfigHandler();
            parser.parse(originalCrawlspace, (DefaultHandler)handler);
            File migratedFile = new File(outputDirectory + File.separator + migratedFileName);
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(migratedFile), "UTF-8");
            in = new StringReader(handler.getMigratedXMLConfig());
            int length = 1024;
            char[] buffer = new char[length];
            while ((length = in.read(buffer)) != -1) {
                out.write(buffer, 0, length);
            }
        }
        catch (ParserConfigurationException e) {
            throw new ExtendedException(e);
        }
        catch (SAXException e) {
            throw new ExtendedException(e);
        }
        catch (IOException e) {
            throw new ExtendedException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
            if (originalCrawlspace != null) {
                try {
                    originalCrawlspace.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String outputDir = "./";
        File file = new File(args[0]);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            new FSCrawlerConfigMigration().migrateFileCrawlerData(fis, outputDir);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (ExtendedException e) {
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    ((InputStream)fis).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static class FSConfigHandler
    extends DefaultHandler {
        EntryTree tree = new EntryTree();
        private String originalTargetPath;
        private List<String> originalExcludedPattern = new ArrayList<String>();
        private XMLTagger tagger = new XMLTagger(true, true);
        private Random random = new Random();
        private Set<String> ids = new HashSet<String>();

        FSConfigHandler() {
        }

        private String getRandomId() {
            StringBuilder id = new StringBuilder(10);
            int i = this.random.nextInt(999999999);
            id.append(i);
            if (id.length() > 10) {
                id = id.delete(10, id.length());
            } else if (id.length() != 10) {
                while (id.length() < 10) {
                    id.append(FSCrawlerConfigMigration.ELBRUS_FETCH_INTERVAL_VARUE);
                }
            }
            if (!this.ids.contains(id.toString())) {
                this.ids.add(id.toString());
                return "mig_" + id.toString();
            }
            return this.getRandomId();
        }

        public String getMigratedXMLConfig() {
            return this.tagger.getXML();
        }

        public void startElement(String uri, String localString, String qName, Attributes attributes) {
            if (qName.equals(FSCrawlerConfigMigration.WHITNEY_ELEM_TARGET)) {
                this.originalTargetPath = null;
                this.originalTargetPath = attributes.getValue(FSCrawlerConfigMigration.WHITNEY_ATT_NAME);
            } else if (qName.equals(FSCrawlerConfigMigration.WHITNEY_ELEM_EXCLUDED_DIRECTORIES)) {
                this.originalExcludedPattern.clear();
            } else if (qName.equals(FSCrawlerConfigMigration.WHITNEY_ELEM_DIRECTORY)) {
                this.originalExcludedPattern.add(attributes.getValue(FSCrawlerConfigMigration.WHITNEY_ATT_NAME));
            }
        }

        public void characters(char[] ch, int offset, int length) {
        }

        public void endElement(String uri, String localName, String qName) {
            if (qName.equals(FSCrawlerConfigMigration.WHITNEY_ELEM_TARGET)) {
                this.tree.addOriginalTarget(this.originalTargetPath, this.originalExcludedPattern.toArray(new String[0]));
                this.originalTargetPath = null;
                this.originalExcludedPattern.clear();
            }
        }

        public void endDocument() {
            Entry root = this.tree.getRoot();
            this.tagger.startElement(FSCrawlerConfigMigration.ELBRUS_ELEM_CRAWLER_RUNTIME);
            this.tagger.startElement(FSCrawlerConfigMigration.ELBRUS_ELEM_SCHEDULE);
            this.tagger.endElement(FSCrawlerConfigMigration.ELBRUS_ELEM_SCHEDULE);
            this.tagger.openStartElement(FSCrawlerConfigMigration.ELBRUS_ELEM_CRAWLER);
            this.tagger.writeAttr(FSCrawlerConfigMigration.ELBRUS_ATT_ID, this.getRandomId());
            this.tagger.writeAttr(FSCrawlerConfigMigration.ELBRUS_ATT_NAME, FSCrawlerConfigMigration.ELBRUS_CRAWLER_NAME);
            this.tagger.writeAttr(FSCrawlerConfigMigration.ELBRUS_ATT_TYPE, FSCrawlerConfigMigration.ELBRUS_ADAPTER_TYPE);
            this.tagger.closeTag();
            this.writeCrawlerProperties(this.tagger);
            for (Entry top : root.getChildren()) {
                this.writeSpaces(top, this.tagger);
            }
            this.tagger.endElement(FSCrawlerConfigMigration.ELBRUS_ELEM_CRAWLER);
            this.tagger.endElement(FSCrawlerConfigMigration.ELBRUS_ELEM_CRAWLER_RUNTIME);
        }

        private void writeSpaces(Entry entry, XMLTagger xmlTagger) {
            List<Entry> children = entry.getChildren();
            if (children.size() == 0) {
                xmlTagger.openStartElement(FSCrawlerConfigMigration.ELBRUS_ELEM_CRAWLER_SPACE);
                xmlTagger.writeAttr(FSCrawlerConfigMigration.ELBRUS_ATT_ID, this.getRandomId());
                xmlTagger.writeAttr(FSCrawlerConfigMigration.ELBRUS_ATT_NAME, this.normalize(entry.getName()));
                xmlTagger.closeTag();
                this.writeCrawlSpaceProperties(xmlTagger, entry.getExcludedPattern());
                xmlTagger.endElement(FSCrawlerConfigMigration.ELBRUS_ELEM_CRAWLER_SPACE);
            } else {
                if (entry.isCrawlSpace()) {
                    xmlTagger.openStartElement(FSCrawlerConfigMigration.ELBRUS_ELEM_CRAWLER_SPACE);
                } else {
                    xmlTagger.openStartElement(FSCrawlerConfigMigration.ELBRUS_ELEM_SPACE);
                }
                xmlTagger.writeAttr(FSCrawlerConfigMigration.ELBRUS_ATT_ID, this.getRandomId());
                xmlTagger.writeAttr(FSCrawlerConfigMigration.ELBRUS_ATT_NAME, this.normalize(entry.getName()));
                xmlTagger.closeTag();
                if (entry.isCrawlSpace()) {
                    this.writeCrawlSpaceProperties(xmlTagger, entry.getExcludedPattern());
                }
                for (Entry child : children) {
                    this.writeSpaces(child, xmlTagger);
                }
                if (entry.isCrawlSpace()) {
                    xmlTagger.endElement(FSCrawlerConfigMigration.ELBRUS_ELEM_CRAWLER_SPACE);
                } else {
                    xmlTagger.endElement(FSCrawlerConfigMigration.ELBRUS_ELEM_SPACE);
                }
            }
        }

        private String normalize(String name) {
            if (name.length() == 2 && name.endsWith(":")) {
                name = name + "\\";
            } else if (name.equals("")) {
                name = "/";
            }
            return name;
        }

        private void writeCrawlerProperties(XMLTagger xmlTagger) {
            this.writeProperty(xmlTagger, FSCrawlerConfigMigration.ELBRUS_MAX_PAGE_LENGTH, FSCrawlerConfigMigration.VALUE_LONG, FSCrawlerConfigMigration.ELBRUS_MAX_PAGE_LENGTH_VARUE, false, false, new String[]{FSCrawlerConfigMigration.ELBRUS_ATT_OPTIONS_MANDATORY});
            this.writeProperty(xmlTagger, FSCrawlerConfigMigration.ELBRUS_NETWORK_FOLDER, FSCrawlerConfigMigration.VALUE_STRING, false, false, null);
            this.writeProperty(xmlTagger, FSCrawlerConfigMigration.ELBRUS_MAX_CONNECTION, FSCrawlerConfigMigration.VALUE_LONG, FSCrawlerConfigMigration.ELBRUS_MAX_CONNECTION_VARUE, false, false, new String[]{FSCrawlerConfigMigration.ELBRUS_ATT_OPTIONS_MANDATORY, FSCrawlerConfigMigration.ELBRUS_ATT_OPTIONS_NO_FORCE});
            this.writeProperty(xmlTagger, FSCrawlerConfigMigration.ELBRUS_NETWORK_PASSWORD, FSCrawlerConfigMigration.VALUE_STRING, false, false, null);
            this.writeProperty(xmlTagger, FSCrawlerConfigMigration.ELBRUS_NETWORK_USER, FSCrawlerConfigMigration.VALUE_STRING, false, false, null);
            this.writeProperty(xmlTagger, FSCrawlerConfigMigration.ELBRUS_CRAWLER_PLUGIN, FSCrawlerConfigMigration.VALUE_STRING, false, false, null);
            this.writeProperty(xmlTagger, FSCrawlerConfigMigration.ELBRUS_CRAWLER_PLUGIN_CLASSPATH, FSCrawlerConfigMigration.VALUE_STRING, false, false, null);
            this.writeProperty(xmlTagger, FSCrawlerConfigMigration.ELBRUS_FETCH_INTERVAL, FSCrawlerConfigMigration.VALUE_LONG, FSCrawlerConfigMigration.ELBRUS_FETCH_INTERVAL_VARUE, false, false, new String[]{FSCrawlerConfigMigration.ELBRUS_ATT_OPTIONS_MANDATORY, FSCrawlerConfigMigration.ELBRUS_ATT_OPTIONS_NO_FORCE});
            this.writeProperty(xmlTagger, FSCrawlerConfigMigration.ELBRUS_CRAWLER_PLUGIN_EXCLUDE, FSCrawlerConfigMigration.VALUE_BOOLEAN, FSCrawlerConfigMigration.VALUE_TRUE, false, false, new String[0]);
        }

        private void writeCrawlSpaceProperties(XMLTagger xmlTagger, String[] excludedPattern) {
            this.writeProperty(xmlTagger, FSCrawlerConfigMigration.ELBRUS_MIMETYPE, FSCrawlerConfigMigration.VALUE_STRING, true, false, new String[]{FSCrawlerConfigMigration.ELBRUS_ATT_OPTIONS_NO_FORCE});
            if (excludedPattern.length == 0) {
                this.writeProperty(xmlTagger, FSCrawlerConfigMigration.ELBRUS_EXCLUDED_PATTERNS, FSCrawlerConfigMigration.VALUE_LIST_MULTI, true, false, new String[]{FSCrawlerConfigMigration.ELBRUS_ATT_OPTIONS_NO_FORCE});
            } else {
                xmlTagger.openStartElement(FSCrawlerConfigMigration.ELBRUS_ELEM_PROPERTY);
                xmlTagger.writeAttr(FSCrawlerConfigMigration.ELBRUS_ATT_NAME, FSCrawlerConfigMigration.ELBRUS_EXCLUDED_PATTERNS);
                xmlTagger.writeAttr(FSCrawlerConfigMigration.ELBRUS_ATT_TYPE, FSCrawlerConfigMigration.VALUE_LIST_MULTI);
                xmlTagger.writeAttr(FSCrawlerConfigMigration.ELBRUS_ATT_CRAWLSPACE_PARAM, FSCrawlerConfigMigration.VALUE_TRUE);
                xmlTagger.writeAttr(FSCrawlerConfigMigration.ELBRUS_ATT_OPTIONS, FSCrawlerConfigMigration.ELBRUS_ATT_OPTIONS_NO_FORCE);
                xmlTagger.closeTag();
                for (String pattern : excludedPattern) {
                    xmlTagger.openStartElement(FSCrawlerConfigMigration.ELBRUS_ELEM_ITEM);
                    xmlTagger.writeAttr(FSCrawlerConfigMigration.ELBRUS_ATT_ENABLE, FSCrawlerConfigMigration.VALUE_TRUE);
                    xmlTagger.closeTag();
                    xmlTagger.writeText(pattern);
                    xmlTagger.endElement(FSCrawlerConfigMigration.ELBRUS_ELEM_ITEM);
                }
                xmlTagger.endElement(FSCrawlerConfigMigration.ELBRUS_ELEM_PROPERTY);
            }
            this.writeProperty(xmlTagger, FSCrawlerConfigMigration.ELBRUS_KNOWN_MIMETYPE, FSCrawlerConfigMigration.VALUE_STRING, true, false, new String[]{FSCrawlerConfigMigration.ELBRUS_ATT_OPTIONS_NO_FORCE});
            this.writeExcludedExtenstions(xmlTagger);
            this.writeProperty(xmlTagger, FSCrawlerConfigMigration.ELBRUS_LANGUAGE, FSCrawlerConfigMigration.VALUE_STRING, true, false, new String[]{FSCrawlerConfigMigration.ELBRUS_ATT_OPTIONS_NO_FORCE});
            this.writeProperty(xmlTagger, FSCrawlerConfigMigration.ELBRUS_KNOWN_LANGUAGE, FSCrawlerConfigMigration.VALUE_STRING, true, false, new String[]{FSCrawlerConfigMigration.ELBRUS_ATT_OPTIONS_NO_FORCE});
            this.writeProperty(xmlTagger, FSCrawlerConfigMigration.ELBRUS_CHARSET, FSCrawlerConfigMigration.VALUE_STRING, true, false, new String[]{FSCrawlerConfigMigration.ELBRUS_ATT_OPTIONS_NO_FORCE});
            this.writeProperty(xmlTagger, FSCrawlerConfigMigration.ELBRUS_KNOWN_CHARSET, FSCrawlerConfigMigration.VALUE_STRING, true, false, new String[]{FSCrawlerConfigMigration.ELBRUS_ATT_OPTIONS_NO_FORCE});
            this.writeProperty(xmlTagger, FSCrawlerConfigMigration.ELBRUS_SUBDIR_LEVEL, FSCrawlerConfigMigration.VALUE_LONG, FSCrawlerConfigMigration.ELBRUS_SUBDIR_LEVEL_VARUE, true, false, new String[]{FSCrawlerConfigMigration.ELBRUS_ATT_OPTIONS_MANDATORY, FSCrawlerConfigMigration.ELBRUS_ATT_OPTIONS_NO_FORCE});
            this.writeFields(xmlTagger, FSCrawlerConfigMigration.ELBRUS_LASTMODIFIED_DATE, FSCrawlerConfigMigration.VALUE_DATE);
            this.writeFields(xmlTagger, FSCrawlerConfigMigration.ELBRUS_DIRNAME, FSCrawlerConfigMigration.VALUE_STRING);
            this.writeFields(xmlTagger, FSCrawlerConfigMigration.ELBRUS_FILENAME, FSCrawlerConfigMigration.VALUE_STRING);
            this.writeFields(xmlTagger, FSCrawlerConfigMigration.ELBRUS_CRAWLED_DATE, FSCrawlerConfigMigration.VALUE_DATE);
            this.writeFields(xmlTagger, FSCrawlerConfigMigration.ELBRUS_CONTENT_SIZE, FSCrawlerConfigMigration.VALUE_LONG);
        }

        private void writeProperty(XMLTagger xmlTagger, String name, String type, boolean isCrawlSpaceProperty, boolean isSystem, String[] options) {
            xmlTagger.openStartElement(FSCrawlerConfigMigration.ELBRUS_ELEM_PROPERTY);
            xmlTagger.writeAttr(FSCrawlerConfigMigration.ELBRUS_ATT_NAME, name);
            xmlTagger.writeAttr(FSCrawlerConfigMigration.ELBRUS_ATT_TYPE, type);
            if (isCrawlSpaceProperty) {
                xmlTagger.writeAttr(FSCrawlerConfigMigration.ELBRUS_ATT_CRAWLSPACE_PARAM, FSCrawlerConfigMigration.VALUE_TRUE);
            }
            if (isSystem) {
                xmlTagger.writeAttr(FSCrawlerConfigMigration.ELBRUS_ATT_ATTRIBUTES, FSCrawlerConfigMigration.VALUE_SYSTEM);
            }
            this.handleOptions(xmlTagger, options);
            xmlTagger.closeTag();
            xmlTagger.endElement(FSCrawlerConfigMigration.ELBRUS_ELEM_PROPERTY);
        }

        private void writeProperty(XMLTagger xmlTagger, String name, String type, String value, boolean isCrawlSpaceProperty, boolean isSystem, String[] options) {
            xmlTagger.openStartElement(FSCrawlerConfigMigration.ELBRUS_ELEM_PROPERTY);
            xmlTagger.writeAttr(FSCrawlerConfigMigration.ELBRUS_ATT_NAME, name);
            xmlTagger.writeAttr(FSCrawlerConfigMigration.ELBRUS_ATT_TYPE, type);
            if (isCrawlSpaceProperty) {
                xmlTagger.writeAttr(FSCrawlerConfigMigration.ELBRUS_ATT_CRAWLSPACE_PARAM, FSCrawlerConfigMigration.VALUE_TRUE);
            }
            if (isSystem) {
                xmlTagger.writeAttr(FSCrawlerConfigMigration.ELBRUS_ATT_ATTRIBUTES, FSCrawlerConfigMigration.VALUE_SYSTEM);
            }
            this.handleOptions(xmlTagger, options);
            xmlTagger.closeTag();
            xmlTagger.writeText(value);
            xmlTagger.endElement(FSCrawlerConfigMigration.ELBRUS_ELEM_PROPERTY);
        }

        private void handleOptions(XMLTagger xmlTagger, String[] options) {
            if (options != null && options.length != 0) {
                StringBuilder optionBuffer = new StringBuilder(100);
                for (String s : options) {
                    optionBuffer.append(s);
                    optionBuffer.append(";");
                }
                optionBuffer.delete(optionBuffer.length() - 1, optionBuffer.length());
                xmlTagger.writeAttr(FSCrawlerConfigMigration.ELBRUS_ATT_OPTIONS, optionBuffer.toString());
            }
        }

        private void writeFields(XMLTagger xmlTagger, String name, String type) {
            xmlTagger.openStartElement(FSCrawlerConfigMigration.ELBRUS_ELEM_FIELD);
            xmlTagger.writeAttr(FSCrawlerConfigMigration.ELBRUS_ATT_NAME, name);
            xmlTagger.writeAttr(FSCrawlerConfigMigration.ELBRUS_ATT_TYPE, type);
            xmlTagger.writeAttr(FSCrawlerConfigMigration.ELBRUS_ATT_ENABLE, FSCrawlerConfigMigration.VALUE_TRUE);
            xmlTagger.writeAttr(FSCrawlerConfigMigration.ELBRUS_ATT_ATTRIBUTES, FSCrawlerConfigMigration.VALUE_SYSTEM);
            xmlTagger.closeTag();
            xmlTagger.endElement(FSCrawlerConfigMigration.ELBRUS_ELEM_FIELD);
        }

        private void writeExcludedExtenstions(XMLTagger xmlTagger) {
            xmlTagger.openStartElement(FSCrawlerConfigMigration.ELBRUS_ELEM_PROPERTY);
            xmlTagger.writeAttr(FSCrawlerConfigMigration.ELBRUS_ATT_NAME, FSCrawlerConfigMigration.ELBRUS_EXCLUDE_EXTENSIONS);
            xmlTagger.writeAttr(FSCrawlerConfigMigration.ELBRUS_ATT_TYPE, FSCrawlerConfigMigration.VALUE_LIST_MULTI);
            xmlTagger.writeAttr(FSCrawlerConfigMigration.ELBRUS_ATT_CRAWLSPACE_PARAM, FSCrawlerConfigMigration.VALUE_TRUE);
            xmlTagger.writeAttr(FSCrawlerConfigMigration.ELBRUS_ATT_OPTIONS, FSCrawlerConfigMigration.ELBRUS_ATT_OPTIONS_NO_FORCE);
            xmlTagger.closeTag();
            for (String ext : EXTENSTIONS) {
                xmlTagger.openStartElement(FSCrawlerConfigMigration.ELBRUS_ELEM_ITEM);
                xmlTagger.writeAttr(FSCrawlerConfigMigration.ELBRUS_ATT_ENABLE, FSCrawlerConfigMigration.VALUE_TRUE);
                xmlTagger.closeTag();
                xmlTagger.writeText(ext);
                xmlTagger.endElement(FSCrawlerConfigMigration.ELBRUS_ELEM_ITEM);
            }
            xmlTagger.endElement(FSCrawlerConfigMigration.ELBRUS_ELEM_PROPERTY);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class Entry {
            private String name;
            private Entry parent;
            private List<Entry> children = new ArrayList<Entry>();
            private String[] excludedPattern;
            private boolean isCrawlSpace = false;

            public Entry(String name, Entry parent, boolean isCrawlSpace) {
                this.name = name;
                this.parent = parent;
                this.isCrawlSpace = isCrawlSpace;
            }

            public boolean isCrawlSpace() {
                return this.isCrawlSpace;
            }

            public void setCrawlSpace() {
                this.isCrawlSpace = true;
            }

            public void setExcludedPattern(String[] excludedPattern) {
                this.excludedPattern = excludedPattern;
            }

            public String getName() {
                return this.name;
            }

            public List<Entry> getChildren() {
                return this.children;
            }

            public Entry getChild(String path) {
                for (Entry child : this.children) {
                    if (!child.getPath().equals(path)) continue;
                    return child;
                }
                return null;
            }

            public void addChild(Entry child) {
                this.children.add(child);
            }

            public Entry getParent() {
                return this.parent;
            }

            public String[] getExcludedPattern() {
                return this.excludedPattern;
            }

            public String getPath() {
                StringBuilder str = new StringBuilder();
                for (Entry root = this.getParent(); root != null; root = root.getParent()) {
                    String rootName = root.getName();
                    if (rootName == null) continue;
                    str.insert(0, rootName + SEPARATOR);
                }
                str.append(this.name);
                return str.toString();
            }

            public int level() {
                int i = 0;
                Entry root = this.getParent();
                while (root != null) {
                    root = root.getParent();
                    ++i;
                }
                return i;
            }

            public String toString() {
                StringBuilder str = new StringBuilder();
                for (int i = 0; i < this.level(); ++i) {
                    str.append(" ");
                }
                str.append("+");
                str.append(this.name == null ? "[root]" : this.name);
                str.append("[" + this.getPath() + "]");
                if (this.excludedPattern != null) {
                    str.append("(");
                    for (String ep : this.excludedPattern) {
                        str.append(ep);
                        str.append(",");
                    }
                    str.append(")");
                }
                for (Entry child : this.children) {
                    str.append("\n");
                    str.append(child);
                }
                return str.toString();
            }
        }

        private static class EntryTree {
            private Map<String, String[]> originalTargetmap = new HashMap<String, String[]>();
            private Entry root;
            private Map<String, Boolean> tops = new HashMap<String, Boolean>();

            private EntryTree() {
            }

            public void addOriginalTarget(String path, String[] excludedPattern) {
                if (!path.endsWith(SEPARATOR)) {
                    path = path + SEPARATOR;
                }
                String top = path.substring(0, path.indexOf(SEPARATOR));
                boolean isCrawlSpace = false;
                if (path.substring(path.indexOf(SEPARATOR), path.length()).equals(SEPARATOR)) {
                    isCrawlSpace = true;
                }
                if (isCrawlSpace) {
                    if (this.tops.containsKey(top)) {
                        this.tops.put(top, isCrawlSpace);
                    }
                } else if (!this.tops.containsKey(top)) {
                    this.tops.put(top, isCrawlSpace);
                }
                this.originalTargetmap.put(path, excludedPattern);
            }

            public Entry getRoot() {
                this.createTree();
                return this.root;
            }

            private void createTree() {
                this.root = new Entry(null, null, false);
                for (String path : this.tops.keySet()) {
                    Boolean isCrawleSpace = this.tops.get(path);
                    this.root.addChild(new Entry(path, this.root, isCrawleSpace));
                }
                for (String path : this.originalTargetmap.keySet()) {
                    String[] tokens = path.split(SEPARATOR.equals("\\") ? "\\" + SEPARATOR : SEPARATOR);
                    this.traverse(this.root, tokens, this.originalTargetmap.get(path));
                }
            }

            private void traverse(Entry parent, String[] tokens, String[] excludedPattern) {
                String targetEntry = tokens[0];
                if (1 < tokens.length) {
                    ArrayList<String> tokenList = new ArrayList<String>();
                    for (int i = 1; i < tokens.length; ++i) {
                        tokenList.add(tokens[i]);
                    }
                    Iterator<Entry> childrenItr = parent.getChildren().iterator();
                    Entry en = null;
                    boolean isExist = false;
                    while (childrenItr.hasNext()) {
                        en = childrenItr.next();
                        if (!en.getName().equals(targetEntry)) continue;
                        isExist = true;
                        this.traverse(en, tokenList.toArray(new String[tokenList.size()]), excludedPattern);
                    }
                    if (!isExist) {
                        Entry newEntry = new Entry(targetEntry, parent, false);
                        parent.addChild(newEntry);
                        this.traverse(newEntry, tokenList.toArray(new String[tokenList.size()]), excludedPattern);
                    }
                } else if (!this.tops.keySet().contains(targetEntry)) {
                    Entry newEntry = new Entry(targetEntry, parent, true);
                    newEntry.setExcludedPattern(excludedPattern);
                    Entry oldEntry = parent.getChild(newEntry.getPath());
                    if (oldEntry != null) {
                        oldEntry.setCrawlSpace();
                        oldEntry.setExcludedPattern(excludedPattern);
                    } else {
                        parent.addChild(newEntry);
                    }
                }
            }
        }
    }
}

