/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.util.migration;

import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.crawler.admin.CrawlerConfigurationException;
import com.ibm.es.nuvo.crawler.admin.SpaceConfiguration;
import com.ibm.es.nuvo.crawler.runtime.QueueWriter;
import com.ibm.es.nuvo.documentqueue.DocumentQueueInsertException;
import com.ibm.es.nuvo.util.FileUtils;
import java.io.File;
import java.util.Iterator;

public class CrawlerMigrationUtil {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String R1_CRAWLSPACE = "Default_file_cs";
    private static final String MIGRATED_SPACE_PREFIX = "mig_";
    private static final String FILE_TYPE = "com.ibm.es.nuvo.crawler.adapter.file";
    private static final String COL_ID = "Default";
    private final String collectionLocation;
    private static final String CDSR_DIRECTORY = "cloudscape_file";
    private boolean isAlreadyDropped = false;
    private int numOfCrawlSpace = 0;
    private int calledCount = 0;
    private static CrawlerMigrationUtil instance;

    private CrawlerMigrationUtil(SpaceConfiguration crawlerConfiguration) throws CrawlerConfigurationException {
        String collectionPath = CollectionConfiguration.buildCollectionPath(COL_ID);
        this.collectionLocation = collectionPath + File.separator + CDSR_DIRECTORY;
        this.countCrawlSpace(crawlerConfiguration.getCrawler());
    }

    private static synchronized CrawlerMigrationUtil getInstance(SpaceConfiguration crawlerConfiguration) throws CrawlerConfigurationException {
        if (instance == null) {
            instance = new CrawlerMigrationUtil(crawlerConfiguration);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void dropR1CrawlSpace(SpaceConfiguration spaceConfiguration, String spaceId, QueueWriter writer) throws DocumentQueueInsertException, CrawlerConfigurationException {
        String type;
        if (spaceId.startsWith(MIGRATED_SPACE_PREFIX) && (type = spaceConfiguration.getCrawler().getType().getName()).equals(FILE_TYPE)) {
            CrawlerMigrationUtil utilInstance;
            CrawlerMigrationUtil crawlerMigrationUtil = utilInstance = CrawlerMigrationUtil.getInstance(spaceConfiguration);
            synchronized (crawlerMigrationUtil) {
                if (!utilInstance.isAlreadyDropped) {
                    ++utilInstance.calledCount;
                    if (utilInstance.calledCount == utilInstance.numOfCrawlSpace) {
                        writer.removeByCrawlSpace(R1_CRAWLSPACE);
                        CrawlerMigrationUtil.removeClowdscapeDir(utilInstance.collectionLocation);
                        utilInstance.isAlreadyDropped = true;
                    }
                }
            }
        }
    }

    private static void removeClowdscapeDir(String cdsrLocation) {
        File dir = new File(cdsrLocation);
        try {
            FileUtils.cleanDirectory(dir);
            FileUtils.deleteFile(dir.getCanonicalPath());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void countCrawlSpace(SpaceConfiguration crawlerConfiguration) throws CrawlerConfigurationException {
        Iterator<SpaceConfiguration> itr = crawlerConfiguration.getSubSpaces();
        while (itr.hasNext()) {
            SpaceConfiguration subSpace = itr.next();
            if (subSpace.isSetAsCrawlSpace() && subSpace.getID().startsWith(MIGRATED_SPACE_PREFIX)) {
                ++this.numOfCrawlSpace;
                continue;
            }
            this.countCrawlSpace(subSpace);
        }
    }
}

