/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.util.loader;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtClassLoader
extends URLClassLoader {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private List<URI> paths = new ArrayList<URI>();

    public ExtClassLoader(String path) {
        this(path, Thread.currentThread().getContextClassLoader());
    }

    public ExtClassLoader(String path, ClassLoader parent) {
        super(new URL[0], parent);
        if (path != null) {
            this.addClasspath(path);
        }
    }

    private void addURI(URI uri) {
        if (!this.paths.contains(uri)) {
            try {
                URL url = uri.toURL();
                this.paths.add(uri);
                super.addURL(url);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void addClasspath(String classpath) {
        StringTokenizer tokens = new StringTokenizer(classpath, File.pathSeparator);
        while (tokens.hasMoreTokens()) {
            String[] files;
            File file = new File(tokens.nextToken());
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            try {
                URI uri = file.toURI();
                if (!this.paths.contains(uri)) {
                    this.addURI(uri);
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            if (!file.isDirectory() || (files = file.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name != null && (name.endsWith(".jar") || name.endsWith(".zip"));
                }
            })) == null) continue;
            for (int i = 0; i < files.length; ++i) {
                File f = new File(file, files[i]);
                try {
                    this.addURI(f.toURI());
                    continue;
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = super.findClass(name);
        return clazz;
    }

    @Override
    protected String findLibrary(String libname) {
        final String mappedLibName = System.mapLibraryName(libname);
        try {
            String libPath = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() {
                    for (URI uri : ExtClassLoader.this.paths) {
                        File libFile;
                        File file = new File(uri);
                        if (!file.isDirectory() || !(libFile = new File(file, mappedLibName)).exists()) continue;
                        return libFile.getPath();
                    }
                    return null;
                }
            });
            return libPath;
        }
        catch (PrivilegedActionException privilegedActionException) {
            return null;
        }
    }
}

