/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.util.io;

import com.ibm.es.nuvo.crawler.util.io.ConvertedInputStream;
import com.ibm.es.nuvo.crawler.util.io.OutputConverter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamConverter
implements OutputConverter {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private final InputStream in;
    private final byte[] buffer;
    private final Plugin plugin;
    private OutputStream out;

    public StreamConverter(InputStream in, Plugin plugin, int bufferSize) throws IOException {
        this.in = in;
        this.buffer = new byte[bufferSize];
        this.plugin = plugin;
    }

    public StreamConverter(InputStream in, Plugin plugin) throws IOException {
        this(in, plugin, 4096);
    }

    public StreamConverter(InputStream in) throws IOException {
        this(in, null, 4096);
    }

    public void connect(OutputStream output) throws IOException {
        if (this.out != null) {
            throw new IOException();
        }
        this.out = this.plugin != null ? this.plugin.createOutputStream(output) : output;
    }

    public void convert() throws IOException {
        if (this.out == null) {
            throw new IOException();
        }
        int len = this.in.read(this.buffer, 0, this.buffer.length);
        if (len < 0) {
            this.out.close();
            this.out = null;
        } else {
            this.out.write(this.buffer, 0, len);
        }
    }

    public void disconnect() throws IOException {
        this.in.close();
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: StreamConverter <filename>");
        }
        File file = new File(args[0]);
        File outputFile = new File("copy_of_" + file.getName());
        FileInputStream in = new FileInputStream(file);
        Plugin plugin = new Plugin(){

            public OutputStream createOutputStream(OutputStream out) throws IOException {
                return new BufferedOutputStream(out, 1024);
            }
        };
        ConvertedInputStream converted = new ConvertedInputStream(new StreamConverter(in, plugin));
        FileOutputStream output = new FileOutputStream(outputFile);
        byte[] buf = new byte[4096];
        int len = 0;
        while ((len = ((InputStream)converted).read(buf, 0, buf.length)) != -1) {
            ((OutputStream)output).write(buf, 0, len);
        }
        ((OutputStream)output).close();
        ((InputStream)converted).close();
        System.out.println("output file " + outputFile.getName());
    }

    public static interface Plugin {
        public OutputStream createOutputStream(OutputStream var1) throws IOException;
    }
}

