/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.util.io;

import com.ibm.es.nuvo.crawler.util.io.ConvertedInputStream;
import com.ibm.es.nuvo.crawler.util.io.OutputConverter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;

public class ReaderConverter
implements OutputConverter {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private final Reader reader;
    private final Plugin plugin;
    private final char[] buffer;
    private Writer writer;

    public ReaderConverter(Reader reader, Plugin plugin, int bufferSize) {
        this.reader = reader;
        this.plugin = plugin;
        this.buffer = new char[bufferSize];
    }

    public ReaderConverter(Reader reader, Plugin plugin) {
        this(reader, plugin, 4096);
    }

    public void connect(OutputStream out) throws IOException {
        if (this.writer != null) {
            throw new IOException();
        }
        if (this.plugin == null) {
            throw new IOException();
        }
        this.writer = this.plugin.createWriter(out);
    }

    public void convert() throws IOException {
        if (this.writer == null) {
            throw new IOException();
        }
        int len = this.reader.read(this.buffer, 0, this.buffer.length);
        if (len < 0) {
            this.writer.close();
            this.reader.close();
        } else {
            this.writer.write(this.buffer, 0, len);
        }
    }

    public void disconnect() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: ReaderConverter <filename>");
        }
        File file = new File(args[0]);
        File outputFile = new File("copy_of_" + file.getName());
        FileReader reader = new FileReader(file);
        Plugin plugin = new Plugin(){

            public Writer createWriter(OutputStream out) throws IOException {
                return new OutputStreamWriter(out, "UTF-8");
            }
        };
        ConvertedInputStream converted = new ConvertedInputStream(new ReaderConverter(reader, plugin));
        FileOutputStream output = new FileOutputStream(outputFile);
        byte[] buf = new byte[4096];
        int len = 0;
        while ((len = ((InputStream)converted).read(buf, 0, buf.length)) != -1) {
            ((OutputStream)output).write(buf, 0, len);
        }
        ((OutputStream)output).close();
        ((InputStream)converted).close();
        System.out.println("output file " + outputFile.getName());
    }

    public static interface Plugin {
        public Writer createWriter(OutputStream var1) throws IOException;
    }
}

