/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.util.io;

import com.ibm.es.nuvo.crawler.util.io.OutputConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ConvertedInputStream
extends InputStream {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final int DEFAULT_CAPACITY = 4096;
    private final OutputConverter converter;
    private Sink sink;
    private boolean eof;

    public ConvertedInputStream(OutputConverter converter, int capacity) throws IOException {
        this.converter = converter;
        this.sink = new Sink(capacity);
        this.eof = false;
        this.converter.connect(new ConverterOutputStream());
    }

    public ConvertedInputStream(OutputConverter converter) throws IOException {
        this(converter, 4096);
    }

    public int read() throws IOException {
        return this.sink.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        while (this.sink.remain() <= 0) {
            if (this.eof) {
                return -1;
            }
            this.converter.convert();
        }
        return this.sink.read(b, off, len);
    }

    public void close() throws IOException {
        this.converter.disconnect();
    }

    private void eof() {
        this.eof = true;
    }

    private void fill(int b) throws IOException {
        this.sink.write(b);
    }

    private void fill(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        this.sink.write(b, off, len);
    }

    private class ConverterOutputStream
    extends OutputStream {
        private ConverterOutputStream() {
        }

        public void write(int b) throws IOException {
            ConvertedInputStream.this.fill(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            ConvertedInputStream.this.fill(b, off, len);
        }

        public void close() throws IOException {
            ConvertedInputStream.this.eof();
        }
    }

    private static class Sink {
        private byte[] buffer;
        private int rPos;
        private int wPos;

        Sink(int initialCapacity) {
            this.buffer = new byte[initialCapacity];
            this.rPos = 0;
            this.wPos = 0;
        }

        void reset() {
            this.rPos = 0;
            this.wPos = 0;
        }

        void ensure(int required) {
            if (this.wPos + required >= this.buffer.length) {
                int capacity = this.buffer.length * 2 + required;
                byte[] temp = new byte[capacity];
                System.arraycopy(this.buffer, this.rPos, temp, 0, this.wPos - this.rPos);
                this.buffer = temp;
                this.wPos -= this.rPos;
                this.rPos = 0;
            }
        }

        int remain() {
            return this.wPos - this.rPos;
        }

        int read() throws IOException {
            byte[] b = new byte[1];
            int len = this.read(b, 0, 1);
            return len > 0 ? b[0] & 0xFF : -1;
        }

        int read(byte[] b, int off, int len) throws IOException {
            int limit = this.wPos - this.rPos > len ? len : this.wPos - this.rPos;
            System.arraycopy(this.buffer, this.rPos, b, off, limit);
            this.rPos += limit;
            return limit;
        }

        void write(int b) throws IOException {
            byte[] d = new byte[]{(byte)b};
            this.write(d, 0, 1);
        }

        void write(byte[] b, int off, int len) throws IOException {
            if (this.remain() <= 0) {
                this.reset();
            }
            this.ensure(len);
            System.arraycopy(b, off, this.buffer, this.wPos, len);
            this.wPos += len;
        }
    }
}

