/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.util.hash;

import com.ibm.es.nuvo.crawler.util.hash.HashUtil;
import com.ibm.es.nuvo.util.databuffer.DataBufferOutputStream;
import java.io.IOException;

public class HashableDataBufferOutputStream
extends DataBufferOutputStream {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private int[] hash;
    private int length;

    public HashableDataBufferOutputStream(int i) {
        super(i);
    }

    public HashableDataBufferOutputStream() {
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.length += len;
        this.hash = HashUtil.hashCode64(b, 0L, null, this.hash, off, len);
        super.write(b, off, len);
    }

    public void write(byte[] b) throws IOException {
        if (b == null) {
            return;
        }
        this.write(b, 0, b.length);
    }

    public long getHash() {
        return HashUtil.asLong(this.hash);
    }

    public int length() {
        return this.length;
    }
}

