/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.util.hash;

import com.ibm.es.nuvo.crawler.util.hash.HashSeed;
import java.io.IOException;
import java.io.InputStream;

public class HashUtil {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final int[][] s_rand = new int[][]{{103, 198, 105, 115, 81, 255, 74, 236, 41, 205, 186, 171, 242, 251, 227, 70, 124, 194, 84, 248, 27, 232, 231, 141, 118, 90, 46, 99, 51, 159, 201, 154, 102, 50, 13, 183, 49, 88, 163, 37, 93, 5, 23, 233, 94, 212, 178, 155, 180, 17, 14, 130, 116, 65, 33, 61, 220, 135, 112, 62, 161, 225, 252, 1, 126, 151, 234, 107, 150, 143, 56, 92, 42, 176, 59, 175, 60, 24, 219, 2, 26, 254, 67, 250, 170, 58, 209, 230, 148, 117, 216, 190, 97, 137, 249, 187, 168, 153, 15, 149, 177, 235, 241, 179, 239, 247, 0, 229, 202, 11, 203, 208, 72, 71, 100, 189, 31, 35, 30, 28, 123, 197, 20, 75, 121, 36, 158, 9, 172, 16, 80, 21, 111, 34, 25, 125, 245, 127, 164, 19, 181, 78, 152, 224, 77, 52, 188, 95, 119, 108, 134, 43, 85, 162, 4, 211, 54, 226, 240, 228, 79, 73, 253, 169, 8, 138, 10, 213, 68, 91, 243, 142, 76, 215, 45, 66, 6, 196, 132, 173, 222, 48, 246, 32, 133, 7, 244, 185, 195, 217, 160, 120, 218, 106, 83, 144, 87, 238, 207, 96, 210, 53, 101, 63, 98, 128, 165, 89, 140, 12, 192, 131, 47, 39, 22, 147, 184, 109, 182, 193, 199, 237, 18, 69, 57, 157, 174, 104, 122, 166, 55, 110, 3, 40, 139, 86, 145, 114, 129, 113, 206, 167, 191, 214, 146, 221, 136, 38, 156, 82, 200, 29, 44, 204, 223, 64}, {100, 85, 66, 53, 171, 51, 113, 56, 226, 207, 220, 141, 98, 43, 163, 159, 29, 170, 49, 130, 164, 250, 90, 115, 108, 73, 112, 17, 116, 176, 118, 202, 242, 117, 37, 28, 173, 8, 235, 137, 149, 77, 180, 237, 209, 227, 30, 83, 135, 25, 47, 225, 140, 156, 252, 172, 35, 105, 206, 222, 196, 234, 204, 213, 21, 154, 16, 155, 125, 46, 239, 5, 71, 230, 211, 186, 104, 177, 124, 139, 26, 27, 249, 223, 68, 133, 14, 61, 168, 0, 38, 123, 195, 13, 150, 200, 102, 48, 212, 187, 238, 253, 231, 136, 7, 107, 63, 254, 101, 121, 144, 60, 161, 57, 96, 152, 24, 110, 244, 219, 255, 19, 82, 174, 185, 183, 39, 233, 55, 11, 70, 205, 88, 59, 151, 22, 20, 248, 40, 146, 122, 64, 50, 103, 18, 203, 142, 2, 114, 69, 86, 160, 94, 167, 76, 109, 179, 91, 178, 33, 194, 197, 3, 99, 134, 1, 228, 217, 89, 199, 45, 106, 65, 78, 224, 6, 138, 188, 214, 126, 236, 143, 182, 210, 229, 132, 36, 81, 31, 245, 216, 23, 165, 218, 42, 243, 119, 190, 181, 32, 198, 157, 95, 215, 169, 93, 193, 128, 175, 145, 241, 111, 79, 84, 184, 162, 75, 247, 166, 120, 246, 201, 44, 131, 62, 153, 54, 34, 72, 232, 52, 87, 58, 158, 192, 97, 189, 10, 74, 147, 251, 191, 129, 9, 240, 127, 67, 148, 15, 4, 12, 80, 41, 92, 208, 221}, {119, 108, 34, 240, 29, 149, 36, 15, 22, 135, 71, 60, 63, 10, 215, 37, 83, 20, 225, 140, 222, 250, 13, 242, 12, 147, 148, 233, 11, 1, 251, 30, 161, 31, 46, 184, 167, 117, 244, 230, 127, 204, 210, 8, 179, 254, 174, 164, 150, 23, 42, 0, 159, 43, 154, 74, 186, 120, 102, 97, 237, 90, 38, 62, 47, 114, 196, 112, 160, 104, 123, 146, 53, 40, 213, 84, 111, 158, 77, 41, 138, 3, 14, 52, 173, 99, 151, 39, 143, 131, 224, 141, 182, 169, 235, 72, 168, 132, 190, 73, 193, 87, 48, 5, 221, 239, 157, 125, 165, 188, 166, 234, 231, 248, 156, 198, 124, 139, 27, 103, 107, 75, 243, 113, 226, 249, 98, 219, 255, 212, 26, 178, 80, 49, 78, 247, 197, 7, 195, 110, 187, 44, 54, 67, 58, 220, 61, 201, 177, 227, 228, 33, 76, 218, 130, 88, 232, 191, 100, 172, 56, 65, 163, 241, 96, 202, 2, 175, 92, 209, 145, 153, 245, 109, 59, 79, 9, 91, 236, 183, 137, 142, 4, 128, 238, 126, 118, 185, 50, 203, 57, 208, 216, 6, 122, 16, 45, 18, 129, 176, 192, 89, 105, 17, 171, 253, 229, 55, 217, 94, 116, 93, 189, 86, 81, 194, 68, 82, 51, 69, 133, 144, 214, 152, 121, 207, 200, 223, 24, 21, 181, 85, 134, 32, 64, 180, 136, 25, 199, 205, 252, 170, 162, 246, 106, 211, 70, 35, 155, 115, 19, 66, 95, 28, 101, 206}, {223, 217, 239, 73, 161, 201, 102, 65, 106, 91, 250, 120, 12, 126, 97, 245, 138, 9, 72, 155, 33, 195, 183, 63, 192, 215, 55, 134, 165, 22, 95, 149, 1, 94, 197, 66, 200, 61, 64, 45, 187, 162, 34, 69, 171, 225, 132, 139, 164, 59, 202, 100, 20, 71, 177, 220, 17, 251, 58, 214, 62, 2, 247, 123, 67, 36, 54, 229, 70, 124, 144, 176, 93, 79, 6, 101, 99, 168, 0, 254, 249, 204, 194, 244, 153, 50, 173, 76, 181, 228, 49, 96, 193, 172, 189, 213, 231, 190, 237, 35, 135, 133, 212, 127, 81, 151, 115, 87, 48, 166, 83, 117, 221, 113, 158, 29, 84, 4, 18, 242, 53, 31, 88, 196, 21, 180, 145, 42, 159, 184, 188, 199, 174, 252, 104, 85, 13, 130, 160, 238, 44, 24, 179, 191, 10, 107, 116, 40, 108, 140, 121, 14, 170, 68, 142, 125, 16, 219, 111, 167, 47, 163, 222, 253, 5, 147, 240, 203, 109, 114, 156, 143, 128, 51, 152, 46, 150, 3, 230, 32, 25, 105, 11, 75, 92, 118, 227, 243, 90, 235, 77, 98, 15, 82, 52, 19, 207, 89, 41, 233, 209, 157, 74, 7, 206, 119, 131, 205, 216, 86, 141, 232, 122, 241, 185, 210, 26, 60, 186, 218, 43, 154, 103, 255, 148, 8, 112, 30, 182, 23, 39, 208, 37, 234, 78, 211, 248, 178, 224, 198, 175, 129, 28, 246, 56, 136, 38, 236, 57, 80, 27, 110, 137, 169, 146, 226}, {193, 84, 55, 95, 72, 54, 206, 241, 99, 221, 62, 86, 209, 115, 16, 142, 226, 30, 113, 164, 139, 173, 136, 157, 189, 194, 127, 126, 23, 182, 236, 172, 81, 36, 15, 46, 98, 101, 255, 213, 156, 100, 45, 130, 239, 13, 89, 219, 57, 158, 185, 149, 181, 111, 20, 92, 31, 128, 148, 147, 184, 47, 163, 28, 208, 162, 171, 56, 251, 135, 114, 18, 37, 43, 168, 218, 154, 27, 238, 246, 58, 118, 104, 232, 123, 17, 42, 215, 203, 145, 140, 253, 29, 159, 34, 71, 252, 227, 235, 217, 63, 80, 4, 39, 169, 186, 41, 231, 0, 176, 178, 65, 40, 205, 38, 60, 108, 132, 179, 69, 103, 21, 48, 177, 150, 180, 244, 249, 141, 234, 216, 105, 151, 237, 153, 8, 9, 214, 230, 196, 121, 131, 144, 64, 94, 24, 245, 6, 165, 190, 2, 50, 112, 233, 124, 225, 224, 85, 198, 91, 106, 201, 229, 146, 119, 83, 87, 107, 152, 12, 96, 1, 53, 26, 170, 202, 70, 10, 93, 74, 211, 73, 33, 116, 199, 117, 35, 133, 76, 61, 5, 32, 248, 79, 161, 51, 11, 167, 66, 243, 160, 3, 82, 7, 25, 242, 250, 90, 240, 120, 49, 75, 88, 247, 67, 166, 175, 138, 188, 68, 14, 192, 52, 143, 197, 228, 207, 19, 122, 222, 137, 187, 200, 210, 155, 134, 110, 129, 220, 78, 204, 254, 125, 97, 109, 174, 195, 212, 191, 59, 102, 223, 44, 183, 77, 22}, {56, 49, 128, 149, 241, 131, 221, 62, 209, 238, 28, 9, 195, 30, 121, 224, 192, 50, 251, 230, 91, 253, 133, 5, 150, 112, 154, 8, 152, 176, 64, 201, 232, 94, 218, 67, 60, 24, 20, 42, 52, 237, 83, 151, 205, 19, 200, 249, 37, 198, 126, 92, 196, 100, 134, 116, 164, 80, 93, 174, 55, 168, 234, 79, 188, 132, 2, 215, 114, 207, 59, 227, 96, 97, 139, 186, 31, 214, 38, 33, 40, 213, 88, 208, 191, 167, 140, 212, 43, 103, 217, 165, 236, 61, 117, 155, 0, 86, 129, 87, 48, 18, 189, 95, 36, 98, 78, 17, 159, 145, 6, 39, 233, 248, 170, 11, 222, 160, 173, 16, 175, 12, 69, 204, 123, 162, 169, 84, 46, 252, 187, 107, 25, 171, 255, 216, 29, 193, 146, 66, 229, 23, 144, 203, 71, 75, 184, 183, 182, 199, 90, 210, 197, 57, 58, 163, 177, 81, 166, 143, 7, 41, 109, 226, 153, 54, 104, 53, 179, 14, 32, 70, 245, 108, 119, 243, 72, 82, 178, 228, 125, 185, 130, 22, 190, 120, 157, 73, 21, 65, 231, 194, 239, 111, 99, 181, 124, 122, 115, 246, 47, 10, 26, 74, 68, 51, 211, 15, 161, 206, 223, 250, 242, 158, 172, 77, 106, 34, 137, 110, 225, 85, 147, 247, 138, 254, 35, 76, 135, 4, 148, 180, 44, 136, 13, 113, 118, 142, 45, 141, 202, 127, 219, 156, 101, 102, 105, 240, 235, 220, 89, 63, 3, 244, 1, 27}, {93, 187, 88, 252, 96, 219, 174, 42, 232, 3, 202, 6, 59, 243, 203, 100, 91, 8, 222, 64, 137, 181, 56, 34, 81, 200, 201, 214, 5, 192, 241, 99, 123, 74, 95, 37, 13, 17, 208, 19, 76, 195, 177, 31, 230, 143, 111, 68, 151, 145, 150, 108, 101, 27, 167, 40, 113, 204, 53, 119, 217, 70, 72, 236, 147, 11, 211, 32, 23, 33, 178, 173, 129, 25, 175, 190, 30, 215, 47, 235, 12, 196, 83, 239, 250, 44, 253, 77, 20, 207, 255, 194, 80, 55, 52, 82, 242, 189, 92, 28, 183, 209, 2, 121, 41, 133, 198, 62, 85, 197, 0, 165, 220, 46, 247, 159, 127, 251, 73, 225, 153, 237, 104, 75, 58, 148, 179, 122, 63, 162, 126, 22, 65, 14, 164, 39, 9, 161, 168, 226, 107, 149, 182, 15, 79, 84, 249, 118, 254, 132, 163, 212, 171, 66, 180, 36, 135, 29, 185, 224, 244, 154, 130, 221, 54, 218, 139, 128, 24, 205, 7, 48, 136, 1, 60, 227, 45, 131, 184, 120, 16, 49, 152, 172, 142, 38, 116, 141, 210, 87, 86, 231, 158, 43, 144, 69, 97, 102, 90, 248, 71, 156, 233, 103, 193, 67, 246, 138, 140, 134, 199, 169, 18, 21, 117, 125, 157, 223, 186, 155, 124, 26, 115, 213, 4, 188, 57, 234, 110, 146, 112, 166, 216, 94, 206, 109, 114, 50, 240, 106, 35, 160, 78, 245, 170, 191, 89, 229, 228, 51, 98, 105, 61, 10, 238, 176}, {23, 43, 0, 206, 135, 232, 239, 148, 222, 37, 182, 156, 176, 198, 200, 227, 106, 168, 229, 188, 254, 242, 253, 224, 14, 124, 48, 137, 177, 160, 220, 225, 110, 99, 201, 93, 247, 167, 241, 28, 142, 205, 36, 86, 149, 75, 252, 72, 221, 196, 13, 30, 117, 238, 190, 82, 207, 44, 181, 152, 173, 63, 123, 9, 150, 192, 95, 70, 79, 154, 90, 226, 55, 249, 166, 68, 27, 50, 214, 109, 1, 2, 35, 153, 140, 208, 216, 7, 16, 53, 111, 118, 132, 204, 38, 175, 162, 194, 212, 47, 159, 34, 189, 66, 236, 98, 119, 125, 164, 107, 26, 60, 163, 120, 46, 78, 128, 71, 5, 121, 187, 108, 233, 193, 141, 87, 143, 231, 146, 170, 69, 248, 97, 65, 228, 33, 67, 126, 51, 59, 49, 158, 32, 191, 83, 12, 96, 217, 105, 138, 199, 19, 102, 85, 174, 144, 165, 223, 197, 61, 237, 73, 8, 104, 41, 42, 130, 131, 40, 15, 116, 213, 92, 91, 240, 245, 20, 39, 218, 185, 235, 203, 25, 54, 129, 211, 171, 183, 76, 103, 246, 234, 250, 112, 230, 84, 31, 180, 184, 22, 24, 21, 94, 255, 88, 115, 157, 169, 172, 133, 243, 11, 52, 215, 195, 251, 56, 179, 145, 139, 114, 80, 64, 89, 81, 210, 4, 17, 57, 155, 151, 100, 101, 127, 3, 134, 62, 18, 209, 244, 202, 136, 219, 113, 122, 161, 147, 178, 29, 186, 58, 10, 74, 45, 6, 77}};

    public static long hashCode64(String str) {
        return HashUtil.hashCode64(str, 0L);
    }

    public static long hashCode64(String str, long seed) {
        if (str == null) {
            str = "";
        }
        return HashUtil.hashCode64(str.getBytes(), seed);
    }

    public static long hashCode64(byte[] key, long seed) {
        return HashUtil.hashCode64(key, seed, s_rand);
    }

    public static long hashCode64(byte[] key, long seed, int[][] rand) {
        if (key == null) {
            return 0L;
        }
        int[] result = HashUtil.hashCode64(key, seed, rand, null, 0, key.length);
        long rv = HashUtil.asLong(result);
        return rv;
    }

    public static long asLong(int[] result) {
        if (result == null || result.length != 8) {
            return 0L;
        }
        long rv = 0L;
        for (int j = 0; j < 8; ++j) {
            rv |= (long)result[j] << j * 8;
        }
        return rv;
    }

    public static int[] hashCode64(char c, long seed, int[][] rand, int[] result) {
        byte[] bs = ("" + c).getBytes();
        return HashUtil.hashCode64(bs, seed, rand, result, 0, bs.length);
    }

    static int[] hashCode64(byte[] key, long seed, int[][] rand, int[] result, int offset, int length) {
        int[] ret;
        if (key == null || length == 0 || key.length < length + offset) {
            return result;
        }
        if (rand == null) {
            rand = s_rand;
        }
        if (result == null) {
            ret = new int[8];
            for (int j = 0; j < 8; ++j) {
                ret[j] = (int)((seed & 255L << j * 8) >>> j * 8);
            }
        } else {
            ret = result;
        }
        for (int k = 0; k < 8; ++k) {
            for (int j = 0; j < length; ++j) {
                ret[k] = rand[k][ret[k] ^ key[j + offset] & 0xFF];
            }
        }
        return ret;
    }

    public static long hashCode64(InputStream is, long seed) throws IOException {
        int len;
        int[] result = new int[8];
        for (int j = 0; j < 8; ++j) {
            result[j] = (int)((seed & 255L << j * 8) >>> j * 8);
        }
        byte[] buffer = new byte[32768];
        int total = 0;
        while ((len = is.read(buffer)) > 0) {
            total += len;
            for (int j = 0; j < len; ++j) {
                for (int k = 0; k < 8; ++k) {
                    result[k] = s_rand[k][result[k] ^ buffer[j] & 0xFF];
                }
            }
        }
        long rv = HashUtil.asLong(result);
        return rv;
    }

    public static long[] hashCode64(InputStream is, HashSeed[] seed) throws IOException {
        int len;
        int j;
        int i;
        int numSeeds = seed.length;
        int[][] results = new int[numSeeds][];
        for (i = 0; i < numSeeds; ++i) {
            int[] result = new int[8];
            for (j = 0; j < 8; ++j) {
                result[j] = (int)((seed[i].getSeed() & 255L << j * 8) >>> j * 8);
            }
            results[i] = result;
        }
        byte[] buffer = new byte[32768];
        while ((len = is.read(buffer)) > 0) {
            for (i = 0; i < numSeeds; ++i) {
                int[] result = results[i];
                int[][] rand = seed[i].getRand();
                for (j = 0; j < len; ++j) {
                    for (int k = 0; k < 8; ++k) {
                        result[k] = rand[k][result[k] ^ buffer[j] & 0xFF];
                    }
                }
            }
        }
        long[] ret = new long[numSeeds];
        for (i = 0; i < numSeeds; ++i) {
            int[] result = results[i];
            long rv = 0L;
            for (j = 0; j < 8; ++j) {
                rv |= (long)result[j] << j * 8;
            }
            ret[i] = rv;
        }
        return ret;
    }
}

