/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.util.hash;

import com.ibm.es.nuvo.crawler.util.hash.HashUtil;
import com.ibm.es.nuvo.crawler.web.configuration.PublishableConfig;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hash64 {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private long m_hash64;

    public Hash64(String str) {
        this.m_hash64 = HashUtil.hashCode64(str);
    }

    public Hash64(long hashValue) {
        this.m_hash64 = hashValue;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        try {
            Hash64 other = (Hash64)o;
            return other.m_hash64 == this.m_hash64;
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public int hashCode() {
        return (int)this.m_hash64;
    }

    public long longValue() {
        return this.m_hash64;
    }

    public String toString() {
        return "" + this.m_hash64;
    }

    public static long xorHash(PublishableConfig.HashType type, List<PublishableConfig> confs) {
        if (confs == null) {
            return 0L;
        }
        return Hash64.xorHash(type, confs.toArray(new PublishableConfig[confs.size()]));
    }

    public static long xorHash(PublishableConfig.HashType type, PublishableConfig[] confs) {
        long ret = 0L;
        for (PublishableConfig config : confs) {
            long hash = config.getHash(type);
            if (hash == 0L) continue;
            ret ^= hash;
        }
        return ret;
    }
}

