/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.util.fenced.net;

public class UNCPath {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private String serverName;
    private String folderName;
    private static final String SERVER_PREFIX = "\\\\";
    private static final String PATH_PREFIX = "\\";

    public UNCPath() throws IllegalArgumentException {
        this(null, null);
    }

    public UNCPath(String unc) throws IllegalArgumentException {
        this.setNames(unc);
    }

    public UNCPath(String svr, String fd) throws IllegalArgumentException {
        this.setNames(svr, fd);
    }

    private void setNames(String unc) throws IllegalArgumentException {
        if (unc == null) {
            this.setNames(null, null);
        } else {
            int i = unc.indexOf(SERVER_PREFIX);
            if (i != 0) {
                throw new IllegalArgumentException("The URL not started with \\\\");
            }
            int j = unc.indexOf(PATH_PREFIX, SERVER_PREFIX.length());
            if (j < 0) {
                throw new IllegalArgumentException("The Shared Folder name is not correct.");
            }
            int k = unc.indexOf(PATH_PREFIX, j + PATH_PREFIX.length());
            String svrName = unc.substring(SERVER_PREFIX.length(), j);
            String pathName = k > 0 ? unc.substring(j + PATH_PREFIX.length(), k) : unc.substring(j + PATH_PREFIX.length());
            this.setNames(svrName, pathName);
        }
    }

    public String getNormalizedFolder() {
        StringBuffer sb = new StringBuffer();
        sb.append(SERVER_PREFIX).append(this.getServerName()).append(PATH_PREFIX).append(this.getFolderName());
        return new String(sb);
    }

    private void setNames(String svr, String fd) {
        this.setServerName(svr);
        this.setFolderName(fd);
    }

    public String getFolderName() {
        return this.folderName;
    }

    public void setFolderName(String fn) {
        this.folderName = fn;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String sn) {
        this.serverName = sn;
    }
}

