/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.util.fenced.net;

import com.ibm.es.nuvo.crawler.util.fenced.WinSecurityProcess;
import com.ibm.es.nuvo.crawler.util.fenced.WinSecurityProcessException;
import com.ibm.es.nuvo.crawler.util.fenced.net.NetConnectionException;
import com.ibm.es.nuvo.crawler.util.fenced.net.UNCPath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class BaseNetConnectionManager {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private HashMap<String, NetUserInfo> serverMap = new HashMap();
    private static BaseNetConnectionManager thisManager;

    public static synchronized BaseNetConnectionManager getInstance() {
        if (thisManager == null) {
            thisManager = new BaseNetConnectionManager();
        }
        return thisManager;
    }

    private BaseNetConnectionManager() {
    }

    public synchronized void connect(String path, String u, String pw) throws NetConnectionException {
        UNCPath upath = new UNCPath(path);
        String svrName = upath.getServerName().toLowerCase();
        String fldName = upath.getFolderName().toLowerCase();
        NetUserInfo info = this.serverMap.get(svrName);
        if (info == null) {
            NetUserInfo newInfo = new NetUserInfo(u, pw, svrName);
            this.doConnect(upath.getNormalizedFolder(), u, pw);
            newInfo.addFolder(fldName);
        } else if (info.getUser().equalsIgnoreCase(svrName)) {
            info.addFolder(fldName);
        }
    }

    public synchronized void disconnect(String path) throws NetConnectionException {
        UNCPath upath = new UNCPath(path);
        String svrName = upath.getServerName().toLowerCase();
        String fldName = upath.getFolderName().toLowerCase();
        NetUserInfo info = this.serverMap.get(svrName);
        if (info == null) {
            this.doDisconnect(upath.getNormalizedFolder());
        } else if (info.getUser().equalsIgnoreCase(svrName)) {
            this.doDisconnect(upath.getNormalizedFolder());
            info.removeFolder(fldName);
            if (info.isEmpty()) {
                this.serverMap.remove(svrName);
            }
        }
    }

    public synchronized void changeUidPassword(String path, String u, String pw) {
        try {
            UNCPath upath = new UNCPath(path);
            String svrName = upath.getServerName().toLowerCase();
            NetUserInfo info = this.serverMap.get(svrName);
            if (info != null && info.getUser().equalsIgnoreCase(u) && info.getServername().equalsIgnoreCase(svrName)) {
                info.setUser(u);
                info.setPassword(pw);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    public synchronized String[] getListOfShareFolders() {
        ArrayList<String> list = new ArrayList<String>();
        for (NetUserInfo netInfo : this.serverMap.values()) {
            for (String folder : netInfo.getFolders()) {
                list.add(folder);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    private void doConnect(String filepath, String user, String passwd) throws NetConnectionException {
        WinSecurityProcess process = null;
        try {
            process = new WinSecurityProcess();
            process.init(null);
            process.startProcess();
            process.netConnection(user, passwd, filepath);
        }
        catch (WinSecurityProcessException e) {
            throw new NetConnectionException(e);
        }
        finally {
            try {
                if (process != null) {
                    process.term();
                }
            }
            catch (WinSecurityProcessException iwspe) {}
        }
    }

    private void doDisconnect(String filepath) throws NetConnectionException {
        WinSecurityProcess process = null;
        try {
            process = new WinSecurityProcess();
            process.init(null);
            process.startProcess();
            process.netDisconnect(filepath);
        }
        catch (WinSecurityProcessException e) {
            throw new NetConnectionException(e);
        }
        finally {
            try {
                if (process != null) {
                    process.term();
                }
            }
            catch (WinSecurityProcessException iwspe) {}
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NetUserInfo {
        private String user;
        private String password;
        private String servername;
        private HashSet<String> folders;

        public NetUserInfo(String u, String p, String svr) {
            this.setUser(u);
            this.setPassword(p);
            this.setServername(svr);
            this.folders = new HashSet();
        }

        public void addFolder(String folder) {
            this.folders.add(folder);
        }

        public void removeFolder(String folder) {
            this.folders.remove(folder);
        }

        public boolean isEmpty() {
            return this.folders.isEmpty();
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String pw) {
            this.password = pw;
        }

        public String getServername() {
            return this.servername;
        }

        public void setServername(String server) {
            this.servername = server;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String u) {
            this.user = u;
        }

        public HashSet<String> getFolders() {
            return this.folders;
        }
    }
}

