/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.util.fenced.communication;

import com.ibm.es.nuvo.crawler.util.fenced.communication.BodyParameter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MessageBlock {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final int RETCODE_TRUE = 1;
    public static final int RETCODE_FALSE = 0;
    public static final int RETCODE_FATAL = -1;
    public static final int MESSAGE_TYPE_UNKNOWN = 0;
    public static final int MESSAGE_TYPE_REQUEST = 1;
    public static final int MESSAGE_TYPE_REPLY = 2;
    public static final int MESSAGE_TYPE_TERMINATE = 3;
    public static final int COMMAND_NOOPERATION = 0;
    public static final int COMMAND_USERVALIDATE = 1;
    public static final int COMMAND_GROUPEXPANTION = 2;
    public static final int COMMAND_NETCONNECTION = 3;
    public static final int COMMAND_GETACL = 4;
    public static final int COMMAND_IMPERSONAMTE = 5;
    public static final int COMMAND_ISNTFS = 6;
    public static final int COMMAND_GETPCNAME = 7;
    public static final int COMMAND_GETDOMAINAME = 8;
    public static final int COMMAND_NETDISCONNECT = 9;
    public static final int COMMAND_ISMAPPEDDRIVE = 10;
    public static final int HEADER_LENGTH = 32;
    private int messageType;
    private int command;
    private int result;
    private int bodyLength;
    private int sender;
    private int receiver;
    private ArrayList<BodyParameter> bodyList;

    public MessageBlock() {
        this.clean();
    }

    public void clean() {
        this.setMessageType(0);
        this.setCommand(0);
        this.setSender(0);
        this.setReceiver(0);
        this.bodyList = new ArrayList();
    }

    byte[] createHeaderBlock() {
        byte[] headerBlk = new byte[32];
        ByteBuffer bb = ByteBuffer.wrap(headerBlk);
        bb.order(ByteOrder.LITTLE_ENDIAN).putInt(this.getMessageType()).putInt(this.getCommand()).putInt(this.getResult()).putInt(this.getRequestBodyLength()).putInt(this.getSender()).putInt(this.getReceiver()).putInt(0).putInt(0);
        return headerBlk;
    }

    byte[] createBodyBlock() {
        byte[] msgBlk = new byte[this.getRequestBodyLength()];
        byte[] numOfParamsBlk = new byte[4];
        ByteBuffer bb = ByteBuffer.wrap(numOfParamsBlk);
        bb.order(ByteOrder.LITTLE_ENDIAN).putInt(this.bodyList.size());
        int pointer = 0;
        int length = bb.array().length;
        System.arraycopy(bb.array(), 0, msgBlk, pointer, length);
        pointer += length;
        for (int i = 0; i < this.bodyList.size(); ++i) {
            BodyParameter bp = this.bodyList.get(i);
            byte[] tmpBytes = bp.createMemoryBlock();
            System.arraycopy(tmpBytes, 0, msgBlk, pointer, tmpBytes.length);
            pointer += tmpBytes.length;
        }
        return msgBlk;
    }

    public byte[] createMemBlock() {
        int bodySize = this.getRequestBodyLength();
        byte[] msgBlk = new byte[32 + bodySize];
        System.arraycopy(this.createHeaderBlock(), 0, msgBlk, 0, 32);
        System.arraycopy(this.createBodyBlock(), 0, msgBlk, 32, bodySize);
        return msgBlk;
    }

    public void readMemoryBlock(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        int index = 0;
        this.setMessageType(bb.getInt(index));
        this.setCommand(bb.getInt(index += 4));
        this.setResult(bb.getInt(index += 4));
        this.setActualBodyLength(bb.getInt(index += 4));
        this.setSender(bb.getInt(index += 4));
        this.setReceiver(bb.getInt(index += 4));
    }

    public ArrayList<String> readAsList(byte[] bytes) throws UnsupportedEncodingException {
        ArrayList<String> retList = new ArrayList<String>();
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        int totalItems = 0;
        int index = 0;
        totalItems = bb.getInt(index);
        index += 4;
        for (int i = 0; i < totalItems; ++i) {
            int strlen = 0;
            strlen = bb.getInt(index);
            String items = new String(bytes, index += 4, strlen, "UTF-8");
            index += strlen;
            retList.add(items);
        }
        return retList;
    }

    public void addBodyString(String key, String value, String encode) throws UnsupportedEncodingException {
        if (key == null || key.length() == 0 || value == null || value.length() == 0) {
            return;
        }
        BodyParameter bp = new BodyParameter(key, value, encode);
        this.bodyLength += bp.getTotalLength();
        this.bodyList.add(bp);
    }

    public void addBodyString(String key, String value) throws UnsupportedEncodingException {
        if (key == null || key.length() == 0 || value == null || value.length() == 0) {
            return;
        }
        BodyParameter bp = new BodyParameter(key, value);
        this.bodyLength += bp.getTotalLength();
        this.bodyList.add(bp);
    }

    public int getMessageType() {
        return this.messageType;
    }

    public void setMessageType(int mt) {
        this.messageType = mt;
    }

    public int getCommand() {
        return this.command;
    }

    public void setCommand(int c) {
        this.command = c;
    }

    public int getResult() {
        return this.result;
    }

    public void setResult(int res) {
        this.result = res;
    }

    public int getReceiver() {
        return this.receiver;
    }

    public void setReceiver(int rec) {
        this.receiver = rec;
    }

    public int getSender() {
        return this.sender;
    }

    public void setSender(int sd) {
        this.sender = sd;
    }

    public int getRequestBodyLength() {
        return this.bodyLength + 4;
    }

    public int getActualBodyLength() {
        return this.bodyLength;
    }

    public void setActualBodyLength(int len) {
        this.bodyLength = len;
    }
}

