/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.util.fenced;

import com.ibm.es.nuvo.common.InvalidArgumentException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.crawler.util.fenced.AbstractFencedProcess;
import com.ibm.es.nuvo.crawler.util.fenced.UNCName;
import com.ibm.es.nuvo.crawler.util.fenced.WinSecurityProcessException;
import com.ibm.es.nuvo.crawler.util.fenced.communication.MessageBlock;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WinSecurityProcess
extends AbstractFencedProcess {
    private static final String FENCED_PARAM_USER = "user";
    private static final String FENCED_PARAM_PASSWORD = "password";
    private static final String FENCED_PARAM_DOMAIN = "domain";
    private String pcName;
    private String domainName;
    private DomainType domainType;
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String EXECUTABLE_WINDOWS = "esWinSecTask.exe";
    private final ProcessBuilder builder;
    protected BufferedInputStream dis;
    protected BufferedOutputStream dos;

    public WinSecurityProcess() throws WinSecurityProcessException {
        GlobalConfiguration config = GlobalConfiguration.getConfiguration();
        String executablePath = config.getInstallPath() + File.separator + "bin";
        String libPath = config.getInstallPath() + File.separator + "lib";
        File executablePathFile = new File(executablePath);
        File libPathFile = new File(libPath);
        File executableFile = new File(executablePathFile, EXECUTABLE_WINDOWS);
        try {
            this.builder = new ProcessBuilder(executableFile.getCanonicalPath());
        }
        catch (IOException ioe) {
            Message m = new Message("C8000E.CANNOT_START_WINSECPROCESS");
            throw new WinSecurityProcessException(m, (Throwable)ioe);
        }
        try {
            Map<String, String> environment = this.builder.environment();
            String orgPath = System.getenv("PATH");
            String paths = null;
            if (orgPath != null && orgPath.length() != 0) {
                paths = orgPath;
            }
            paths = paths + File.pathSeparator + executablePathFile.getCanonicalPath() + File.pathSeparator + libPathFile.getCanonicalPath();
            environment.put("PATH", paths);
            this.builder.directory(libPathFile);
        }
        catch (IOException ioe) {
            Message m = new Message("C8000E.CANNOT_START_WINSECPROCESS");
            throw new WinSecurityProcessException(m, (Throwable)ioe);
        }
    }

    @Override
    public void startProcess() throws WinSecurityProcessException {
        try {
            this.process = this.builder.start();
            this.dis = new BufferedInputStream(this.process.getInputStream());
            this.dos = new BufferedOutputStream(this.process.getOutputStream());
            try {
                this.process.getErrorStream().close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            try {
                int exitValue = this.process.exitValue();
                Message message = new Message("C8001E.WINSECPROCESS_HAS_BEEN_DIED");
                message.addArgument(exitValue);
                throw new WinSecurityProcessException(message);
            }
            catch (IllegalThreadStateException itse) {
            }
        }
        catch (IOException ioe) {
            throw new WinSecurityProcessException(ioe);
        }
    }

    @Override
    public void init(Properties props) throws WinSecurityProcessException {
        this.pcName = null;
        this.domainName = null;
        this.domainType = DomainType.None;
    }

    @Override
    public void term() throws WinSecurityProcessException {
        MessageBlock msg = new MessageBlock();
        msg.setMessageType(3);
        msg.setCommand(0);
        msg.setSender(4095);
        msg.setReceiver(Short.MAX_VALUE);
        try {
            byte[] blk = msg.createMemBlock();
            this.dos.write(blk, 0, blk.length);
            this.dos.flush();
            int waitTime = 0;
            if (waitTime < 10) {
                try {
                    this.process.exitValue();
                }
                catch (IllegalThreadStateException itse) {}
            }
        }
        catch (IOException ioe) {
            throw new WinSecurityProcessException(ioe);
        }
    }

    public boolean userValidation(String unc, String password) throws WinSecurityProcessException {
        if (!this.isValidComputerName(unc)) {
            return false;
        }
        boolean rc = false;
        MessageBlock msg = new MessageBlock();
        try {
            msg.setMessageType(1);
            msg.setCommand(1);
            msg.setSender(1);
            msg.setReceiver(2);
            this.setUNCParameters(msg, unc, password);
            byte[] SendBlk = msg.createMemBlock();
            this.dos.write(SendBlk, 0, SendBlk.length);
            this.dos.flush();
            byte[] recBlk = this.readBytes(32);
            MessageBlock replyMsg = new MessageBlock();
            replyMsg.readMemoryBlock(recBlk);
            int bodyLen = replyMsg.getActualBodyLength();
            rc = replyMsg.getResult() == 1;
            if (!rc && bodyLen > 0) {
                this.readBytes(bodyLen);
            }
            boolean bl = rc;
            return bl;
        }
        catch (IOException ioe) {
            throw new WinSecurityProcessException(ioe);
        }
        finally {
            try {
                int rsize;
                while ((rsize = this.dis.available()) >= 1) {
                    byte[] bytes = new byte[32];
                    rsize = this.dis.read(bytes, 0, 32);
                }
            }
            catch (IOException e) {}
        }
    }

    public ArrayList<String> getGroupList(String unc, String password, String domain) throws WinSecurityProcessException {
        if (!this.isValidComputerName(unc)) {
            Message msgObj = new Message("C4516E.FAIL_TO_VALIDATE_COMPUTERNAME");
            UNCName uncName = new UNCName(unc);
            msgObj.addArgument(uncName.getDomainName());
            msgObj.addArgument(unc);
            throw new WinSecurityProcessException(msgObj);
        }
        ArrayList<String> retList = null;
        boolean rc = false;
        MessageBlock msg = new MessageBlock();
        try {
            msg.setMessageType(1);
            msg.setCommand(2);
            msg.setSender(1);
            msg.setReceiver(2);
            this.setUNCParameters(msg, unc, password);
            byte[] SendBlk = msg.createMemBlock();
            this.dos.write(SendBlk, 0, SendBlk.length);
            this.dos.flush();
            byte[] recBlk = this.readBytes(32);
            MessageBlock replyMsg = new MessageBlock();
            replyMsg.readMemoryBlock(recBlk);
            int bodyLen = replyMsg.getActualBodyLength();
            rc = replyMsg.getResult() == 1;
            if (!rc) {
                Message msgObj = new Message("C4513E.UNEXPECTED_WIN32API_ERROR");
                if (bodyLen > 0) {
                    byte[] bodyBlk = this.readBytes(bodyLen);
                    ArrayList<String> results = replyMsg.readAsList(bodyBlk);
                    msgObj.addArgument(results.get(1));
                    msgObj.addArgument(results.get(2));
                    msgObj.addArgument(results.get(3));
                } else {
                    msgObj.addArgument("getGroupList");
                    msgObj.addArgument("None");
                    msgObj.addArgument("No cause");
                }
                throw new WinSecurityProcessException(msgObj);
            }
            byte[] bodyBlk = this.readBytes(bodyLen);
            retList = replyMsg.readAsList(bodyBlk);
            ArrayList<String> arrayList = retList;
            return arrayList;
        }
        catch (IOException ioe) {
            throw new WinSecurityProcessException(ioe);
        }
        finally {
            try {
                int rsize;
                while ((rsize = this.dis.available()) >= 1) {
                    byte[] bytes = new byte[32];
                    rsize = this.dis.read(bytes, 0, 32);
                }
            }
            catch (IOException e) {}
        }
    }

    public boolean impersonate(String unc, String password, String filepath) throws WinSecurityProcessException {
        if (!this.isValidComputerName(unc)) {
            Message msgObj = new Message("C4516E.FAIL_TO_VALIDATE_COMPUTERNAME");
            UNCName uncName = new UNCName(unc);
            msgObj.addArgument(uncName.getDomainName());
            msgObj.addArgument(unc);
            throw new WinSecurityProcessException(msgObj);
        }
        boolean rc = false;
        MessageBlock msg = new MessageBlock();
        try {
            msg.setMessageType(1);
            msg.setCommand(5);
            msg.setSender(1);
            msg.setReceiver(2);
            this.setUNCParameters(msg, unc, password);
            msg.addBodyString("filepath", filepath);
            byte[] SendBlk = msg.createMemBlock();
            this.dos.write(SendBlk, 0, SendBlk.length);
            this.dos.flush();
            byte[] recBlk = this.readBytes(32);
            MessageBlock replyMsg = new MessageBlock();
            replyMsg.readMemoryBlock(recBlk);
            int bodyLen = replyMsg.getActualBodyLength();
            rc = replyMsg.getResult() == 1;
            if (bodyLen > 0) {
                this.readBytes(bodyLen);
            }
            boolean bl = rc;
            return bl;
        }
        catch (IOException ioe) {
            throw new WinSecurityProcessException(ioe);
        }
        finally {
            try {
                int rsize;
                while ((rsize = this.dis.available()) >= 1) {
                    byte[] bytes = new byte[32];
                    rsize = this.dis.read(bytes, 0, 32);
                }
            }
            catch (IOException e) {}
        }
    }

    public boolean netConnection(String user, String password, String filepath) throws WinSecurityProcessException {
        boolean rc = false;
        MessageBlock msg = new MessageBlock();
        try {
            msg.setMessageType(1);
            msg.setCommand(3);
            msg.setSender(1);
            msg.setReceiver(2);
            msg.addBodyString(FENCED_PARAM_USER, user);
            msg.addBodyString(FENCED_PARAM_PASSWORD, password);
            msg.addBodyString("filepath", filepath);
            byte[] SendBlk = msg.createMemBlock();
            this.dos.write(SendBlk, 0, SendBlk.length);
            this.dos.flush();
            byte[] recBlk = this.readBytes(32);
            MessageBlock replyMsg = new MessageBlock();
            replyMsg.readMemoryBlock(recBlk);
            int bodyLen = replyMsg.getActualBodyLength();
            rc = replyMsg.getResult() == 1;
            if (!rc) {
                Message msgObj = new Message("C4515E.FAIL_TO_NETCONNECTION_WINDOWS");
                if (bodyLen > 0) {
                    byte[] bodyBlk = this.readBytes(bodyLen);
                    ArrayList<String> results = replyMsg.readAsList(bodyBlk);
                    msgObj.addArgument(results.get(1));
                    msgObj.addArgument(results.get(2));
                    msgObj.addArgument(results.get(3));
                } else {
                    msgObj.addArgument("netConnection");
                    msgObj.addArgument("None");
                    msgObj.addArgument("No cause");
                }
                throw new WinSecurityProcessException(msgObj);
            }
            boolean bl = rc;
            return bl;
        }
        catch (IOException ioe) {
            throw new WinSecurityProcessException(ioe);
        }
        finally {
            try {
                int rsize;
                while ((rsize = this.dis.available()) >= 1) {
                    byte[] bytes = new byte[32];
                    rsize = this.dis.read(bytes, 0, 32);
                }
            }
            catch (IOException e) {}
        }
    }

    public ArrayList<String> getACL(String filepath) throws WinSecurityProcessException {
        ArrayList<String> retList = null;
        boolean rc = false;
        MessageBlock msg = new MessageBlock();
        try {
            msg.setMessageType(1);
            msg.setCommand(4);
            msg.setSender(1);
            msg.setReceiver(2);
            msg.addBodyString("filepath", filepath);
            byte[] SendBlk = msg.createMemBlock();
            this.dos.write(SendBlk, 0, SendBlk.length);
            this.dos.flush();
            byte[] recBlk = this.readBytes(32);
            MessageBlock replyMsg = new MessageBlock();
            replyMsg.readMemoryBlock(recBlk);
            int bodyLen = replyMsg.getActualBodyLength();
            rc = replyMsg.getResult() == 1;
            if (!rc) {
                ArrayList<String> results = null;
                Message msgObj = new Message("C4513E.UNEXPECTED_WIN32API_ERROR");
                WinSecurityProcessException wspe = null;
                if (bodyLen > 0) {
                    byte[] bodyBlk = this.readBytes(bodyLen);
                    results = replyMsg.readAsList(bodyBlk);
                    msgObj.addArgument(results.get(1));
                    msgObj.addArgument(results.get(2));
                    msgObj.addArgument(results.get(3));
                    wspe = new WinSecurityProcessException(msgObj);
                    wspe.setErrorMessage(results);
                } else {
                    msgObj.addArgument("getACL");
                    msgObj.addArgument("None");
                    msgObj.addArgument("No cause");
                    wspe = new WinSecurityProcessException(msgObj);
                    wspe.setErrorMessage("getACL", "None", "None", "No cause");
                }
                throw wspe;
            }
            byte[] bodyBlk = this.readBytes(bodyLen);
            retList = replyMsg.readAsList(bodyBlk);
            ArrayList<String> arrayList = retList;
            return arrayList;
        }
        catch (IOException ioe) {
            throw new WinSecurityProcessException(ioe);
        }
        finally {
            try {
                int rsize;
                while ((rsize = this.dis.available()) >= 1) {
                    byte[] bytes = new byte[32];
                    rsize = this.dis.read(bytes, 0, 32);
                }
            }
            catch (IOException e) {}
        }
    }

    public boolean isNTFS(String orgFilePath) throws WinSecurityProcessException {
        String filePath = null;
        if (orgFilePath == null || orgFilePath.length() == 0) {
            return false;
        }
        if (orgFilePath.startsWith("\\\\")) {
            int index = orgFilePath.indexOf("\\", 2);
            if (index == -1) {
                return false;
            }
            int index2 = orgFilePath.indexOf("\\", index + 1);
            if (index2 == -1) {
                return false;
            }
            filePath = orgFilePath.substring(0, index2);
        } else {
            filePath = orgFilePath.substring(0, 3);
        }
        boolean rc = false;
        MessageBlock msg = new MessageBlock();
        try {
            msg.setMessageType(1);
            msg.setCommand(6);
            msg.setSender(1);
            msg.setReceiver(2);
            msg.addBodyString("filepath", filePath);
            byte[] SendBlk = msg.createMemBlock();
            this.dos.write(SendBlk, 0, SendBlk.length);
            this.dos.flush();
            byte[] recBlk = this.readBytes(32);
            MessageBlock replyMsg = new MessageBlock();
            replyMsg.readMemoryBlock(recBlk);
            int bodyLen = replyMsg.getActualBodyLength();
            rc = replyMsg.getResult() == 1;
            if (bodyLen > 0) {
                this.readBytes(bodyLen);
            }
            boolean bl = rc;
            return bl;
        }
        catch (IOException ioe) {
            throw new WinSecurityProcessException(ioe);
        }
        finally {
            try {
                int rsize;
                while ((rsize = this.dis.available()) >= 1) {
                    byte[] bytes = new byte[32];
                    rsize = this.dis.read(bytes, 0, 32);
                }
            }
            catch (IOException e) {}
        }
    }

    private void setUNCParameters(MessageBlock msg, String unc, String password) throws UnsupportedEncodingException {
        UNCName uncname = new UNCName(unc);
        msg.addBodyString(FENCED_PARAM_USER, uncname.getAccountName());
        msg.addBodyString(FENCED_PARAM_PASSWORD, password);
        if (uncname.hasDomain()) {
            msg.addBodyString(FENCED_PARAM_DOMAIN, uncname.getDomainName());
        }
    }

    public String getDomainName() throws WinSecurityProcessException {
        if (this.domainType == DomainType.None && this.domainName == null) {
            this.domainName = this.getDomainNameImpl();
            this.domainType = this.domainName == null ? DomainType.Workgroup : DomainType.Domain;
        }
        return this.domainName;
    }

    private String getDomainNameImpl() throws WinSecurityProcessException {
        ArrayList<String> retList = null;
        String retString = null;
        MessageBlock msg = new MessageBlock();
        msg.setMessageType(1);
        msg.setCommand(8);
        msg.setSender(1);
        msg.setReceiver(2);
        try {
            byte[] SendBlk = msg.createMemBlock();
            this.dos.write(SendBlk, 0, SendBlk.length);
            this.dos.flush();
            byte[] recBlk = this.readBytes(32);
            MessageBlock replyMsg = new MessageBlock();
            replyMsg.readMemoryBlock(recBlk);
            int bodyLen = replyMsg.getActualBodyLength();
            if (replyMsg.getResult() == 1) {
                byte[] bodyBlk = this.readBytes(bodyLen);
                retList = replyMsg.readAsList(bodyBlk);
                if (retList != null) {
                    retString = retList.get(0);
                }
            } else if (replyMsg.getResult() != 0) {
                ArrayList<String> results = null;
                WinSecurityProcessException wspe = new WinSecurityProcessException(new RuntimeException());
                if (bodyLen > 0) {
                    byte[] bodyBlk = this.readBytes(bodyLen);
                    results = replyMsg.readAsList(bodyBlk);
                    wspe.setErrorMessage(results);
                } else {
                    wspe.setErrorMessage("getDomainName", "None", "None", "No cause");
                }
                throw wspe;
            }
            String string = retString;
            return string;
        }
        catch (IOException ioe) {
            throw new WinSecurityProcessException(ioe);
        }
        finally {
            try {
                int rsize;
                while ((rsize = this.dis.available()) >= 1) {
                    byte[] bytes = new byte[32];
                    rsize = this.dis.read(bytes, 0, 32);
                }
            }
            catch (IOException e) {}
        }
    }

    public String getComputerName() throws WinSecurityProcessException {
        if (this.pcName == null) {
            this.pcName = this.getComputerNameImpl();
        }
        return this.pcName;
    }

    public String getComputerNameImpl() throws WinSecurityProcessException {
        ArrayList<String> retList = null;
        String retString = null;
        MessageBlock msg = new MessageBlock();
        msg.setMessageType(1);
        msg.setCommand(7);
        msg.setSender(1);
        msg.setReceiver(2);
        try {
            byte[] SendBlk = msg.createMemBlock();
            this.dos.write(SendBlk, 0, SendBlk.length);
            this.dos.flush();
            byte[] recBlk = this.readBytes(32);
            MessageBlock replyMsg = new MessageBlock();
            replyMsg.readMemoryBlock(recBlk);
            int bodyLen = replyMsg.getActualBodyLength();
            if (replyMsg.getResult() == 1) {
                byte[] bodyBlk = this.readBytes(bodyLen);
                retList = replyMsg.readAsList(bodyBlk);
                if (retList != null) {
                    retString = retList.get(0);
                }
            } else if (replyMsg.getResult() != 0) {
                ArrayList<String> results = null;
                WinSecurityProcessException wspe = new WinSecurityProcessException(new RuntimeException());
                if (bodyLen > 0) {
                    byte[] bodyBlk = this.readBytes(bodyLen);
                    results = replyMsg.readAsList(bodyBlk);
                    wspe.setErrorMessage(results);
                } else {
                    wspe.setErrorMessage("getComputerName", "None", "None", "No cause");
                }
                throw wspe;
            }
            String string = retString;
            return string;
        }
        catch (IOException ioe) {
            throw new WinSecurityProcessException(ioe);
        }
        finally {
            try {
                int rsize;
                while ((rsize = this.dis.available()) >= 1) {
                    byte[] bytes = new byte[32];
                    rsize = this.dis.read(bytes, 0, 32);
                }
            }
            catch (IOException e) {}
        }
    }

    private boolean isValidComputerName(String unc) throws WinSecurityProcessException {
        UNCName uncName = new UNCName(unc);
        String inputComputerName = uncName.getDomainName();
        if (inputComputerName == null) {
            return true;
        }
        String dname = this.getDomainName();
        if (dname != null) {
            return true;
        }
        String computerName = this.getComputerName();
        return computerName.equalsIgnoreCase(inputComputerName);
    }

    public boolean netDisconnect(String filepath) throws WinSecurityProcessException {
        boolean rc = false;
        MessageBlock msg = new MessageBlock();
        try {
            msg.setMessageType(1);
            msg.setCommand(9);
            msg.setSender(1);
            msg.setReceiver(2);
            msg.addBodyString("filepath", filepath);
            byte[] SendBlk = msg.createMemBlock();
            this.dos.write(SendBlk, 0, SendBlk.length);
            this.dos.flush();
            byte[] recBlk = this.readBytes(32);
            MessageBlock replyMsg = new MessageBlock();
            replyMsg.readMemoryBlock(recBlk);
            int bodyLen = replyMsg.getActualBodyLength();
            rc = replyMsg.getResult() == 1;
            if (bodyLen > 0) {
                this.readBytes(bodyLen);
            }
            boolean bl = rc;
            return bl;
        }
        catch (IOException ioe) {
            throw new WinSecurityProcessException(ioe);
        }
        finally {
            try {
                int rsize;
                while ((rsize = this.dis.available()) >= 1) {
                    byte[] bytes = new byte[32];
                    rsize = this.dis.read(bytes, 0, 32);
                }
            }
            catch (IOException e) {}
        }
    }

    @Override
    protected Object performCommand(Object[] args) throws Exception {
        if (args == null || args.length == 0) {
            throw new InvalidArgumentException("invalid parameters in performCommand");
        }
        Serializable retval = null;
        int command = (Integer)args[0];
        switch (command) {
            case 0: {
                break;
            }
            case 1: {
                String unc = (String)args[1];
                String password = (String)args[2];
                boolean rc = this.userValidation(unc, password);
                retval = rc;
                break;
            }
            case 2: {
                String unc = (String)args[1];
                String password = (String)args[2];
                String domain = (String)args[3];
                retval = this.getGroupList(unc, password, domain);
                break;
            }
            case 3: {
                String unc = (String)args[1];
                String password = (String)args[2];
                String filepath = (String)args[3];
                boolean rc = this.netConnection(unc, password, filepath);
                retval = rc;
                break;
            }
            case 4: {
                String filepath = (String)args[1];
                retval = this.getACL(filepath);
                break;
            }
            case 5: {
                String unc = (String)args[1];
                String password = (String)args[2];
                String filepath = (String)args[3];
                boolean rc = this.impersonate(unc, password, filepath);
                retval = rc;
                break;
            }
            case 6: {
                String orgFilePath = (String)args[1];
                boolean rc = this.isNTFS(orgFilePath);
                retval = rc;
                break;
            }
            case 7: {
                retval = this.getComputerName();
                break;
            }
            case 8: {
                retval = this.getDomainName();
                break;
            }
            case 9: {
                String filepath = (String)args[1];
                boolean rc = this.netDisconnect(filepath);
                retval = rc;
                break;
            }
            case 10: {
                String driveLetter = (String)args[1];
                boolean rc = this.isMappedDrive(driveLetter);
                retval = rc;
                break;
            }
            default: {
                throw new IllegalArgumentException("Command:" + command);
            }
        }
        return retval;
    }

    public boolean isMappedDrive(String orgFilePath) throws WinSecurityProcessException {
        String driveLetter = null;
        if (orgFilePath == null || orgFilePath.length() < 3) {
            return false;
        }
        if (orgFilePath.startsWith("\\\\")) {
            return false;
        }
        if (!orgFilePath.substring(1, 3).equals(":\\")) {
            return false;
        }
        driveLetter = orgFilePath.substring(0, 3);
        boolean rc = false;
        MessageBlock msg = new MessageBlock();
        try {
            msg.setMessageType(1);
            msg.setCommand(10);
            msg.setSender(1);
            msg.setReceiver(2);
            msg.addBodyString("filepath", driveLetter);
            byte[] SendBlk = msg.createMemBlock();
            this.dos.write(SendBlk, 0, SendBlk.length);
            this.dos.flush();
            byte[] recBlk = this.readBytes(32);
            MessageBlock replyMsg = new MessageBlock();
            replyMsg.readMemoryBlock(recBlk);
            int bodyLen = replyMsg.getActualBodyLength();
            rc = replyMsg.getResult() == 1;
            if (bodyLen > 0) {
                this.readBytes(bodyLen);
            }
            boolean bl = rc;
            return bl;
        }
        catch (IOException ioe) {
            throw new WinSecurityProcessException(ioe);
        }
        finally {
            try {
                int rsize;
                while ((rsize = this.dis.available()) >= 1) {
                    byte[] bytes = new byte[32];
                    rsize = this.dis.read(bytes, 0, 32);
                }
            }
            catch (IOException e) {}
        }
    }

    private byte[] readBytes(int totalLength) throws IOException, WinSecurityProcessException {
        int restOfBytes;
        int rbyte;
        byte[] recBlk = new byte[totalLength];
        int nbyte = 0;
        for (restOfBytes = totalLength; restOfBytes > 0 && (rbyte = this.dis.read(recBlk, 0, restOfBytes)) != -1; restOfBytes -= rbyte) {
            nbyte += rbyte;
        }
        if (restOfBytes != 0) {
            throw new WinSecurityProcessException(new IOException("restBytes/TotalBytes = " + restOfBytes + "/" + totalLength));
        }
        return recBlk;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DomainType {
        None,
        Workgroup,
        Domain;

    }
}

