/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.util.fenced;

import com.ibm.es.nuvo.crawler.util.fenced.AbstractFencedProcess;
import com.ibm.es.nuvo.crawler.util.fenced.WinSecurityProcess;
import com.ibm.es.nuvo.crawler.util.fenced.WinSecurityProcessException;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessManager {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + ProcessManager.class.getName());
    private static final ProcessManager instance = new ProcessManager();
    private Timer timer;
    private List<WeakReference<AbstractFencedProcess>> killed = new ArrayList<WeakReference<AbstractFencedProcess>>();
    private HashMap<Class<? extends AbstractFencedProcess>, ProcessStack> processMap = new HashMap();

    public static ProcessManager getInstance() {
        return instance;
    }

    private ProcessManager() {
        this.timer = new Timer("ProcessManager_Timer");
        this.timer.schedule((TimerTask)new MonitorProcessTask(), 1000L, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        if (tracer.isLoggable(Level.FINE)) {
            tracer.fine("terminating");
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        HashMap<Class<? extends AbstractFencedProcess>, ProcessStack> hashMap = this.processMap;
        synchronized (hashMap) {
            for (ProcessStack ps : this.processMap.values()) {
                for (AbstractFencedProcess p : ps.getAll()) {
                    this.kill(p);
                }
            }
        }
        if (tracer.isLoggable(Level.FINER)) {
            tracer.finer("waiting for termination");
        }
        this.waitForKilled(600);
        if (tracer.isLoggable(Level.FINER)) {
            tracer.finer("terminated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseProcess(AbstractFencedProcess process) {
        ProcessStack st;
        if (tracer.isLoggable(Level.FINER)) {
            tracer.finer("released " + process);
        }
        ProcessStack processStack = st = this.getStack(process.getClass());
        synchronized (processStack) {
            st.push(process);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractFencedProcess getProcesses(Class<? extends AbstractFencedProcess> cls, Class<?>[] argCls, Object[] args) {
        ProcessStack st = this.getStack(cls);
        AbstractFencedProcess proc = null;
        while (!Thread.currentThread().isInterrupted()) {
            ProcessStack processStack = st;
            synchronized (processStack) {
                if (st.size() > 0) {
                    proc = st.pop();
                    break;
                }
            }
            if (st.semaphore.tryAcquire(1)) {
                proc = this.createProcess(cls, argCls, args);
                st.push(proc);
                continue;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ignored) {}
        }
        if (tracer.isLoggable(Level.FINER)) {
            tracer.finer("got " + proc);
        }
        return proc;
    }

    private AbstractFencedProcess createProcess(Class<? extends AbstractFencedProcess> cls, Class<?>[] argCls, Object[] args) {
        AbstractFencedProcess process = null;
        try {
            process = args == null ? cls.newInstance() : cls.getConstructor(argCls).newInstance(args);
            if (tracer.isLoggable(Level.FINER)) {
                tracer.finer("created " + (args == null ? "null" : Arrays.asList(args)));
            }
            process.initialize(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void kill(AbstractFencedProcess process) {
        KillerThread thread = new KillerThread(process);
        thread.start();
        if (tracer.isLoggable(Level.FINER)) {
            tracer.finer("kill " + process);
        }
        List<WeakReference<AbstractFencedProcess>> list = this.killed;
        synchronized (list) {
            this.killed.add(new WeakReference<AbstractFencedProcess>(process));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForKilled(int maxWait) {
        long max = System.currentTimeMillis() + (long)maxWait * 1000L;
        while (max < System.currentTimeMillis() && this.killed.size() > 0) {
            List<WeakReference<AbstractFencedProcess>> list = this.killed;
            synchronized (list) {
                ListIterator<WeakReference<AbstractFencedProcess>> li = this.killed.listIterator();
                ArrayList<AbstractFencedProcess> removedList = new ArrayList<AbstractFencedProcess>();
                while (li.hasNext()) {
                    WeakReference<AbstractFencedProcess> wr = li.next();
                    AbstractFencedProcess p = (AbstractFencedProcess)wr.get();
                    if (p != null && p.isAlive()) continue;
                    removedList.add(p);
                }
                for (AbstractFencedProcess entry : removedList) {
                    this.killed.remove(entry);
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ignored) {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessStack getStack(Class<? extends AbstractFencedProcess> cls) {
        ProcessStack st = this.processMap.get(cls);
        if (st == null) {
            HashMap<Class<? extends AbstractFencedProcess>, ProcessStack> hashMap = this.processMap;
            synchronized (hashMap) {
                st = this.processMap.get(cls);
                if (st == null) {
                    st = this.createStack(cls);
                    this.processMap.put(cls, st);
                }
            }
        }
        return st;
    }

    private ProcessStack createStack(Class<? extends AbstractFencedProcess> cls) {
        int max = 2;
        int alive = 60;
        int timeout = 60;
        if (WinSecurityProcess.class.equals(cls)) {
            max = 2;
        } else {
            max = this.getSys(cls, ".max", max);
            alive = this.getSys(cls, ".keepalive", alive);
            timeout = this.getSys(cls, ".timeout", timeout);
        }
        if (tracer.isLoggable(Level.FINER)) {
            tracer.finer("create stack " + max + ", " + alive + ", " + timeout);
        }
        return new ProcessStack(max, alive, timeout);
    }

    private int getSys(Class<? extends AbstractFencedProcess> cls, String suffix, int def) {
        String p = System.getProperties().getProperty(cls.getName() + suffix);
        if (p != null) {
            return Integer.parseInt(p);
        }
        return def;
    }

    public boolean userValidation(String unc, String password) throws WinSecurityProcessException {
        AbstractFencedProcess p = this.getProcesses(WinSecurityProcess.class, null, null);
        try {
            Object ret = p.process(new Object[]{1, unc, password});
            boolean bl = (Boolean)ret;
            return bl;
        }
        catch (Exception e) {
            throw new WinSecurityProcessException(e);
        }
        finally {
            this.releaseProcess(p);
        }
    }

    public ArrayList<String> getGroupList(String unc, String password, String domain) throws WinSecurityProcessException {
        AbstractFencedProcess p = this.getProcesses(WinSecurityProcess.class, null, null);
        try {
            ArrayList arrayList;
            Object ret = p.process(new Object[]{2, unc, password, domain});
            ArrayList arrayList2 = arrayList = (ArrayList)ret;
            return arrayList2;
        }
        catch (Exception e) {
            throw new WinSecurityProcessException(e);
        }
        finally {
            this.releaseProcess(p);
        }
    }

    public boolean impersonate(String unc, String password, String filepath) throws WinSecurityProcessException {
        AbstractFencedProcess p = this.getProcesses(WinSecurityProcess.class, null, null);
        try {
            Object ret = p.process(new Object[]{5, unc, password, filepath});
            boolean bl = (Boolean)ret;
            return bl;
        }
        catch (Exception e) {
            throw new WinSecurityProcessException(e);
        }
        finally {
            this.releaseProcess(p);
        }
    }

    public boolean netConnection(String user, String password, String filepath) throws WinSecurityProcessException {
        AbstractFencedProcess p = this.getProcesses(WinSecurityProcess.class, null, null);
        try {
            Object ret = p.process(new Object[]{3, user, password, filepath});
            boolean bl = (Boolean)ret;
            return bl;
        }
        catch (Exception e) {
            throw new WinSecurityProcessException(e);
        }
        finally {
            this.releaseProcess(p);
        }
    }

    public ArrayList<String> getACL(String filepath) throws WinSecurityProcessException {
        AbstractFencedProcess p = this.getProcesses(WinSecurityProcess.class, null, null);
        try {
            ArrayList arrayList;
            Object ret = p.process(new Object[]{4, filepath});
            ArrayList arrayList2 = arrayList = (ArrayList)ret;
            return arrayList2;
        }
        catch (Exception e) {
            throw new WinSecurityProcessException(e);
        }
        finally {
            this.releaseProcess(p);
        }
    }

    public boolean isNTFS(String orgFilePath) throws WinSecurityProcessException {
        AbstractFencedProcess p = this.getProcesses(WinSecurityProcess.class, null, null);
        try {
            Object ret = p.process(new Object[]{6, orgFilePath});
            boolean bl = (Boolean)ret;
            return bl;
        }
        catch (Exception e) {
            throw new WinSecurityProcessException(e);
        }
        finally {
            this.releaseProcess(p);
        }
    }

    public String getDomainName() throws WinSecurityProcessException {
        AbstractFencedProcess p = this.getProcesses(WinSecurityProcess.class, null, null);
        try {
            Object ret = p.process(new Object[]{8});
            String string = (String)ret;
            return string;
        }
        catch (Exception e) {
            throw new WinSecurityProcessException(e);
        }
        finally {
            this.releaseProcess(p);
        }
    }

    public String getComputerName() throws WinSecurityProcessException {
        AbstractFencedProcess p = this.getProcesses(WinSecurityProcess.class, null, null);
        try {
            Object ret = p.process(new Object[]{7});
            String string = (String)ret;
            return string;
        }
        catch (Exception e) {
            throw new WinSecurityProcessException(e);
        }
        finally {
            this.releaseProcess(p);
        }
    }

    public boolean netDisconnect(String filepath) throws WinSecurityProcessException {
        AbstractFencedProcess p = this.getProcesses(WinSecurityProcess.class, null, null);
        try {
            Object ret = p.process(new Object[]{9, filepath});
            boolean bl = (Boolean)ret;
            return bl;
        }
        catch (Exception e) {
            throw new WinSecurityProcessException(e);
        }
        finally {
            this.releaseProcess(p);
        }
    }

    public boolean isMappedDrive(String orgFilePath) throws WinSecurityProcessException {
        AbstractFencedProcess p = this.getProcesses(WinSecurityProcess.class, null, null);
        try {
            Object ret = p.process(new Object[]{10, orgFilePath});
            boolean bl = (Boolean)ret;
            return bl;
        }
        catch (Exception e) {
            throw new WinSecurityProcessException(e);
        }
        finally {
            this.releaseProcess(p);
        }
    }

    private class MonitorProcessTask
    extends TimerTask {
        private MonitorProcessTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                HashMap hashMap = ProcessManager.this.processMap;
                synchronized (hashMap) {
                    for (ProcessStack ps : ProcessManager.this.processMap.values()) {
                        ArrayList<AbstractFencedProcess> list = ps.purge();
                        for (AbstractFencedProcess p : list) {
                            ProcessManager.this.kill(p);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProcessStack {
        private static final long serialVersionUID = 1L;
        private Semaphore semaphore;
        private final int timeout;
        private final int keepAlive;
        private Stack<AbstractFencedProcess> stack;
        private List<AbstractFencedProcess> using;
        private Object stackLock;

        public ProcessStack(int max, int tout, int kalive) {
            this.timeout = tout;
            this.keepAlive = kalive;
            this.semaphore = new Semaphore(max);
            this.stack = new Stack();
            this.using = new ArrayList<AbstractFencedProcess>();
            this.stackLock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AbstractFencedProcess pop() {
            Object object = this.stackLock;
            synchronized (object) {
                AbstractFencedProcess p = this.stack.pop();
                this.using.add(p);
                return p;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            Object object = this.stackLock;
            synchronized (object) {
                return this.stack.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void push(AbstractFencedProcess process) {
            Object object = this.stackLock;
            synchronized (object) {
                this.stack.push(process);
                this.using.remove(process);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ArrayList<AbstractFencedProcess> purge() {
            ArrayList<AbstractFencedProcess> badProcForKeepAlive = new ArrayList<AbstractFencedProcess>();
            ArrayList<AbstractFencedProcess> badProcForTimeout = new ArrayList<AbstractFencedProcess>();
            Object object = this.stackLock;
            synchronized (object) {
                AbstractFencedProcess p;
                ListIterator<Object> li;
                if (this.keepAlive > 0) {
                    li = this.stack.listIterator();
                    while (li.hasNext()) {
                        p = (AbstractFencedProcess)li.next();
                        if (System.currentTimeMillis() - p.getLastUsed() <= (long)this.keepAlive * 1000L) continue;
                        badProcForKeepAlive.add(p);
                        if (!tracer.isLoggable(Level.FINE)) continue;
                        tracer.fine("Killed keepAlive " + p);
                    }
                }
                if (this.timeout > 0) {
                    li = this.using.listIterator();
                    while (li.hasNext()) {
                        p = (AbstractFencedProcess)li.next();
                        if (System.currentTimeMillis() - p.getStarted() <= (long)this.timeout * 1000L) continue;
                        badProcForTimeout.add(p);
                        if (!tracer.isLoggable(Level.FINE)) continue;
                        tracer.fine("Killed timeout " + p);
                    }
                }
                for (AbstractFencedProcess pe : badProcForKeepAlive) {
                    this.stack.remove(pe);
                }
                for (AbstractFencedProcess pe : badProcForTimeout) {
                    this.using.remove(pe);
                }
            }
            int numOfBadProcesses = badProcForKeepAlive.size() + badProcForTimeout.size();
            if (numOfBadProcesses > 0) {
                this.semaphore.release(numOfBadProcesses);
            }
            badProcForKeepAlive.addAll(badProcForTimeout);
            return badProcForKeepAlive;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<AbstractFencedProcess> getAll() {
            ArrayList<AbstractFencedProcess> list = new ArrayList<AbstractFencedProcess>();
            Object object = this.stackLock;
            synchronized (object) {
                list.addAll(this.stack);
                list.addAll(this.using);
            }
            return list;
        }
    }

    private static class KillerThread
    extends Thread {
        private final AbstractFencedProcess process;

        public KillerThread(AbstractFencedProcess proc) {
            this.process = proc;
        }

        public void run() {
            try {
                this.process.terminate();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

