/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.util.fenced;

import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;

public abstract class AbstractFencedProcess {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + AbstractFencedProcess.class.getName());
    private long lastUsed;
    private long started;
    protected Process process;

    public AbstractFencedProcess() {
        this.started = this.lastUsed = System.currentTimeMillis();
    }

    protected abstract void init(Properties var1) throws Exception;

    protected abstract void startProcess() throws Exception;

    public final void initialize(Properties properties) throws Exception {
        if (tracer.isLoggable(Level.FINER)) {
            tracer.finer("Initialize " + properties);
        }
        this.init(properties);
        this.startProcess();
    }

    protected abstract void term() throws Exception;

    public final void terminate() throws Exception {
        if (tracer.isLoggable(Level.FINER)) {
            tracer.finer("Terminate ");
        }
        this.term();
        if (this.process != null) {
            this.process.destroy();
            if (tracer.isLoggable(Level.FINEST)) {
                tracer.finest("Destroy " + this.process);
            }
            if (tracer.isLoggable(Level.FINEST)) {
                tracer.finest("Waiting Terminate " + this.process);
            }
            this.process.waitFor();
            if (tracer.isLoggable(Level.FINEST)) {
                tracer.finest("Terminated " + this.process);
            }
            this.process = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object process(Object[] args) throws Exception {
        if (tracer.isLoggable(Level.FINER)) {
            tracer.finer("process " + Arrays.asList(args));
        }
        this.started = System.currentTimeMillis();
        try {
            Object ret = this.performCommand(args);
            if (tracer.isLoggable(Level.FINER)) {
                tracer.finer("process result " + ret);
            }
            Object object = ret;
            return object;
        }
        finally {
            this.lastUsed = System.currentTimeMillis();
        }
    }

    protected abstract Object performCommand(Object[] var1) throws Exception;

    public final long getLastUsed() {
        return this.lastUsed;
    }

    public final long getStarted() {
        return this.started;
    }

    public boolean isAlive() {
        return this.process != null;
    }

    public String toString() {
        String name = this.getClass().getName();
        if (name.indexOf(".") >= 0) {
            name = name.substring(name.lastIndexOf(".") + 1);
        }
        return name + "@" + this.hashCode();
    }
}

