/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.util.archive.zip;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Calendar;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

public class ZipInputStream
extends InflaterInputStream {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    static final long SIGLOC = 67324752L;
    static final long SIGEXT = 134695760L;
    static final int LOCSIG = 4;
    static final int LOCVER = 2;
    static final int LOCFLG = 2;
    static final int LOCHOW = 2;
    static final int LOCTIM = 4;
    static final int LOCCRC = 4;
    static final int LOCSIZ = 4;
    static final int LOCLEN = 4;
    static final int LOCNAM = 2;
    static final int LOCEXT = 2;
    static final int EXTSIG = 4;
    static final int EXTCRC = 4;
    static final int EXTSIZ = 4;
    static final int EXTLEN = 4;
    static final int LOCHDR = 30;
    static final int EXTHDR = 16;
    static final int FLGENC = 1;
    static final int FLGEXT = 8;
    static final int STORED = 0;
    static final int DEFLATED = 8;
    private static final int INITIAL_BUFFER_SIZE = 256;
    private ZipEntry entry;
    private int flag;
    private long remain;
    private CRC32 crc32 = new CRC32();
    private byte[] buffer = new byte[256];
    private byte[] header = new byte[256];
    private boolean eoe = true;

    public ZipInputStream(InputStream in) {
        super(new PushbackInputStream(in, 512), new Inflater(true), 512);
    }

    public ZipEntry getNextEntry() throws IOException {
        return this.getNextEntry(null);
    }

    public ZipEntry getNextEntry(String charset) throws IOException {
        if (this.entry != null) {
            this.closeEntry();
        }
        this.crc32.reset();
        this.inf.reset();
        if (this.readBytes(this.header, 0, 30) == -1) {
            return null;
        }
        int offset = 0;
        long signature = ZipInputStream.readLong(this.header, offset);
        if (signature != 67324752L) {
            return null;
        }
        ZipInputStream.readInt(this.header, offset += 4);
        int f = ZipInputStream.readInt(this.header, offset += 2);
        int how = ZipInputStream.readInt(this.header, offset += 2);
        long time = ZipInputStream.readLong(this.header, offset += 2);
        long crc = ZipInputStream.readLong(this.header, offset += 4);
        long csize = ZipInputStream.readLong(this.header, offset += 4);
        long size = ZipInputStream.readLong(this.header, offset += 4);
        int nameLen = ZipInputStream.readInt(this.header, offset += 4);
        int extLen = ZipInputStream.readInt(this.header, offset += 2);
        if (how != 0 && how != 8) {
            throw new UnsupportedCompressionMethodException();
        }
        this.ensureBuffer(nameLen);
        this.readBytes(this.buffer, 0, nameLen);
        this.entry = charset == null ? new ZipEntry(new String(this.buffer, 0, nameLen)) : new ZipEntry(new String(this.buffer, 0, nameLen, charset));
        this.flag = f;
        this.entry.setMethod(how);
        this.entry.setTime(ZipInputStream.dosToJava(time));
        this.entry.setCrc(crc);
        this.entry.setCompressedSize(csize);
        this.entry.setSize(size);
        if ((this.flag & 1) == 1) {
            throw new EncryptedZipException();
        }
        if (extLen > 0) {
            byte[] ext = new byte[extLen];
            this.readBytes(ext, 0, extLen);
            this.entry.setExtra(ext);
        }
        if (how == 0) {
            this.remain = size;
        }
        this.eoe = false;
        return this.entry;
    }

    public void closeEntry() throws IOException {
        while (this.read(this.buffer) != -1) {
        }
        this.entry = null;
        this.eoe = false;
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        int l = this.read(b, 0, 1);
        return l < 0 ? -1 : b[0] & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int l) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || l < 0 || off + l > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.eoe || this.entry == null) {
            return -1;
        }
        switch (this.entry.getMethod()) {
            case 0: {
                if (this.remain <= 0L) {
                    this.eoe = true;
                    return -1;
                }
                l = (long)l > this.remain ? (int)this.remain : l;
                if ((l = this.in.read(b, off, l)) == -1) {
                    throw new ZipException("unexpected");
                }
                this.crc32.update(b, off, l);
                this.remain -= (long)l;
                return l;
            }
            case 8: {
                l = super.read(b, off, l);
                if (l == -1) {
                    int n = this.inf.getRemaining();
                    if (n > 0) {
                        ((PushbackInputStream)this.in).unread(this.buf, this.len - n, n);
                    }
                    long sig = 0L;
                    long crc = this.entry.getCrc();
                    long csize = this.entry.getCompressedSize();
                    long size = this.entry.getSize();
                    if ((this.flag & 8) == 8) {
                        this.readBytes(this.header, 0, 4);
                        sig = ZipInputStream.readLong(this.header, 0);
                        if (sig == 134695760L) {
                            int offset = 0;
                            this.readBytes(this.header, 0, 12);
                            crc = ZipInputStream.readLong(this.header, offset);
                            csize = ZipInputStream.readLong(this.header, offset += 4);
                            size = ZipInputStream.readLong(this.header, offset += 4);
                        } else {
                            crc = sig;
                            int offset = 0;
                            this.readBytes(this.header, 0, 8);
                            csize = ZipInputStream.readLong(this.header, offset);
                            size = ZipInputStream.readLong(this.header, offset += 4);
                        }
                    }
                    if (size != (long)this.inf.getTotalOut()) {
                        throw new ZipException("entry size mismatch (expected " + this.entry.getSize() + " bytes, actual " + this.inf.getTotalOut() + " bytes)");
                    }
                    if (csize != (long)this.inf.getTotalIn()) {
                        throw new ZipException("entry compressed size mismatch (expected " + this.entry.getCompressedSize() + " bytes, actual " + this.inf.getTotalIn() + " bytes)");
                    }
                    if (crc != this.crc32.getValue()) {
                        throw new ZipException("entry CRC mismatch (expected " + Long.toHexString(this.entry.getCrc()) + " , actual " + Long.toHexString(this.crc32.getValue()) + ")");
                    }
                    this.entry.setSize(size);
                    this.entry.setCompressedSize(csize);
                    this.entry.setCrc(crc);
                    this.eoe = true;
                } else {
                    this.crc32.update(b, off, l);
                }
                return l;
            }
        }
        throw new ZipException("unsupported compression method " + this.entry.getMethod());
    }

    public int available() throws IOException {
        return this.entry == null ? 0 : 1;
    }

    public long skip(long n) throws IOException {
        int total;
        int l;
        int actual;
        if (n < 0L) {
            throw new IllegalArgumentException();
        }
        int n2 = actual = Integer.MAX_VALUE < n ? Integer.MAX_VALUE : (int)n;
        for (total = 0; total < actual; total += l) {
            l = actual - total;
            l = l > this.buffer.length ? this.buffer.length : l;
            if ((l = this.read(this.buffer, 0, l)) != -1) continue;
            this.entry = null;
            break;
        }
        return total;
    }

    private int readBytes(byte[] b, int off, int length) throws IOException {
        int l = 0;
        int total = length;
        while (length > 0 && (l = this.in.read(b, off, length)) != -1) {
            off += l;
            length -= l;
        }
        return length > 0 ? -1 : total;
    }

    private void ensureBuffer(int required) {
        if (required > this.buffer.length) {
            int capacity = this.buffer.length;
            while (required > (capacity *= 2)) {
            }
            this.buffer = new byte[capacity];
        }
    }

    static final int readInt(byte[] buf, int off) {
        return buf[off] & 0xFF | (buf[off + 1] & 0xFF) << 8;
    }

    static final long readLong(byte[] buf, int off) {
        return (long)ZipInputStream.readInt(buf, off) | (long)ZipInputStream.readInt(buf, off + 2) << 16;
    }

    static final long dosToJava(long time) {
        Calendar c = Calendar.getInstance();
        c.set((int)(time >> 25 & 0x7FL) + 1980, (int)(time >> 21 & 0xFL) - 1, (int)(time >> 16 & 0x1FL), (int)(time >> 11 & 0x1FL), (int)(time >> 5 & 0x3FL), (int)(time << 1 & 0x3EL));
        return c.getTimeInMillis();
    }

    public static final class EncryptedZipException
    extends ZipException {
    }

    public static final class UnsupportedCompressionMethodException
    extends ZipException {
    }
}

