/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.util.archive.tar;

import com.ibm.es.nuvo.crawler.util.archive.tar.BlockedInputStream;
import com.ibm.es.nuvo.crawler.util.archive.tar.TarEntry;
import com.ibm.es.nuvo.crawler.util.archive.tar.TarHeaderException;
import java.io.IOException;
import java.io.InputStream;

public class TarInputStream
extends BlockedInputStream {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final int BLOCK_SIZE = 512;
    private TarEntry entry = null;
    private long eSize = 0L;
    private long eOffset = 0L;
    private long ePos = -1L;
    private byte[] buffer = new byte[512];

    public TarInputStream(InputStream input) {
        this(input, 10);
    }

    public TarInputStream(InputStream input, int blockingFactor) {
        super(input, 512, blockingFactor);
    }

    public TarEntry getNextEntry() throws IOException {
        return this.getNextEntry(null);
    }

    public TarEntry getNextEntry(String charset) throws IOException {
        ++this.ePos;
        this.skipToNextEntry();
        int len = this.readBlock(this.buffer, 0);
        boolean isEOA = true;
        for (int i = 0; i < len; ++i) {
            if (this.buffer[i] == 0) continue;
            isEOA = false;
            break;
        }
        if (isEOA) {
            return null;
        }
        this.entry = new TarEntry(this.buffer, charset);
        this.eOffset = 0L;
        this.eSize = (int)this.entry.getSize();
        int checksum = 0;
        for (int i = 0; i < this.buffer.length; ++i) {
            if (i < 148 || i > 155) {
                checksum += 0xFF & this.buffer[i];
                continue;
            }
            checksum += 32;
        }
        if (checksum != this.entry.getCheckSum()) {
            throw new TarHeaderException("Tar checksum error");
        }
        if (this.entry.isLongNameEntry()) {
            StringBuffer longname = new StringBuffer();
            byte[] b = new byte[512];
            int l = 0;
            while ((l = this.read(b, 0, b.length)) != -1) {
                longname.append(new String(b, 0, l));
            }
            this.getNextEntry();
            if (longname.length() > 0 && longname.charAt(longname.length() - 1) == '\u0000') {
                longname.deleteCharAt(longname.length() - 1);
            }
            this.entry.setName(longname.toString());
        }
        return this.entry;
    }

    public int available() {
        return (int)(this.eSize - this.eOffset);
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        int len = this.read(b, 0, 1);
        return len < 0 ? -1 : b[0] & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.eOffset >= this.eSize) {
            return -1;
        }
        int required = len;
        if (this.eOffset + (long)required > this.eSize) {
            required = (int)(this.eSize - this.eOffset);
        }
        int actual = super.read(b, off, required);
        this.eOffset += (long)actual;
        return actual;
    }

    public long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException();
        }
        long actual = this.eSize - this.eOffset;
        actual = actual > n ? n : actual;
        return super.skip(actual);
    }

    private long skipToNextEntry() throws IOException {
        if (this.entry != null && this.eSize > 0L) {
            int blockSize = this.getBlockSize();
            long totalLength = this.eSize;
            if (this.eSize % (long)blockSize > 0L) {
                totalLength = this.eSize - this.eSize % (long)blockSize + (long)blockSize;
            }
            return super.skip(totalLength - this.eOffset);
        }
        return 0L;
    }
}

