/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.util.archive.tar;

import com.ibm.es.nuvo.crawler.util.archive.tar.TarParser;
import java.io.IOException;

public class TarEntry {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    static final String TMAGIC = "ustar";
    static final String TVERSION = "00";
    static final String TLONGLINK = "././@LongLink";
    static final int NAME_LEN = 100;
    static final int MODE_LEN = 8;
    static final int UID_LEN = 8;
    static final int GID_LEN = 8;
    static final int SIZE_LEN = 12;
    static final int MTIME_LEN = 12;
    static final int CHKSUM_LEN = 8;
    static final int LINKNAME_LEN = 100;
    static final int MAGIC_LEN = 6;
    static final int VERSION_LEN = 2;
    static final int UNAME_LEN = 32;
    static final int GNAME_LEN = 32;
    static final int DEVMAJOR_LEN = 8;
    static final int DEVMINOR_LEN = 8;
    static final int PREFIX_LEN = 155;
    public static final byte AREGTYPE = 0;
    public static final byte REGTYPE = 48;
    public static final byte LNKTYPE = 49;
    public static final byte SYMTYPE = 50;
    public static final byte CHRTYPE = 51;
    public static final byte BLKTYPE = 52;
    public static final byte DIRTYPE = 53;
    public static final byte FIFOTYPE = 54;
    public static final byte CONTTYPE = 55;
    static final byte LNMETYPE = 76;
    public static final int TSUID = 2048;
    public static final int TSGID = 1024;
    public static final int TSVTX = 512;
    public static final int TUREAD = 256;
    public static final int TUWRITE = 128;
    public static final int TUEXEC = 64;
    public static final int TGREAD = 32;
    public static final int TGWRITE = 16;
    public static final int TGEXEC = 8;
    public static final int TOREAD = 4;
    public static final int TOWRITE = 2;
    public static final int TOEXEC = 1;
    private StringBuffer name = new StringBuffer();
    private int mode;
    private int uid;
    private int gid;
    private long size;
    private long mtime;
    private int chksum;
    private byte typeflag;
    private StringBuffer linkname = new StringBuffer();
    private StringBuffer magic = new StringBuffer("ustar");
    private StringBuffer version;
    private StringBuffer uname = new StringBuffer();
    private StringBuffer gname = new StringBuffer();
    private int devmajor;
    private int devminor;
    private StringBuffer prefix;

    private TarEntry() {
        this.mtime = System.currentTimeMillis();
    }

    TarEntry(byte[] header, String charset) throws IOException {
        this();
        this.parseHeader(header, charset);
    }

    private void parseHeader(byte[] header, String charset) throws IOException {
        int offset = 0;
        this.name = TarParser.parseString(header, offset, 100, charset);
        this.mode = (int)TarParser.parseOctal(header, offset += 100, 8);
        this.uid = (int)TarParser.parseOctal(header, offset += 8, 8);
        this.gid = (int)TarParser.parseOctal(header, offset += 8, 8);
        this.size = TarParser.parseOctal(header, offset += 8, 12);
        this.mtime = TarParser.parseOctal(header, offset += 12, 12) * 1000L;
        this.chksum = (int)TarParser.parseOctal(header, offset += 12, 8);
        this.typeflag = header[offset += 8];
        this.linkname = TarParser.parseString(header, ++offset, 100, charset);
        this.magic = TarParser.parseString(header, offset += 100, 6, charset);
        this.version = TarParser.parseString(header, offset += 6, 2, charset);
        this.uname = TarParser.parseString(header, offset += 2, 32, charset);
        this.gname = TarParser.parseString(header, offset += 32, 32, charset);
        this.devmajor = (int)TarParser.parseOctal(header, offset += 32, 8);
        this.devminor = (int)TarParser.parseOctal(header, offset += 8, 8);
        this.prefix = TarParser.parseString(header, offset += 8, 155, charset);
    }

    public String getName() {
        return this.name.toString();
    }

    public void setName(String name) {
        this.name = new StringBuffer(name);
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getUserID() {
        return this.uid;
    }

    public void setUserID(int uid) {
        this.uid = uid;
    }

    public int getGroupID() {
        return this.gid;
    }

    public void setGroupID(int gid) {
        this.gid = gid;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long getTime() {
        return this.mtime;
    }

    public void setTime(long mtime) {
        this.mtime = mtime;
    }

    public int getCheckSum() {
        return this.chksum;
    }

    public byte getType() {
        return this.typeflag;
    }

    public String getLinkName() {
        return this.linkname.toString();
    }

    public String getUserName() {
        return this.uname.toString();
    }

    public void setUserName(String uname) {
        this.uname = new StringBuffer(uname);
    }

    public String getGroupName() {
        return this.gname.toString();
    }

    public void setGroupName(String gname) {
        this.gname = new StringBuffer(gname);
    }

    boolean isLongNameEntry() {
        return this.typeflag == 76 && this.name.toString().equals(TLONGLINK);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Name:").append(this.name).append(" Mode:").append(Integer.toOctalString(this.mode)).append(" UID:").append(Integer.toOctalString(this.uid)).append(" GID:").append(Integer.toOctalString(this.gid)).append(" Size:").append(Long.toOctalString(this.size)).append(" Time:").append(Long.toOctalString(this.mtime / 1000L)).append(" CheckSum:").append(Long.toOctalString(this.chksum)).append(" Type:").append((char)this.typeflag).append(" LinkName:").append(this.linkname).append(" Magic:").append(this.magic).append(" Version:").append(this.version).append(" UName:").append(this.uname).append(" GName:").append(this.gname).append(" DevMajor:").append(Integer.toOctalString(this.devmajor)).append(" DevMinor:").append(Integer.toOctalString(this.devminor)).append(" Prefix:").append(this.prefix);
        return buffer.toString();
    }
}

