/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.util.archive.tar;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BlockedInputStream
extends FilterInputStream {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final int DEFAULT_BLOCK_SIZE = 512;
    public static final int DEFAULT_BLOCKING_FACTOR = 10;
    private byte[] buffer;
    private int offset;
    private int length;
    private int bSize;
    private int rSize;
    private int bPos;
    private long rPos;
    private int nBlocks;
    private boolean eof;

    public BlockedInputStream(InputStream input) {
        this(input, 512, 10);
    }

    public BlockedInputStream(InputStream input, int blockSize, int bf) {
        super(input);
        this.bSize = blockSize;
        this.rSize = blockSize * bf;
        this.nBlocks = bf;
        this.buffer = new byte[this.rSize];
        this.offset = 0;
        this.bPos = 0;
        this.rPos = -1L;
        this.eof = false;
    }

    private void ensure() throws IOException {
        if (this.rPos < 0L) {
            this.nextRecord();
        }
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        int len = this.read(b, 0, 1);
        return len < 0 ? -1 : b[0] & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.eof) {
            return -1;
        }
        this.ensure();
        int required = len;
        long currentPos = this.rPos * (long)this.rSize + (long)(this.bPos * this.bSize) + (long)this.offset;
        long targetPos = currentPos + (long)required;
        long targetRPos = (int)(targetPos / (long)this.rSize);
        int targetBPos = (int)((targetPos - targetRPos * (long)this.rSize) / (long)this.bSize);
        int targetOffset = (int)(targetPos - (targetRPos * (long)this.rSize + (long)(targetBPos * this.bSize)));
        if (targetRPos > this.rPos) {
            int limit = this.rSize - (this.bPos * this.bSize + this.offset);
            int curOff = off;
            System.arraycopy(this.buffer, this.bPos * this.bSize + this.offset, b, curOff, limit);
            curOff += limit;
            required -= limit;
            int requiredRecordsByBytes = (int)(targetRPos - this.rPos - 1L) * this.rSize;
            while (requiredRecordsByBytes > 0) {
                int actualBytes = super.read(b, curOff, requiredRecordsByBytes);
                if (actualBytes == -1) {
                    this.eof = true;
                    return limit;
                }
                curOff += actualBytes;
                requiredRecordsByBytes -= actualBytes;
                required -= actualBytes;
            }
            this.bPos = -1;
            this.rPos = targetRPos - 1L;
            this.offset = 0;
            this.nextBlock();
            if (this.length < required) {
                System.arraycopy(this.buffer, this.bPos * this.bSize + this.offset, b, curOff, this.length);
                curOff += this.length;
                this.eof = true;
                this.bPos = this.length / this.bSize;
                this.offset = this.length - this.bPos * this.bSize;
            } else {
                System.arraycopy(this.buffer, this.bPos * this.bSize + this.offset, b, curOff, required);
                curOff += required;
                this.bPos = targetBPos;
                this.offset = targetOffset;
            }
            return curOff - off;
        }
        System.arraycopy(this.buffer, this.bPos * this.bSize + this.offset, b, off, required);
        this.bPos = targetBPos;
        this.offset = targetOffset;
        return required;
    }

    public int readBlock(byte[] b, int off) throws IOException {
        int remain;
        int len = this.bSize;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.eof) {
            return -1;
        }
        this.ensure();
        int remainInRecord = this.length - this.bPos * this.bSize;
        int n = remain = remainInRecord < this.bSize ? remainInRecord : this.bSize;
        if (remain > 0) {
            System.arraycopy(this.buffer, this.bPos * this.bSize, b, off, remain);
            this.nextBlock();
            return remain;
        }
        return -1;
    }

    private int nextBlock() throws IOException {
        int remain;
        this.bPos = (this.bPos + 1) % this.nBlocks;
        this.offset = 0;
        if (this.bPos == 0) {
            this.nextRecord();
        }
        return (remain = this.length - this.bPos * this.bSize) > this.bSize ? this.bSize : remain;
    }

    private int nextRecord() throws IOException {
        int len;
        this.length = 0;
        for (int required = this.rSize; required > 0 && (len = super.read(this.buffer, this.length, required)) != -1; required -= len) {
            this.length += len;
        }
        ++this.rPos;
        return this.length;
    }

    protected int getBlockSize() {
        return this.bSize;
    }

    public long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException();
        }
        this.ensure();
        long currentPos = this.rPos * (long)this.rSize + (long)(this.bPos * this.bSize) + (long)this.offset;
        long targetPos = currentPos + n;
        long targetRPos = (int)(targetPos / (long)this.rSize);
        int targetBPos = (int)((targetPos - targetRPos * (long)this.rSize) / (long)this.bSize);
        int targetOffset = (int)(targetPos - (targetRPos * (long)this.rSize + (long)(targetBPos * this.bSize)));
        if (targetRPos > this.rPos) {
            long skippedBuffer = (this.rPos + 1L) * (long)this.rSize - currentPos;
            long required = (targetRPos - this.rPos - 1L) * (long)this.rSize;
            long actual = super.skip(required);
            if (actual < required) {
                this.eof = true;
                return actual + skippedBuffer;
            }
            this.bPos = -1;
            this.rPos = targetRPos - 1L;
            this.offset = 0;
            this.nextRecord();
            long skipped = actual + skippedBuffer;
            if (this.length < targetBPos * this.bSize + targetOffset) {
                this.eof = true;
                skipped += (long)this.length;
            } else {
                this.bPos = targetBPos;
                this.offset = targetOffset;
                skipped += (long)(this.bPos * this.bSize * this.offset);
            }
            return skipped;
        }
        this.bPos = targetBPos;
        this.offset = targetOffset;
        return n;
    }
}

