/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.util.archive;

import com.ibm.es.nuvo.crawler.util.archive.ArchiveEntry;
import com.ibm.es.nuvo.crawler.util.archive.ArchiveFile;
import com.ibm.es.nuvo.crawler.util.archive.tar.TarEntry;
import com.ibm.es.nuvo.crawler.util.archive.tar.TarInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TarFile
extends ArchiveFile {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String TYPE = "tar";
    private static final String MIMETYPE = "application/x-tar";
    private TarInputStream input;

    TarFile() {
        this.input = null;
    }

    public TarFile(File file) throws IOException {
        this.init(TYPE, file.getName(), MIMETYPE);
        this.open(new FileInputStream(file));
    }

    public TarFile(String name, InputStream input) throws IOException {
        this.init(TYPE, name, MIMETYPE);
        this.open(input);
    }

    public ArchiveEntry getNextEntry(String charset) throws IOException {
        byte type;
        TarEntry entry = null;
        while ((entry = this.input.getNextEntry(charset)) != null && (type = entry.getType()) != 0 && type != 48 && type != 53) {
        }
        if (entry != null) {
            return this.createEntry(entry.getName(), entry.getTime(), entry.getSize(), entry.getType() == 53);
        }
        return null;
    }

    public ArchiveEntry getNextEntry() throws IOException {
        return this.getNextEntry(null);
    }

    public InputStream getInputStream() throws IOException {
        return this.createInputStream(this.input);
    }

    public void open(InputStream is) throws IOException {
        this.input = new TarInputStream(is);
    }

    public void close() throws IOException {
        if (this.input != null) {
            this.input.close();
            this.input = null;
        }
    }
}

