/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.util.archive;

import com.ibm.es.nuvo.crawler.util.archive.ArchiveEntry;
import com.ibm.es.nuvo.crawler.util.archive.ArchiveEntryFilter;
import com.ibm.es.nuvo.crawler.util.archive.ArchiveFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class FilteredArchiveFile
extends ArchiveFile {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private ArchiveFile archiveFile;
    private List<ArchiveEntryFilter> filters;

    public FilteredArchiveFile(ArchiveFile file) {
        this.archiveFile = file;
        this.filters = null;
    }

    public ArchiveEntry getNextEntry(String charset) throws IOException {
        ArchiveEntry entry = null;
        while ((entry = this.archiveFile.getNextEntry(charset)) != null && !this.accept(entry)) {
        }
        return entry;
    }

    public ArchiveEntry getNextEntry() throws IOException {
        ArchiveEntry entry = null;
        while ((entry = this.archiveFile.getNextEntry()) != null && !this.accept(entry)) {
        }
        return entry;
    }

    public InputStream getInputStream() throws IOException {
        return this.archiveFile.getInputStream();
    }

    public void open(InputStream in) throws IOException {
        this.archiveFile.open(in);
    }

    public void close() throws IOException {
        if (this.archiveFile != null) {
            this.archiveFile.close();
        }
        this.archiveFile = null;
        this.filters = null;
    }

    public void addFilter(ArchiveEntryFilter filter) {
        if (this.filters == null) {
            this.filters = new ArrayList<ArchiveEntryFilter>();
        }
        this.filters.add(filter);
    }

    public void removeFilter(ArchiveEntryFilter filter) {
        if (this.filters != null) {
            this.filters.remove(filter);
        }
    }

    private boolean accept(ArchiveEntry entry) {
        boolean accept = true;
        if (this.filters != null) {
            int size = this.filters.size();
            for (int i = 0; i < size && accept; accept &= this.filters.get(i).accept(entry), ++i) {
            }
        }
        return accept;
    }
}

