/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.util.archive;

import com.ibm.es.nuvo.crawler.util.archive.ArchiveEntry;
import com.ibm.es.nuvo.crawler.util.archive.ArchiveEntryFilter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionArchiveFilter
implements ArchiveEntryFilter {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private List<String> excludedExtensionList = new ArrayList<String>();

    private ExtensionArchiveFilter() {
        this.excludedExtensionList.add(".zip");
        this.excludedExtensionList.add(".tar");
        this.excludedExtensionList.add(".tgz");
    }

    public ExtensionArchiveFilter(List<String> excludedExtensionList) {
        this();
        this.excludedExtensionList.addAll(excludedExtensionList);
    }

    @Override
    public boolean accept(ArchiveEntry entry) {
        String ext = null;
        if (entry != null && !entry.isDirectory()) {
            int i = entry.getName().lastIndexOf(".");
            if (i > 0) {
                ext = entry.getName().substring(i, entry.getName().length());
                if (this.excludedExtensionList.contains(ext.toLowerCase())) {
                    return false;
                }
                if (this.excludedExtensionList.contains(ext.toUpperCase())) {
                    return false;
                }
            } else {
                return true;
            }
        }
        return true;
    }
}

