/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.util.archive;

import com.ibm.es.nuvo.crawler.util.archive.ArchiveFile;
import java.io.IOException;
import java.io.InputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveFileDescriptor {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private final String type;
    private final Class<? extends ArchiveFile> clazz;

    public ArchiveFileDescriptor(String type, Class<? extends ArchiveFile> clazz) {
        this.type = type;
        this.clazz = clazz;
    }

    public String getType() {
        return this.type;
    }

    public ArchiveFile createArchiveFile(String filename, String mimetype, InputStream input) throws IOException {
        try {
            ArchiveFile file = this.clazz.newInstance();
            file.init(this.type, filename, mimetype);
            file.open(input);
            return file;
        }
        catch (IOException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new IOException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new IOException(e.getMessage());
        }
    }
}

