/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.util.archive;

import com.ibm.es.nuvo.crawler.util.archive.ArchiveEntry;
import com.ibm.es.nuvo.crawler.util.archive.ArchiveEntryInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class ArchiveFile {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private String type;
    private String name;
    private String mimetype;

    void init(String atype, String aname, String mime) {
        this.type = atype;
        this.name = aname;
        this.mimetype = mime;
    }

    protected ArchiveEntry createEntry(String aname, long time, long size, boolean directory) {
        return new ArchiveEntry(this, aname, time, size, directory);
    }

    protected InputStream createInputStream(InputStream input) {
        return new ArchiveEntryInputStream(input);
    }

    public final String getType() {
        return this.type;
    }

    public final String getName() {
        return this.name;
    }

    public final String getMimetype() {
        return this.mimetype;
    }

    public abstract ArchiveEntry getNextEntry(String var1) throws IOException;

    public abstract ArchiveEntry getNextEntry() throws IOException;

    public abstract InputStream getInputStream() throws IOException;

    public abstract void open(InputStream var1) throws IOException;

    public abstract void close() throws IOException;
}

