/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.util.archive;

import com.ibm.es.nuvo.crawler.adapter.AdapterException;
import com.ibm.es.nuvo.crawler.adapter.Content;
import com.ibm.es.nuvo.crawler.adapter.SimpleBuilder;
import com.ibm.es.nuvo.crawler.adapter.SimpleContent;
import com.ibm.es.nuvo.crawler.util.archive.ArchiveEntry;
import com.ibm.es.nuvo.crawler.util.archive.ArchiveFile;
import com.ibm.es.nuvo.crawler.util.archive.TarFile;
import com.ibm.es.nuvo.crawler.util.archive.ZipFile;
import com.ibm.es.nuvo.util.uri.FSURIUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.zip.GZIPInputStream;

public class ArchiveEntryContent {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String ARCHIVE_TAG = "?ArchiveEntry=";
    private final String archiveEntryName;
    private final String archiveFileURI;
    private final String archiveCharset;

    public static boolean isArchiveFile(String originalUri) {
        return originalUri.contains(ARCHIVE_TAG);
    }

    public ArchiveEntryContent(String originalUri, String archiveCharset) throws AdapterException {
        if (!originalUri.contains(ARCHIVE_TAG)) {
            throw new AdapterException("This uri " + originalUri + " was not an archive file.");
        }
        int startIndex = originalUri.indexOf(ARCHIVE_TAG);
        int endIndex = startIndex + ARCHIVE_TAG.length();
        this.archiveFileURI = originalUri.substring(0, startIndex);
        this.archiveEntryName = this.decode(originalUri.substring(endIndex));
        this.archiveCharset = archiveCharset;
    }

    private String decode(String str) {
        String retstr = str;
        try {
            retstr = URLDecoder.decode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return retstr;
    }

    public Content getArchiveContent() throws AdapterException {
        SimpleContent parentContent = SimpleBuilder.newContent();
        SimpleContent entryContent = SimpleBuilder.newContent();
        InputStream is = null;
        try {
            parentContent.createBody(FSURIUtil.getFileObject(this.archiveFileURI));
            is = parentContent.getBody().getStream();
            ArchiveFile af = null;
            String lcArchiveFileName = this.archiveFileURI.toLowerCase();
            if (lcArchiveFileName.endsWith("zip")) {
                af = new ZipFile(this.archiveFileURI, is);
            } else if (lcArchiveFileName.endsWith("tar")) {
                af = new TarFile(this.archiveFileURI, is);
            } else if (lcArchiveFileName.endsWith("tgz") || lcArchiveFileName.endsWith("tar.gz")) {
                af = new TarFile(this.archiveFileURI, new GZIPInputStream(is));
            }
            if (af != null) {
                ArchiveEntryStream aes = new ArchiveEntryStream(af, this.archiveEntryName, this.archiveCharset);
                entryContent.createBody(aes, this.archiveEntryName);
            }
        }
        catch (IOException e) {
            throw new AdapterException(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ignore) {}
        }
        return entryContent;
    }

    private static class ArchiveEntryStream
    extends InputStream {
        private final ArchiveFile archiveFile;
        private final InputStream stream;

        private ArchiveEntryStream(ArchiveFile archiveFile, String entryName, String charset) throws IOException {
            this.archiveFile = archiveFile;
            ArchiveEntry entry = null;
            while ((entry = archiveFile.getNextEntry(charset)) != null && !entryName.equals(entry.getName())) {
            }
            this.stream = entry != null ? this.archiveFile.getInputStream() : null;
        }

        public int read() throws IOException {
            byte[] b = new byte[1];
            int len = this.read(b, 0, 1);
            return len > 0 ? b[0] & 0xFF : -1;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || off + len > b.length) {
                throw new IndexOutOfBoundsException();
            }
            if (this.stream == null) {
                return -1;
            }
            return this.stream.read(b, off, len);
        }

        public void close() throws IOException {
            if (this.stream != null) {
                try {
                    this.stream.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
            if (this.archiveFile != null) {
                try {
                    this.archiveFile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

