/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakValueHashMap<K, V>
implements Map<K, V> {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private HashMap<K, KeyWeakReference<V>> map = new HashMap();
    private ReferenceQueue<V> queue = new ReferenceQueue();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            this.map.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    public V get(Object key) {
        return this.value(this.map.get(key));
    }

    @Override
    public boolean isEmpty() {
        this.release();
        return this.map.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> keySet() {
        this.release();
        this.readLock.lock();
        try {
            TreeSet<K> set = new TreeSet<K>();
            set.addAll(this.map.keySet());
            TreeSet<K> treeSet = set;
            return treeSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        throw new UnsupportedOperationException("Unsupported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        this.writeLock.lock();
        try {
            V v = this.value(this.map.remove(key));
            return v;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public int size() {
        this.release();
        return this.map.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<V> values() {
        this.release();
        this.readLock.lock();
        try {
            ArrayList list = new ArrayList();
            for (KeyWeakReference<V> ref : this.map.values()) {
                Object val = ref.get();
                if (val == null) continue;
                list.add(val);
            }
            ArrayList arrayList = list;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        KeyWeakReference<V> ret;
        KeyWeakReference<V> sr = new KeyWeakReference<V>(key, value, this.queue);
        this.writeLock.lock();
        try {
            ret = this.map.put(key, sr);
        }
        finally {
            this.writeLock.unlock();
        }
        return this.value(ret);
    }

    private V value(KeyWeakReference<V> ret) {
        return ret == null ? null : (V)ret.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release() {
        this.writeLock.lock();
        try {
            KeyWeakReference sr;
            while ((sr = (KeyWeakReference)this.queue.poll()) != null) {
                this.map.remove(sr.key);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.readLock.lock();
        try {
            String string = this.map.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class KeyWeakReference<T>
    extends WeakReference<T> {
        private K key;

        public KeyWeakReference(K key, T r, ReferenceQueue<? super T> q) {
            super(r, q);
            this.key = key;
        }

        public String toString() {
            Object value = this.get();
            return value == null ? "{null}" : value.toString();
        }
    }
}

