/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.util;

import java.util.zip.Adler32;
import java.util.zip.CRC32;

public class Checksum {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private volatile Adler32 adler32CheckSum = new Adler32();
    private volatile CRC32 crc32CheckSum = new CRC32();
    private static final char[] HEXCHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public Checksum() {
    }

    public Checksum(byte[] data) {
        this();
        this.adler32CheckSum.update(data);
        this.crc32CheckSum.update(data);
    }

    public boolean compareChecksum(byte[] data) {
        if (data == null) {
            return false;
        }
        return this.adler32CheckSum.getValue() == Checksum.calculateAdler32CheckSum(data) && this.crc32CheckSum.getValue() == Checksum.calculateCRC32CheckSum(data);
    }

    public boolean compareChecksum(Checksum checksum) {
        byte[] dst;
        if (checksum == null) {
            return false;
        }
        byte[] src = checksum.getBytes();
        if (src.length != (dst = checksum.getBytes()).length) {
            return false;
        }
        for (int i = 0; i < src.length; ++i) {
            if (src[i] == dst[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(byte[] data) {
        Adler32 adler32 = this.adler32CheckSum;
        synchronized (adler32) {
            this.adler32CheckSum.update(data);
            this.crc32CheckSum.update(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(byte[] data, int offset, int len) {
        Adler32 adler32 = this.adler32CheckSum;
        synchronized (adler32) {
            this.adler32CheckSum.update(data, offset, len);
            this.crc32CheckSum.update(data, offset, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(int data) {
        Adler32 adler32 = this.adler32CheckSum;
        synchronized (adler32) {
            this.adler32CheckSum.update(data);
            this.crc32CheckSum.update(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(boolean data) {
        int val = data ? 1 : 0;
        Adler32 adler32 = this.adler32CheckSum;
        synchronized (adler32) {
            this.adler32CheckSum.update(val);
            this.crc32CheckSum.update(val);
        }
    }

    public void update(Object data) {
        if (data == null) {
            return;
        }
        this.update(data.hashCode());
    }

    private static long calculateAdler32CheckSum(byte[] data) {
        Adler32 adler = new Adler32();
        adler.update(data);
        return adler.getValue();
    }

    private static long calculateCRC32CheckSum(byte[] data) {
        CRC32 crc = new CRC32();
        crc.update(data);
        return crc.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() {
        byte b;
        int i;
        long adler = 0L;
        long crc = 0L;
        Adler32 adler32 = this.adler32CheckSum;
        synchronized (adler32) {
            adler = this.adler32CheckSum.getValue();
            crc = this.crc32CheckSum.getValue();
        }
        byte[] binaryCheckSum = new byte[16];
        for (i = 7; i >= 0; --i) {
            binaryCheckSum[7 - i] = b = (byte)(adler >>> i * 8 & 0xFFL);
        }
        for (i = 7; i >= 0; --i) {
            binaryCheckSum[15 - i] = b = (byte)(crc >>> i * 8 & 0xFFL);
        }
        return binaryCheckSum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getValue() {
        long adler = 0L;
        long crc = 0L;
        Adler32 adler32 = this.adler32CheckSum;
        synchronized (adler32) {
            adler = this.adler32CheckSum.getValue();
            crc = this.crc32CheckSum.getValue();
        }
        return adler << 32 | crc & 0xFFFFFFFFL;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        byte[] checksum = this.getBytes();
        for (int i = 0; i < checksum.length; ++i) {
            int high = checksum[i] >>> 4 & 0xF;
            int low = checksum[i] & 0xF;
            buffer.append(HEXCHARS[high]);
            buffer.append(HEXCHARS[low]);
        }
        return buffer.toString();
    }

    public void reset() {
        this.adler32CheckSum.reset();
        this.crc32CheckSum.reset();
    }
}

