/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.security.model;

import com.ibm.es.nuvo.crawler.security.model.Credential;
import com.ibm.es.nuvo.crawler.security.model.CredentialType;
import com.ibm.es.nuvo.util.Encryption;
import com.ibm.supa.security.UsernamePasswordCredential;

public class UserPasswordCredential
implements Credential,
UsernamePasswordCredential {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private String username = "";
    private String password = "";
    private boolean passwordEncrypted = false;

    public CredentialType getType() {
        return CredentialType.USER_PASSWORD;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String localUsername) {
        this.username = localUsername;
    }

    public String getPassword() {
        if (!this.passwordEncrypted) {
            return this.password;
        }
        try {
            return Encryption.decrypt(this.password);
        }
        catch (Exception e) {
            throw new RuntimeException("Password decryption failed!");
        }
    }

    public void setPassword(String localPassword) {
        try {
            this.password = Encryption.encrypt(localPassword);
            this.passwordEncrypted = true;
        }
        catch (Exception e) {
            System.err.println("Password encryption failed");
            this.password = localPassword;
            this.passwordEncrypted = false;
        }
    }

    public String toString() {
        String toString = "";
        String endln = System.getProperty("line.separator");
        toString = "Username = " + this.username + endln;
        return toString;
    }
}

