/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.security.internal.demo;

import com.ibm.es.nuvo.crawler.security.AccessCheckAdapter;
import com.ibm.es.nuvo.crawler.security.DSSecurityManager;
import com.ibm.es.nuvo.crawler.security.DomainValidationException;
import com.ibm.es.nuvo.crawler.security.internal.UserValidationResultImpl;
import com.ibm.es.nuvo.crawler.security.internal.demo.AccessCheckerDemo;
import com.ibm.es.nuvo.crawler.security.internal.demo.SecurityDomainDemo;
import com.ibm.es.nuvo.crawler.security.internal.demo.UserGroupInformationDemo;
import com.ibm.es.nuvo.crawler.security.internal.demo.UserGroupInformationListDemo;
import com.ibm.es.nuvo.crawler.security.internal.demo.UserValidationResultDemo;
import com.ibm.es.nuvo.crawler.security.model.Identity;
import com.ibm.es.nuvo.crawler.security.model.SecurityDomain;
import com.ibm.es.nuvo.crawler.security.model.UserGroupInformationList;
import com.ibm.es.nuvo.crawler.security.model.UserPasswordCredential;
import com.ibm.es.nuvo.crawler.security.model.UserValidationResult;
import com.ibm.es.nuvo.crawler.util.fenced.WinSecurityProcess;
import com.ibm.es.nuvo.crawler.util.fenced.WinSecurityProcessException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSSecurityManagerImplDemo
implements DSSecurityManager {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    AccessCheckAdapter acAdapter = new AccessCheckerDemo();

    @Override
    public AccessCheckAdapter getAccessCheckAdapter(String collectionID) {
        return this.acAdapter;
    }

    @Override
    public List<SecurityDomain> getAllDomainNames() throws DomainValidationException {
        ArrayList<SecurityDomain> result = new ArrayList<SecurityDomain>();
        SecurityDomainDemo demoDomain = new SecurityDomainDemo();
        demoDomain.setDomainName("default");
        result.add(demoDomain);
        return result;
    }

    @Override
    public List<SecurityDomain> getDomainNames(String collectionID) throws DomainValidationException {
        return this.getAllDomainNames();
    }

    @Override
    public UserGroupInformationList getUserGroupInformationList(Identity identity) throws DomainValidationException {
        return this.getUserInformationDemo(identity);
    }

    @Override
    public UserValidationResult validateUserInformation(Identity identity) throws DomainValidationException {
        UserValidationResultDemo result = new UserValidationResultDemo();
        switch (identity.getCredential().getType()) {
            case USER_PASSWORD: {
                String userName = ((UserPasswordCredential)identity.getCredential()).getUsername();
                if (userName.equals("user1")) {
                    result.setValid(true);
                    break;
                }
                if (userName.equals("user2")) {
                    result.setValid(true);
                    break;
                }
                if (userName.equals("user3")) {
                    result.setValid(true);
                    break;
                }
                result.setValid(false);
                break;
            }
            default: {
                result.setValid(false);
            }
        }
        return result;
    }

    @Override
    public UserValidationResult validateWindowsUserInformation(String uid, String password) throws DomainValidationException {
        WinSecurityProcess process = null;
        try {
            process = new WinSecurityProcess();
            process.init(null);
            process.startProcess();
            boolean brc = process.userValidation(uid, password);
            process.term();
            UserValidationResultImpl resObj = new UserValidationResultImpl();
            resObj.setValid(brc);
            return resObj;
        }
        catch (WinSecurityProcessException wspe) {
            throw new DomainValidationException(wspe);
        }
    }

    private UserGroupInformationList getUserInformationDemo(Identity identity) throws DomainValidationException {
        String userName = "";
        UserValidationResultDemo result = new UserValidationResultDemo();
        switch (identity.getCredential().getType()) {
            case USER_PASSWORD: {
                userName = ((UserPasswordCredential)identity.getCredential()).getUsername();
                break;
            }
            default: {
                result.setValid(false);
            }
        }
        UserGroupInformationListDemo resultList = new UserGroupInformationListDemo();
        if (null != userName && userName.length() > 0) {
            List<UserGroupInformationDemo> tmpList = resultList.getModifiableList();
            UserGroupInformationDemo groupInfo = new UserGroupInformationDemo();
            groupInfo.setCanonicalUsername("canonical_wss_" + userName);
            groupInfo.setSecurityDomainId("default!!sharepoint!!native!!samplesvr.example.ibm.com!!80");
            List<String> groupList = groupInfo.getModifiableGroupNames();
            if (userName.equals("user1")) {
                groupList.add("Server1");
                groupList.add("Group1");
            } else if (userName.equals("user2")) {
                groupList.add("Server2");
                groupList.add("Group2");
            } else if (userName.equals("user3")) {
                groupList.add("Server1");
                groupList.add("Server2");
                groupList.add("Group3");
            }
            tmpList.add(groupInfo);
            UserGroupInformationDemo groupInfo2 = new UserGroupInformationDemo();
            groupInfo2.setCanonicalUsername("canonical_win_" + userName);
            groupInfo2.setSecurityDomainId("default!!windowsfs!!native!!localhost");
            List<String> groupList2 = groupInfo2.getModifiableGroupNames();
            if (userName.equals("user1")) {
                groupList2.add("Server1");
                groupList2.add("Group1");
            } else if (userName.equals("user2")) {
                groupList2.add("Server2");
                groupList2.add("Group2");
            } else if (userName.equals("user3")) {
                groupList2.add("Server1");
                groupList2.add("Server2");
                groupList2.add("Group3");
            }
            tmpList.add(groupInfo2);
        }
        return resultList;
    }

    @Override
    public String getComputerName() throws DomainValidationException {
        return "DemoComputerName";
    }

    @Override
    public String getDomainName() throws DomainValidationException {
        return "DemoDomainName";
    }
}

