/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.security.internal;

import com.ibm.es.nuvo.crawler.security.model.UserGroupInformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserGroupInformationImpl
implements UserGroupInformation {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final int ACLLEVEL_MAX = 3;
    private static final int ACLLEVEL_MIN = 1;
    private static final int ACLLEVEL_DEFAULT = 2;
    private String canonicalUsername = "";
    private String securityDomainId = "";
    private List<String> groupNames = new ArrayList<String>();
    private int aclLevel = 2;

    @Override
    public String getCanonicalUsername() {
        return this.canonicalUsername;
    }

    @Override
    public List<String> getGroupNames() {
        return Collections.unmodifiableList(this.groupNames);
    }

    public void addGroupName(String groupName) {
        this.groupNames.add(groupName);
    }

    public void addAllGroupNames(ArrayList<String> grpNames) {
        this.groupNames.addAll(grpNames);
    }

    @Override
    public String getSecurityDomainId() {
        return this.securityDomainId;
    }

    public void setCanonicalUsername(String cname) {
        if (null != cname && cname.length() > 0) {
            this.canonicalUsername = cname;
        }
    }

    public void setSecurityDomainId(String domainId) {
        if (null != domainId && domainId.length() > 0) {
            this.securityDomainId = domainId;
        }
    }

    @Override
    public int getACLLevel() {
        return this.aclLevel;
    }

    public void setACLLevel(int level) {
        if (level >= 1 && level <= 3) {
            this.aclLevel = level;
        }
    }

    public String toString() {
        StringBuilder toString = new StringBuilder(32);
        String endln = System.getProperty("line.separator");
        toString.append("Security Domain ID = ").append(this.securityDomainId).append(endln).append("Canonical user name = ").append(this.canonicalUsername).append(endln).append("ACL levels = ").append(this.aclLevel).append(endln);
        for (String name : this.groupNames) {
            toString.append("Group name = ").append(name).append(endln);
        }
        return toString.toString();
    }
}

