/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.security.internal;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.adapter.acl.AclNormalizer;
import com.ibm.es.nuvo.crawler.adapter.acl.AclNormalizerException;
import com.ibm.es.nuvo.crawler.adapter.acl.WindowsAclNormalizer;
import com.ibm.es.nuvo.crawler.runtime.BaseCrawlerManager;
import com.ibm.es.nuvo.crawler.security.AccessCheckAdapter;
import com.ibm.es.nuvo.crawler.security.DSSecurityManager;
import com.ibm.es.nuvo.crawler.security.DomainValidationException;
import com.ibm.es.nuvo.crawler.security.internal.AccessChecker;
import com.ibm.es.nuvo.crawler.security.internal.SecurityDomainImpl;
import com.ibm.es.nuvo.crawler.security.internal.UserGroupInformationImpl;
import com.ibm.es.nuvo.crawler.security.internal.UserGroupInformationListImpl;
import com.ibm.es.nuvo.crawler.security.internal.UserValidationResultImpl;
import com.ibm.es.nuvo.crawler.security.model.Credential;
import com.ibm.es.nuvo.crawler.security.model.Identity;
import com.ibm.es.nuvo.crawler.security.model.SecurityDomain;
import com.ibm.es.nuvo.crawler.security.model.UserGroupInformationList;
import com.ibm.es.nuvo.crawler.security.model.UserPasswordCredential;
import com.ibm.es.nuvo.crawler.security.model.UserValidationResult;
import com.ibm.es.nuvo.crawler.util.fenced.WinSecurityProcess;
import com.ibm.es.nuvo.crawler.util.fenced.WinSecurityProcessException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSSecurityManagerImpl
implements DSSecurityManager {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String WIN_DOMAIN_ID = "default!!windowsfs!!native";
    private static final String SHAREPOINT_DOMAIN_ID = "default!!sharepoint!!native";
    private static final String DEFAULT_DOMAIN_NAME = "default";
    private final Map<String, BaseCrawlerManager> crawlerManagers = new HashMap<String, BaseCrawlerManager>();
    private final boolean aclNormalization;

    public DSSecurityManagerImpl(boolean isACLNormalized) {
        this.aclNormalization = isACLNormalized;
    }

    @Override
    public AccessCheckAdapter getAccessCheckAdapter(String collectionID) throws DomainValidationException {
        BaseCrawlerManager mgr = (BaseCrawlerManager)GlobalSystem.getSingleInstance().getGlobalCrawlerManager().getCrawlerManager(collectionID);
        if (null == mgr) {
            Message msg = new Message("C3802E.CRWL_SEC_NOT_FOUND_COLLECTION_ID");
            DomainValidationException dve = new DomainValidationException(msg);
            throw dve;
        }
        AccessChecker checker = new AccessChecker(mgr);
        return checker;
    }

    @Override
    public List<SecurityDomain> getAllDomainNames() throws DomainValidationException {
        SecurityDomainImpl domain = new SecurityDomainImpl();
        domain.setDomainName(DEFAULT_DOMAIN_NAME);
        ArrayList<SecurityDomain> resultList = new ArrayList<SecurityDomain>();
        resultList.add(domain);
        return resultList;
    }

    @Override
    public List<SecurityDomain> getDomainNames(String collectionID) throws DomainValidationException {
        return this.getAllDomainNames();
    }

    @Override
    public UserGroupInformationList getUserGroupInformationList(Identity identity) throws DomainValidationException {
        WinSecurityProcess process = this.getSystemWinSecurityProcess();
        UserGroupInformationListImpl resObj = new UserGroupInformationListImpl();
        try {
            Credential cred = identity.getCredential();
            UserPasswordCredential upCred = (UserPasswordCredential)cred;
            String username = upCred.getUsername();
            String password = upCred.getPassword();
            ArrayList<String> groupList = process.getGroupList(username, password, "");
            WindowsAclNormalizer normalizer = new WindowsAclNormalizer();
            if (this.aclNormalization) {
                try {
                    ArrayList<String> normalizedGroupList = new ArrayList<String>(groupList.size());
                    for (String groupName : groupList) {
                        String normalizedGroupName = ((AclNormalizer)normalizer).normalize(groupName);
                        normalizedGroupList.add(normalizedGroupName);
                    }
                    groupList = normalizedGroupList;
                }
                catch (AclNormalizerException ane) {
                    throw new DomainValidationException(ane);
                }
            }
            UserGroupInformationImpl ugInfo = new UserGroupInformationImpl();
            ugInfo.addAllGroupNames(groupList);
            ugInfo.setCanonicalUsername(username);
            ugInfo.setSecurityDomainId(WIN_DOMAIN_ID);
            resObj.addGroupInformation(ugInfo);
            ugInfo = new UserGroupInformationImpl();
            ugInfo.addAllGroupNames(groupList);
            ugInfo.setCanonicalUsername(username);
            ugInfo.setSecurityDomainId(SHAREPOINT_DOMAIN_ID);
            resObj.addGroupInformation(ugInfo);
        }
        catch (WinSecurityProcessException wspe) {
            throw new DomainValidationException(wspe);
        }
        return resObj;
    }

    @Override
    public UserValidationResult validateUserInformation(Identity identity) throws DomainValidationException {
        WinSecurityProcess process = this.getSystemWinSecurityProcess();
        UserValidationResultImpl resObj = new UserValidationResultImpl();
        try {
            Credential cred = identity.getCredential();
            UserPasswordCredential upCred = (UserPasswordCredential)cred;
            boolean brc = process.userValidation(upCred.getUsername(), upCred.getPassword());
            resObj.setValid(brc);
        }
        catch (WinSecurityProcessException wspe) {
            throw new DomainValidationException(wspe);
        }
        return resObj;
    }

    @Override
    public UserValidationResult validateWindowsUserInformation(String uid, String password) throws DomainValidationException {
        WinSecurityProcess process = null;
        try {
            process = new WinSecurityProcess();
            process.init(null);
            process.startProcess();
            boolean brc = process.userValidation(uid, password);
            process.term();
            UserValidationResultImpl resObj = new UserValidationResultImpl();
            resObj.setValid(brc);
            return resObj;
        }
        catch (WinSecurityProcessException wspe) {
            throw new DomainValidationException(wspe);
        }
    }

    public void registerCrawlerManager(String collectionId, BaseCrawlerManager mgr) {
        this.crawlerManagers.put(collectionId, mgr);
    }

    public void unregisterCrawlerManager(String collectionId) {
        this.crawlerManagers.remove(collectionId);
    }

    private WinSecurityProcess getSystemWinSecurityProcess() {
        WinSecurityProcess process = GlobalSystem.getSingleInstance().getGlobalCrawlerManager().getFencedWinSecurityProcess();
        return process;
    }

    @Override
    public String getComputerName() throws DomainValidationException {
        WinSecurityProcess process = null;
        String computerName = null;
        try {
            process = new WinSecurityProcess();
            process.init(null);
            process.startProcess();
            computerName = process.getComputerName();
            process.term();
        }
        catch (WinSecurityProcessException wspe) {
            throw new DomainValidationException(wspe);
        }
        return computerName;
    }

    @Override
    public String getDomainName() throws DomainValidationException {
        WinSecurityProcess process = null;
        String domainName = null;
        try {
            process = new WinSecurityProcess();
            process.init(null);
            process.startProcess();
            domainName = process.getDomainName();
            process.term();
        }
        catch (WinSecurityProcessException wspe) {
            throw new DomainValidationException(wspe);
        }
        return domainName;
    }
}

