/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.security.internal;

import com.ibm.es.nuvo.crawler.adapter.Adapter;
import com.ibm.es.nuvo.crawler.adapter.AdapterException;
import com.ibm.es.nuvo.crawler.adapter.Credentials;
import com.ibm.es.nuvo.crawler.adapter.ItemFinder;
import com.ibm.es.nuvo.crawler.adapter.ItemSet;
import com.ibm.es.nuvo.crawler.adapter.PublicItemFinder;
import com.ibm.es.nuvo.crawler.adapter.UserPasswordCredentials;
import com.ibm.es.nuvo.crawler.admin.CrawlSpaceControl;
import com.ibm.es.nuvo.crawler.admin.CrawlerControl;
import com.ibm.es.nuvo.crawler.admin.CrawlerControlException;
import com.ibm.es.nuvo.crawler.runtime.BaseCrawlerManager;
import com.ibm.es.nuvo.crawler.security.AccessCheckAdapter;
import com.ibm.es.nuvo.crawler.security.DomainValidationException;
import com.ibm.es.nuvo.crawler.security.internal.DocumentResultSetImpl;
import com.ibm.es.nuvo.crawler.security.model.Credential;
import com.ibm.es.nuvo.crawler.security.model.DocumentResult;
import com.ibm.es.nuvo.crawler.security.model.DocumentResultSet;
import com.ibm.es.nuvo.crawler.security.model.Identity;
import com.ibm.es.nuvo.crawler.security.model.UserPasswordCredential;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessChecker
implements AccessCheckAdapter {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private BaseCrawlerManager crawlerManager;
    private Map<String, TypeIDPair> reverseIDMap = new HashMap<String, TypeIDPair>();

    @Deprecated
    public AccessChecker() {
    }

    public AccessChecker(BaseCrawlerManager mgr) {
        this.crawlerManager = mgr;
        this.buildIDMap();
    }

    private void buildIDMap() {
        try {
            CrawlerControl[] crawlerControls = this.crawlerManager.getAvailableCrawlerControls();
            for (int i = 0; i < crawlerControls.length; ++i) {
                CrawlSpaceControl[] spaceControls = this.crawlerManager.getAvailableCrawlSpaceControls(crawlerControls[i].getID());
                for (int j = 0; j < spaceControls.length; ++j) {
                    TypeIDPair value = new TypeIDPair();
                    value.setId(crawlerControls[i].getID());
                    value.setType(crawlerControls[i].getType());
                    this.reverseIDMap.put(spaceControls[j].getID(), value);
                }
            }
        }
        catch (CrawlerControlException crawlerControlException) {
            // empty catch block
        }
    }

    @Override
    public DocumentResultSet validateDocumentResult(DocumentResultSet interimResult, List<Identity> identities) throws DomainValidationException {
        DocumentResultSetImpl securedResult = new DocumentResultSetImpl();
        securedResult.setBlockSize(interimResult.getBlockSize());
        UserPasswordCredential cred = new UserPasswordCredential();
        if (identities != null && identities.size() > 0) {
            Identity identity = identities.get(0);
            cred = (UserPasswordCredential)identity.getCredential();
        }
        Iterator<DocumentResult> iter = interimResult.iterator();
        while (iter.hasNext() && !securedResult.hasEnoughResults()) {
            DocumentResult aResult = iter.next();
            String crawlSpaceId = aResult.getCrawlSpaceId();
            TypeIDPair typeId = this.reverseIDMap.get(crawlSpaceId);
            ItemFinder finder = null;
            if (null != typeId) {
                String crawlerId = this.reverseIDMap.get(crawlSpaceId).getId();
                String crawlerType = this.reverseIDMap.get(crawlSpaceId).getType();
                try {
                    Adapter adapter = this.crawlerManager.getAdapter(crawlerType, crawlerId);
                    finder = adapter.createItemFinder(AccessChecker.credentialBridge(cred));
                }
                catch (AdapterException ae) {
                    finder = new PublicItemFinder();
                }
            }
            if (null == finder) {
                finder = new PublicItemFinder();
            }
            try {
                ((ItemFinder)finder).addItem(aResult.getURI());
                ItemSet resultSet = ((ItemFinder)finder).execute();
                boolean result = resultSet.next();
                if (result) {
                    securedResult.addDocumentResult(aResult);
                }
                resultSet.close();
            }
            catch (AdapterException ae) {}
        }
        return securedResult;
    }

    public static final Credentials credentialBridge(Credential cred) {
        UserPasswordCredential securityCred = (UserPasswordCredential)cred;
        UserPasswordCredentials adapterCred = new UserPasswordCredentials(securityCred.getUsername(), securityCred.getPassword());
        return adapterCred;
    }

    static class TypeIDPair {
        private String id = "";
        private String type = "";

        TypeIDPair() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

