/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.scheduler;

import com.ibm.es.nuvo.crawler.scheduler.Schedule;
import com.ibm.es.nuvo.crawler.scheduler.ScheduledTask;
import com.ibm.es.nuvo.crawler.scheduler.Scheduler;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public final class SingleThreadScheduler
implements Scheduler {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private final Timer timer;

    public SingleThreadScheduler() {
        this.timer = new Timer();
    }

    public SingleThreadScheduler(String name) {
        this.timer = new Timer(name);
    }

    public void shutdown() {
        this.timer.cancel();
    }

    public ScheduledTask schedule(Runnable command, Schedule schedule) {
        return this.schedule(new ScheduledTimerTask(command), schedule, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScheduledTimerTask schedule(ScheduledTimerTask task, Schedule schedule, boolean reschedule) {
        Date time = schedule.next();
        if (time == null) {
            task.cancel();
        } else {
            Object object = task.lock;
            synchronized (object) {
                if (!reschedule && task.state != TaskState.INIT) {
                    throw new IllegalStateException("Task already scheduled or cancelled");
                }
                if (task.state != TaskState.CANCELLED) {
                    task.state = TaskState.SCHEDULED;
                    task.timerTask = new SchedulerTimerTask(task, schedule);
                    task.time = time;
                    this.timer.schedule(task.timerTask, time);
                }
            }
        }
        return task;
    }

    private class SchedulerTimerTask
    extends TimerTask {
        private final ScheduledTimerTask task;
        private final Schedule schedule;

        public SchedulerTimerTask(ScheduledTimerTask task, Schedule schedule) {
            this.task = task;
            this.schedule = schedule;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.task.command.run();
            }
            finally {
                SingleThreadScheduler.this.schedule(this.task, this.schedule, true);
            }
        }
    }

    private static final class ScheduledTimerTask
    implements ScheduledTask {
        private final Runnable command;
        private final Object lock;
        private TaskState state;
        private TimerTask timerTask;
        private Date time;

        private ScheduledTimerTask(Runnable command) {
            if (command == null) {
                throw new NullPointerException();
            }
            this.command = command;
            this.lock = new Object();
            this.state = TaskState.INIT;
            this.timerTask = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cancel() {
            Object object = this.lock;
            synchronized (object) {
                if (this.timerTask != null) {
                    this.timerTask.cancel();
                }
                boolean result = this.state == TaskState.SCHEDULED;
                this.state = TaskState.CANCELLED;
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCancelled() {
            Object object = this.lock;
            synchronized (object) {
                return this.state == TaskState.CANCELLED;
            }
        }

        public Date getScheduledTime() {
            return this.time;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TaskState {
        INIT,
        SCHEDULED,
        CANCELLED;

    }
}

