/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.scheduler;

import com.ibm.es.nuvo.crawler.scheduler.Schedule;
import java.util.Calendar;
import java.util.Date;

public final class IntervalSchedule
implements Schedule {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private final int field;
    private final int interval;
    private final IntervalUnit unit;
    private final Calendar calendar;

    public IntervalSchedule(Date start, int interval, IntervalUnit unit) {
        if (start == null || unit == null) {
            throw new NullPointerException();
        }
        if (interval <= 0) {
            throw new IllegalArgumentException();
        }
        long now = System.currentTimeMillis();
        this.interval = interval;
        this.unit = unit;
        this.calendar = Calendar.getInstance();
        this.calendar.setTime(start);
        switch (this.unit) {
            case YEAR: {
                this.field = 1;
                break;
            }
            case MONTH: {
                this.field = 2;
                break;
            }
            case WEEK: {
                this.field = 3;
                break;
            }
            case DAY: {
                this.field = 5;
                break;
            }
            case HOUR: {
                this.field = 11;
                break;
            }
            case MINUTE: {
                this.field = 12;
                break;
            }
            case SECOND: {
                this.field = 13;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (this.calendar.getTime().before(new Date(now))) {
            this.calendar.add(this.field, this.interval);
            long intervalInMills = this.calendar.getTimeInMillis() - start.getTime();
            long newStart = (now - start.getTime()) / intervalInMills * intervalInMills + start.getTime();
            this.calendar.setTimeInMillis(newStart);
        }
        if (this.calendar.getTime().after(new Date(now))) {
            this.calendar.add(this.field, -this.interval);
        }
    }

    public Date next() {
        this.calendar.add(this.field, this.interval);
        return this.calendar.getTime();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IntervalUnit {
        SECOND,
        MINUTE,
        HOUR,
        DAY,
        WEEK,
        MONTH,
        YEAR;

    }
}

