/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.scheduler;

import com.ibm.es.nuvo.crawler.scheduler.CompositeSchedule;
import com.ibm.es.nuvo.crawler.scheduler.IntervalSchedule;
import com.ibm.es.nuvo.crawler.scheduler.Schedule;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DaysOfWeekSchedule
implements Schedule {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private final CompositeSchedule composite;

    public DaysOfWeekSchedule(Date start, EnumSet<DayOfWeek> days) {
        if (start == null || days == null) {
            throw new NullPointerException();
        }
        if (days.isEmpty()) {
            throw new IllegalArgumentException();
        }
        ArrayList<IntervalSchedule> schedules = new ArrayList<IntervalSchedule>();
        for (DayOfWeek day : days) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(start);
            int diff = DaysOfWeekSchedule.diffDayOfWeek(calendar.get(7), day);
            calendar.add(5, diff);
            schedules.add(new IntervalSchedule(calendar.getTime(), 1, IntervalSchedule.IntervalUnit.WEEK));
        }
        this.composite = new CompositeSchedule(schedules.toArray(new Schedule[0]));
    }

    private static final int diffDayOfWeek(int source, DayOfWeek target) {
        int sourceDay = 0;
        int targetDay = 0;
        switch (source) {
            case 1: {
                sourceDay = 0;
                break;
            }
            case 2: {
                sourceDay = 1;
                break;
            }
            case 3: {
                sourceDay = 2;
                break;
            }
            case 4: {
                sourceDay = 3;
                break;
            }
            case 5: {
                sourceDay = 4;
                break;
            }
            case 6: {
                sourceDay = 5;
                break;
            }
            case 7: {
                sourceDay = 6;
            }
        }
        switch (target) {
            case SUNDAY: {
                targetDay = 0;
                break;
            }
            case MONDAY: {
                targetDay = 1;
                break;
            }
            case TUESDAY: {
                targetDay = 2;
                break;
            }
            case WEDNESDAY: {
                targetDay = 3;
                break;
            }
            case THURSDAY: {
                targetDay = 4;
                break;
            }
            case FRIDAY: {
                targetDay = 5;
                break;
            }
            case SATURDAY: {
                targetDay = 6;
            }
        }
        return targetDay - sourceDay;
    }

    @Override
    public Date next() {
        return this.composite.next();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DayOfWeek {
        SUNDAY,
        MONDAY,
        TUESDAY,
        WEDNESDAY,
        THURSDAY,
        FRIDAY,
        SATURDAY;

    }
}

