/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.scheduler;

import com.ibm.es.nuvo.crawler.scheduler.Schedule;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class CompositeSchedule
implements Schedule {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private Map<Schedule, Date> schedules = new HashMap<Schedule, Date>();

    public CompositeSchedule(Schedule[] schedules) {
        for (int i = 0; i < schedules.length; ++i) {
            this.add(schedules[i]);
        }
    }

    private void add(Schedule schedule) {
        Date time = schedule.next();
        if (time == null) {
            this.schedules.remove(schedule);
            return;
        }
        this.schedules.put(schedule, time);
    }

    public synchronized Date next() {
        Date min = null;
        Schedule schedule = null;
        for (Map.Entry<Schedule, Date> entry : this.schedules.entrySet()) {
            Date date = entry.getValue();
            if (min != null && (date == null || min.getTime() <= date.getTime())) continue;
            min = date;
            schedule = entry.getKey();
        }
        if (min != null && schedule != null) {
            this.add(schedule);
            return min;
        }
        return null;
    }
}

