/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.runtime;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.runtime.UserPluginException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;

public final class UserPluginManager {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final String LOCAL_FILEPREFIX = "file:///";
    HashMap<String, Object> pluginMap;
    Object syncPluginMap = new Object();

    public UserPluginManager() {
        this.pluginMap = new HashMap();
    }

    public void intiaialize() {
    }

    public void terminalize() {
    }

    public Object setClassInfo(String classname, String pathnames) throws UserPluginException {
        Object rcObj = null;
        String[] pathList = null;
        if (pathnames != null) {
            pathList = pathnames.split(File.pathSeparator);
        }
        rcObj = this.setClassInfo(classname, pathList);
        return rcObj;
    }

    public Object setClassInfo(String pClsName, String[] paths) throws UserPluginException {
        Object rcObj = null;
        try {
            URL[] urls = null;
            if (paths != null) {
                urls = new URL[paths.length];
                for (int i = 0; i < paths.length; ++i) {
                    try {
                        urls[i] = new URL(LOCAL_FILEPREFIX + paths[i]);
                        continue;
                    }
                    catch (MalformedURLException male) {
                        Message msg = new Message("C3532E.CRWL_PLUGIN_CLASS_NOT_FOUND");
                        msg.addArgument(pClsName);
                        StringBuffer sb = new StringBuffer();
                        for (String path : paths) {
                            sb.append(path).append(File.pathSeparator);
                        }
                        msg.addArgument(sb.toString());
                        throw new UserPluginException(msg, (Throwable)male);
                    }
                }
            } else {
                urls = new URL[]{};
            }
            ClassLoader currentLoader = this.getClass().getClassLoader();
            URLClassLoader subLoader = new URLClassLoader(urls, currentLoader);
            Class<?> pluginClass = subLoader.loadClass(pClsName);
            rcObj = pluginClass.newInstance();
            return rcObj;
        }
        catch (ClassNotFoundException cnfe) {
            Message msg = new Message("C3532E.CRWL_PLUGIN_CLASS_NOT_FOUND");
            msg.addArgument(pClsName);
            StringBuffer sb = new StringBuffer();
            if (paths != null) {
                for (String path : paths) {
                    sb.append(path).append(File.pathSeparator);
                }
            }
            msg.addArgument(sb.toString());
            throw new UserPluginException(msg, (Throwable)cnfe);
        }
        catch (InstantiationException ie) {
            Message msg = new Message("C3532E.CRWL_PLUGIN_CLASS_NOT_FOUND");
            msg.addArgument(pClsName);
            StringBuffer sb = new StringBuffer();
            if (paths != null) {
                for (String path : paths) {
                    sb.append(path).append(File.pathSeparator);
                }
            }
            msg.addArgument(sb.toString());
            throw new UserPluginException(msg, (Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            Message msg = new Message("C3532E.CRWL_PLUGIN_CLASS_NOT_FOUND");
            msg.addArgument(pClsName);
            StringBuffer sb = new StringBuffer();
            if (paths != null) {
                for (String path : paths) {
                    sb.append(path).append(File.pathSeparator);
                }
            }
            msg.addArgument(sb.toString());
            throw new UserPluginException(msg, (Throwable)iae);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String spaceId, Object obj) {
        Object object = this.syncPluginMap;
        synchronized (object) {
            this.pluginMap.put(spaceId, obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate(String spaceId) {
        Object object = this.syncPluginMap;
        synchronized (object) {
            this.pluginMap.remove(spaceId);
        }
    }
}

