/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.runtime;

import com.ibm.es.nuvo.crawler.adapter.AdapterException;
import com.ibm.es.nuvo.crawler.adapter.ConfigurationElement;
import com.ibm.es.nuvo.crawler.adapter.ConfigurationMap;
import com.ibm.es.nuvo.crawler.adapter.ListConfiguration;
import com.ibm.es.nuvo.crawler.adapter.Space;
import com.ibm.es.nuvo.crawler.admin.Configuration;
import com.ibm.es.nuvo.crawler.admin.ConfigurationItem;
import com.ibm.es.nuvo.crawler.admin.CrawlerConfigurationException;
import com.ibm.es.nuvo.crawler.admin.SpaceConfiguration;
import java.util.Collection;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceManager {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    public void closeResource(Space space) {
        Space parent = null;
        while (space != null) {
            parent = space.getParent();
            try {
                space.close();
            }
            catch (AdapterException adapterException) {
                // empty catch block
            }
            space = parent;
        }
    }

    public Space openResource(SpaceConfiguration spaceConfig, Space space) throws AdapterException, CrawlerConfigurationException, IllegalAccessError {
        ConfigurationItem current;
        Stack<SpaceConfiguration> stack = new Stack<SpaceConfiguration>();
        for (current = spaceConfig; current != null; current = current.getParent()) {
            stack.push((SpaceConfiguration)current);
        }
        current = (ConfigurationItem)stack.pop();
        while (!stack.isEmpty()) {
            this.applyConfig(current.getConfigurations().values(), space.getConfigurations());
            space.open();
            current = (ConfigurationItem)stack.pop();
            space = space.getSubSpace(current.getName());
        }
        this.applyConfig(current.getConfigurations().values(), space.getConfigurations());
        space.open();
        this.applyConfig(spaceConfig.getCrawlSpaceConfigurations().values(), space.getCrawlSpaceConfigurations());
        return space;
    }

    private void applyConfig(Collection<Configuration> source, ConfigurationMap target) throws AdapterException {
        block6: for (Configuration sourceElt : source) {
            ConfigurationElement targetElt = target.get(sourceElt.getName());
            if (targetElt == null) continue;
            switch (targetElt.getType()) {
                case STRING: {
                    targetElt.setString(sourceElt.getString());
                    break;
                }
                case BOOLEAN: {
                    targetElt.setBoolean(sourceElt.getBoolean());
                    break;
                }
                case LONG: {
                    targetElt.setLong(sourceElt.getLong());
                    break;
                }
                case LIST: {
                    ListConfiguration targetList = targetElt.getList();
                    for (Configuration.ListItem sourceItem : sourceElt.getItems()) {
                        ListConfiguration.Item targetItem = targetList.get(sourceItem.getValue());
                        if (targetItem != null) {
                            targetItem.setSelected(sourceItem.isSelected());
                            continue;
                        }
                        targetList.add(sourceItem.getValue()).setSelected(sourceItem.isSelected());
                    }
                    continue block6;
                }
            }
        }
    }
}

